/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class FleetMembersResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="character_id")
    private Integer characterId = null;
    @JsonProperty(value="ship_type_id")
    private Integer shipTypeId = null;
    @JsonProperty(value="wing_id")
    private Long wingId = null;
    @JsonProperty(value="squad_id")
    private Long squadId = null;
    @JsonProperty(value="role")
    private RoleEnum role = null;
    @JsonProperty(value="role_name")
    private String roleName = null;
    @JsonProperty(value="join_time")
    private OffsetDateTime joinTime = null;
    @JsonProperty(value="takes_fleet_warp")
    private Boolean takesFleetWarp = null;
    @JsonProperty(value="solar_system_id")
    private Integer solarSystemId = null;
    @JsonProperty(value="station_id")
    private Long stationId = null;

    public FleetMembersResponse characterId(Integer n) {
        this.characterId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="character_id integer")
    public Integer getCharacterId() {
        return this.characterId;
    }

    public void setCharacterId(Integer n) {
        this.characterId = n;
    }

    public FleetMembersResponse shipTypeId(Integer n) {
        this.shipTypeId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ship_type_id integer")
    public Integer getShipTypeId() {
        return this.shipTypeId;
    }

    public void setShipTypeId(Integer n) {
        this.shipTypeId = n;
    }

    public FleetMembersResponse wingId(Long l) {
        this.wingId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the wing the member is in. If not applicable, will be set to -1")
    public Long getWingId() {
        return this.wingId;
    }

    public void setWingId(Long l) {
        this.wingId = l;
    }

    public FleetMembersResponse squadId(Long l) {
        this.squadId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the squad the member is in. If not applicable, will be set to -1")
    public Long getSquadId() {
        return this.squadId;
    }

    public void setSquadId(Long l) {
        this.squadId = l;
    }

    public FleetMembersResponse role(RoleEnum roleEnum) {
        this.role = roleEnum;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Member\u2019s role in fleet")
    public RoleEnum getRole() {
        return this.role;
    }

    public void setRole(RoleEnum roleEnum) {
        this.role = roleEnum;
    }

    public FleetMembersResponse roleName(String string) {
        this.roleName = string;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Localized role names")
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String string) {
        this.roleName = string;
    }

    public FleetMembersResponse joinTime(OffsetDateTime offsetDateTime) {
        this.joinTime = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="join_time string")
    public OffsetDateTime getJoinTime() {
        return this.joinTime;
    }

    public void setJoinTime(OffsetDateTime offsetDateTime) {
        this.joinTime = offsetDateTime;
    }

    public FleetMembersResponse takesFleetWarp(Boolean bl) {
        this.takesFleetWarp = bl;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether the member take fleet warps")
    public Boolean getTakesFleetWarp() {
        return this.takesFleetWarp;
    }

    public void setTakesFleetWarp(Boolean bl) {
        this.takesFleetWarp = bl;
    }

    public FleetMembersResponse solarSystemId(Integer n) {
        this.solarSystemId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Solar system the member is located in")
    public Integer getSolarSystemId() {
        return this.solarSystemId;
    }

    public void setSolarSystemId(Integer n) {
        this.solarSystemId = n;
    }

    public FleetMembersResponse stationId(Long l) {
        this.stationId = l;
        return this;
    }

    @ApiModelProperty(example="null", value="Station in which the member is docked in, if applicable")
    public Long getStationId() {
        return this.stationId;
    }

    public void setStationId(Long l) {
        this.stationId = l;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FleetMembersResponse fleetMembersResponse = (FleetMembersResponse)object;
        return Objects.equals(this.characterId, fleetMembersResponse.characterId) && Objects.equals(this.shipTypeId, fleetMembersResponse.shipTypeId) && Objects.equals(this.wingId, fleetMembersResponse.wingId) && Objects.equals(this.squadId, fleetMembersResponse.squadId) && Objects.equals((Object)this.role, (Object)fleetMembersResponse.role) && Objects.equals(this.roleName, fleetMembersResponse.roleName) && Objects.equals(this.joinTime, fleetMembersResponse.joinTime) && Objects.equals(this.takesFleetWarp, fleetMembersResponse.takesFleetWarp) && Objects.equals(this.solarSystemId, fleetMembersResponse.solarSystemId) && Objects.equals(this.stationId, fleetMembersResponse.stationId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.characterId, this.shipTypeId, this.wingId, this.squadId, this.role, this.roleName, this.joinTime, this.takesFleetWarp, this.solarSystemId, this.stationId});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class FleetMembersResponse {\n");
        stringBuilder.append("    characterId: ").append(this.toIndentedString(this.characterId)).append("\n");
        stringBuilder.append("    shipTypeId: ").append(this.toIndentedString(this.shipTypeId)).append("\n");
        stringBuilder.append("    wingId: ").append(this.toIndentedString(this.wingId)).append("\n");
        stringBuilder.append("    squadId: ").append(this.toIndentedString(this.squadId)).append("\n");
        stringBuilder.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        stringBuilder.append("    roleName: ").append(this.toIndentedString(this.roleName)).append("\n");
        stringBuilder.append("    joinTime: ").append(this.toIndentedString(this.joinTime)).append("\n");
        stringBuilder.append("    takesFleetWarp: ").append(this.toIndentedString(this.takesFleetWarp)).append("\n");
        stringBuilder.append("    solarSystemId: ").append(this.toIndentedString(this.solarSystemId)).append("\n");
        stringBuilder.append("    stationId: ").append(this.toIndentedString(this.stationId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    public static enum RoleEnum {
        FLEET_COMMANDER("fleet_commander"),
        WING_COMMANDER("wing_commander"),
        SQUAD_COMMANDER("squad_commander"),
        SQUAD_MEMBER("squad_member");

        private String value;

        private RoleEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoleEnum fromValue(String string) {
            for (RoleEnum roleEnum : RoleEnum.values()) {
                if (!String.valueOf(roleEnum.value).equals(string)) continue;
                return roleEnum;
            }
            return null;
        }
    }
}

