/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import net.troja.eve.esi.model.StructureService;
import net.troja.eve.esi.model.VulnerabilityWindow;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class CorporationStructuresResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("structure_id")
    private Long structureId = null;

    @JsonProperty("type_id")
    private Integer typeId = null;

    @JsonProperty("corporation_id")
    private Integer corporationId = null;

    @JsonProperty("system_id")
    private Integer systemId = null;

    @JsonProperty("profile_id")
    private Integer profileId = null;

    @JsonProperty("fuel_expires")
    private OffsetDateTime fuelExpires = null;

    @JsonProperty("services")
    private List<StructureService> services = new ArrayList<StructureService>();

    @JsonProperty("state_timer_start")
    private OffsetDateTime stateTimerStart = null;

    @JsonProperty("state_timer_end")
    private OffsetDateTime stateTimerEnd = null;

    @JsonProperty("unanchors_at")
    private OffsetDateTime unanchorsAt = null;

    @JsonProperty("current_vul")
    private List<VulnerabilityWindow> currentVul = new ArrayList<VulnerabilityWindow>();

    @JsonProperty("next_vul")
    private List<VulnerabilityWindow> nextVul = new ArrayList<VulnerabilityWindow>();

    public CorporationStructuresResponse structureId(Long structureId) {
        this.structureId = structureId;
        return this;
    }

    /**
     * The Item ID of the structure
     * 
     * @return structureId
     **/
    @ApiModelProperty(example = "null", required = true, value = "The Item ID of the structure")
    public Long getStructureId() {
        return structureId;
    }

    public void setStructureId(Long structureId) {
        this.structureId = structureId;
    }

    public CorporationStructuresResponse typeId(Integer typeId) {
        this.typeId = typeId;
        return this;
    }

    /**
     * The type id of the structure
     * 
     * @return typeId
     **/
    @ApiModelProperty(example = "null", required = true, value = "The type id of the structure")
    public Integer getTypeId() {
        return typeId;
    }

    public void setTypeId(Integer typeId) {
        this.typeId = typeId;
    }

    public CorporationStructuresResponse corporationId(Integer corporationId) {
        this.corporationId = corporationId;
        return this;
    }

    /**
     * ID of the corporation that owns the structure
     * 
     * @return corporationId
     **/
    @ApiModelProperty(example = "null", required = true, value = "ID of the corporation that owns the structure")
    public Integer getCorporationId() {
        return corporationId;
    }

    public void setCorporationId(Integer corporationId) {
        this.corporationId = corporationId;
    }

    public CorporationStructuresResponse systemId(Integer systemId) {
        this.systemId = systemId;
        return this;
    }

    /**
     * The solar system the structure is in
     * 
     * @return systemId
     **/
    @ApiModelProperty(example = "null", required = true, value = "The solar system the structure is in")
    public Integer getSystemId() {
        return systemId;
    }

    public void setSystemId(Integer systemId) {
        this.systemId = systemId;
    }

    public CorporationStructuresResponse profileId(Integer profileId) {
        this.profileId = profileId;
        return this;
    }

    /**
     * The id of the ACL profile for this citadel
     * 
     * @return profileId
     **/
    @ApiModelProperty(example = "null", required = true, value = "The id of the ACL profile for this citadel")
    public Integer getProfileId() {
        return profileId;
    }

    public void setProfileId(Integer profileId) {
        this.profileId = profileId;
    }

    public CorporationStructuresResponse fuelExpires(OffsetDateTime fuelExpires) {
        this.fuelExpires = fuelExpires;
        return this;
    }

    /**
     * Date on which the structure will run out of fuel
     * 
     * @return fuelExpires
     **/
    @ApiModelProperty(example = "null", value = "Date on which the structure will run out of fuel")
    public OffsetDateTime getFuelExpires() {
        return fuelExpires;
    }

    public void setFuelExpires(OffsetDateTime fuelExpires) {
        this.fuelExpires = fuelExpires;
    }

    public CorporationStructuresResponse services(List<StructureService> services) {
        this.services = services;
        return this;
    }

    public CorporationStructuresResponse addServicesItem(StructureService servicesItem) {
        this.services.add(servicesItem);
        return this;
    }

    /**
     * Contains a list of service upgrades, and their state
     * 
     * @return services
     **/
    @ApiModelProperty(example = "null", value = "Contains a list of service upgrades, and their state")
    public List<StructureService> getServices() {
        return services;
    }

    public void setServices(List<StructureService> services) {
        this.services = services;
    }

    public CorporationStructuresResponse stateTimerStart(OffsetDateTime stateTimerStart) {
        this.stateTimerStart = stateTimerStart;
        return this;
    }

    /**
     * Date at which the structure entered it's current state
     * 
     * @return stateTimerStart
     **/
    @ApiModelProperty(example = "null", value = "Date at which the structure entered it's current state")
    public OffsetDateTime getStateTimerStart() {
        return stateTimerStart;
    }

    public void setStateTimerStart(OffsetDateTime stateTimerStart) {
        this.stateTimerStart = stateTimerStart;
    }

    public CorporationStructuresResponse stateTimerEnd(OffsetDateTime stateTimerEnd) {
        this.stateTimerEnd = stateTimerEnd;
        return this;
    }

    /**
     * Date at which the structure will move to it's next state
     * 
     * @return stateTimerEnd
     **/
    @ApiModelProperty(example = "null", value = "Date at which the structure will move to it's next state")
    public OffsetDateTime getStateTimerEnd() {
        return stateTimerEnd;
    }

    public void setStateTimerEnd(OffsetDateTime stateTimerEnd) {
        this.stateTimerEnd = stateTimerEnd;
    }

    public CorporationStructuresResponse unanchorsAt(OffsetDateTime unanchorsAt) {
        this.unanchorsAt = unanchorsAt;
        return this;
    }

    /**
     * Date at which the structure will unanchor
     * 
     * @return unanchorsAt
     **/
    @ApiModelProperty(example = "null", value = "Date at which the structure will unanchor")
    public OffsetDateTime getUnanchorsAt() {
        return unanchorsAt;
    }

    public void setUnanchorsAt(OffsetDateTime unanchorsAt) {
        this.unanchorsAt = unanchorsAt;
    }

    public CorporationStructuresResponse currentVul(List<VulnerabilityWindow> currentVul) {
        this.currentVul = currentVul;
        return this;
    }

    public CorporationStructuresResponse addCurrentVulItem(VulnerabilityWindow currentVulItem) {
        this.currentVul.add(currentVulItem);
        return this;
    }

    /**
     * This week's vulnerability windows, Monday is day 0
     * 
     * @return currentVul
     **/
    @ApiModelProperty(example = "null", required = true, value = "This week's vulnerability windows, Monday is day 0")
    public List<VulnerabilityWindow> getCurrentVul() {
        return currentVul;
    }

    public void setCurrentVul(List<VulnerabilityWindow> currentVul) {
        this.currentVul = currentVul;
    }

    public CorporationStructuresResponse nextVul(List<VulnerabilityWindow> nextVul) {
        this.nextVul = nextVul;
        return this;
    }

    public CorporationStructuresResponse addNextVulItem(VulnerabilityWindow nextVulItem) {
        this.nextVul.add(nextVulItem);
        return this;
    }

    /**
     * Next week's vulnerability windows, Monday is day 0
     * 
     * @return nextVul
     **/
    @ApiModelProperty(example = "null", required = true, value = "Next week's vulnerability windows, Monday is day 0")
    public List<VulnerabilityWindow> getNextVul() {
        return nextVul;
    }

    public void setNextVul(List<VulnerabilityWindow> nextVul) {
        this.nextVul = nextVul;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CorporationStructuresResponse corporationStructuresResponse = (CorporationStructuresResponse) o;
        return Objects.equals(this.structureId, corporationStructuresResponse.structureId)
                && Objects.equals(this.typeId, corporationStructuresResponse.typeId)
                && Objects.equals(this.corporationId, corporationStructuresResponse.corporationId)
                && Objects.equals(this.systemId, corporationStructuresResponse.systemId)
                && Objects.equals(this.profileId, corporationStructuresResponse.profileId)
                && Objects.equals(this.fuelExpires, corporationStructuresResponse.fuelExpires)
                && Objects.equals(this.services, corporationStructuresResponse.services)
                && Objects.equals(this.stateTimerStart, corporationStructuresResponse.stateTimerStart)
                && Objects.equals(this.stateTimerEnd, corporationStructuresResponse.stateTimerEnd)
                && Objects.equals(this.unanchorsAt, corporationStructuresResponse.unanchorsAt)
                && Objects.equals(this.currentVul, corporationStructuresResponse.currentVul)
                && Objects.equals(this.nextVul, corporationStructuresResponse.nextVul);
    }

    @Override
    public int hashCode() {
        return Objects.hash(structureId, typeId, corporationId, systemId, profileId, fuelExpires, services,
                stateTimerStart, stateTimerEnd, unanchorsAt, currentVul, nextVul);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporationStructuresResponse {\n");

        sb.append("    structureId: ").append(toIndentedString(structureId)).append("\n");
        sb.append("    typeId: ").append(toIndentedString(typeId)).append("\n");
        sb.append("    corporationId: ").append(toIndentedString(corporationId)).append("\n");
        sb.append("    systemId: ").append(toIndentedString(systemId)).append("\n");
        sb.append("    profileId: ").append(toIndentedString(profileId)).append("\n");
        sb.append("    fuelExpires: ").append(toIndentedString(fuelExpires)).append("\n");
        sb.append("    services: ").append(toIndentedString(services)).append("\n");
        sb.append("    stateTimerStart: ").append(toIndentedString(stateTimerStart)).append("\n");
        sb.append("    stateTimerEnd: ").append(toIndentedString(stateTimerEnd)).append("\n");
        sb.append("    unanchorsAt: ").append(toIndentedString(unanchorsAt)).append("\n");
        sb.append("    currentVul: ").append(toIndentedString(currentVul)).append("\n");
        sb.append("    nextVul: ").append(toIndentedString(nextVul)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
