/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

/**
 * service object
 */
@ApiModel(description = "service object")
public class CorporationOutpostService implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * service_name string
     */
    public enum ServiceNameEnum {
        BOUNTY_MISSIONS("Bounty Missions"),

        ASSASSINATION_MISSIONS("Assassination Missions"),

        COURIER_MISSIONS("Courier Missions"),

        INTERBUS("Interbus"),

        REPROCESSING_PLANT("Reprocessing Plant"),

        REFINERY("Refinery"),

        MARKET("Market"),

        BLACK_MARKET("Black Market"),

        STOCK_EXCHANGE("Stock Exchange"),

        CLONING("Cloning"),

        SURGERY("Surgery"),

        DNA_THERAPY("DNA Therapy"),

        REPAIR_FACILITIES("Repair Facilities"),

        FACTORY("Factory"),

        LABORATORY("Laboratory"),

        GAMBLING("Gambling"),

        FITTING("Fitting"),

        PAINTSHOP("Paintshop"),

        NEWS("News"),

        STORAGE("Storage"),

        INSURANCE("Insurance"),

        DOCKING("Docking"),

        OFFICE_RENTAL("Office Rental"),

        JUMP_CLONE_FACILITY("Jump Clone Facility"),

        LOYALTY_POINT_STORE("Loyalty Point Store"),

        NAVY_OFFICES("Navy Offices"),

        SECURITY_OFFICE("Security Office");

        private String value;

        ServiceNameEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ServiceNameEnum fromValue(String text) {
            for (ServiceNameEnum b : ServiceNameEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("service_name")
    private ServiceNameEnum serviceName = null;

    @JsonProperty("minimum_standing")
    private Double minimumStanding = null;

    @JsonProperty("surcharge_per_bad_standing")
    private Double surchargePerBadStanding = null;

    @JsonProperty("discount_per_good_standing")
    private Double discountPerGoodStanding = null;

    public CorporationOutpostService serviceName(ServiceNameEnum serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    /**
     * service_name string
     * 
     * @return serviceName
     **/
    @ApiModelProperty(example = "null", required = true, value = "service_name string")
    public ServiceNameEnum getServiceName() {
        return serviceName;
    }

    public void setServiceName(ServiceNameEnum serviceName) {
        this.serviceName = serviceName;
    }

    public CorporationOutpostService minimumStanding(Double minimumStanding) {
        this.minimumStanding = minimumStanding;
        return this;
    }

    /**
     * minimum_standing number
     * 
     * @return minimumStanding
     **/
    @ApiModelProperty(example = "null", required = true, value = "minimum_standing number")
    public Double getMinimumStanding() {
        return minimumStanding;
    }

    public void setMinimumStanding(Double minimumStanding) {
        this.minimumStanding = minimumStanding;
    }

    public CorporationOutpostService surchargePerBadStanding(Double surchargePerBadStanding) {
        this.surchargePerBadStanding = surchargePerBadStanding;
        return this;
    }

    /**
     * surcharge_per_bad_standing number
     * 
     * @return surchargePerBadStanding
     **/
    @ApiModelProperty(example = "null", required = true, value = "surcharge_per_bad_standing number")
    public Double getSurchargePerBadStanding() {
        return surchargePerBadStanding;
    }

    public void setSurchargePerBadStanding(Double surchargePerBadStanding) {
        this.surchargePerBadStanding = surchargePerBadStanding;
    }

    public CorporationOutpostService discountPerGoodStanding(Double discountPerGoodStanding) {
        this.discountPerGoodStanding = discountPerGoodStanding;
        return this;
    }

    /**
     * discount_per_good_standing number
     * 
     * @return discountPerGoodStanding
     **/
    @ApiModelProperty(example = "null", required = true, value = "discount_per_good_standing number")
    public Double getDiscountPerGoodStanding() {
        return discountPerGoodStanding;
    }

    public void setDiscountPerGoodStanding(Double discountPerGoodStanding) {
        this.discountPerGoodStanding = discountPerGoodStanding;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CorporationOutpostService corporationOutpostService = (CorporationOutpostService) o;
        return Objects.equals(this.serviceName, corporationOutpostService.serviceName)
                && Objects.equals(this.minimumStanding, corporationOutpostService.minimumStanding)
                && Objects.equals(this.surchargePerBadStanding, corporationOutpostService.surchargePerBadStanding)
                && Objects.equals(this.discountPerGoodStanding, corporationOutpostService.discountPerGoodStanding);
    }

    @Override
    public int hashCode() {
        return Objects.hash(serviceName, minimumStanding, surchargePerBadStanding, discountPerGoodStanding);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporationOutpostService {\n");

        sb.append("    serviceName: ").append(toIndentedString(serviceName)).append("\n");
        sb.append("    minimumStanding: ").append(toIndentedString(minimumStanding)).append("\n");
        sb.append("    surchargePerBadStanding: ").append(toIndentedString(surchargePerBadStanding)).append("\n");
        sb.append("    discountPerGoodStanding: ").append(toIndentedString(discountPerGoodStanding)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
