/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.SovereigntyCampaignParticipant;

@ApiModel(description="200 ok object")
public class SovereigntyCampaignsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="campaign_id")
    private Integer campaignId = null;
    @JsonProperty(value="structure_id")
    private Long structureId = null;
    @JsonProperty(value="solar_system_id")
    private Integer solarSystemId = null;
    @JsonProperty(value="constellation_id")
    private Integer constellationId = null;
    @JsonProperty(value="event_type")
    private EventTypeEnum eventType = null;
    @JsonProperty(value="start_time")
    private OffsetDateTime startTime = null;
    @JsonProperty(value="defender_id")
    private Integer defenderId = null;
    @JsonProperty(value="defender_score")
    private Float defenderScore = null;
    @JsonProperty(value="attackers_score")
    private Float attackersScore = null;
    @JsonProperty(value="participants")
    private List<SovereigntyCampaignParticipant> participants = new ArrayList<SovereigntyCampaignParticipant>();

    public SovereigntyCampaignsResponse campaignId(Integer n) {
        this.campaignId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Unique ID for this campaign.")
    public Integer getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(Integer n) {
        this.campaignId = n;
    }

    public SovereigntyCampaignsResponse structureId(Long l) {
        this.structureId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The structure item ID that is related to this campaign. ")
    public Long getStructureId() {
        return this.structureId;
    }

    public void setStructureId(Long l) {
        this.structureId = l;
    }

    public SovereigntyCampaignsResponse solarSystemId(Integer n) {
        this.solarSystemId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The solar system the structure is located in. ")
    public Integer getSolarSystemId() {
        return this.solarSystemId;
    }

    public void setSolarSystemId(Integer n) {
        this.solarSystemId = n;
    }

    public SovereigntyCampaignsResponse constellationId(Integer n) {
        this.constellationId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The constellation in which the campaign will take place. ")
    public Integer getConstellationId() {
        return this.constellationId;
    }

    public void setConstellationId(Integer n) {
        this.constellationId = n;
    }

    public SovereigntyCampaignsResponse eventType(EventTypeEnum eventTypeEnum) {
        this.eventType = eventTypeEnum;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of event this campaign is for. tcu_defense, ihub_defense and station_defense are referred to as \"Defense Events\", station_freeport as \"Freeport Events\". ")
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    public void setEventType(EventTypeEnum eventTypeEnum) {
        this.eventType = eventTypeEnum;
    }

    public SovereigntyCampaignsResponse startTime(OffsetDateTime offsetDateTime) {
        this.startTime = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Time the event is scheduled to start. ")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime offsetDateTime) {
        this.startTime = offsetDateTime;
    }

    public SovereigntyCampaignsResponse defenderId(Integer n) {
        this.defenderId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="Defending alliance, only present in Defense Events ")
    public Integer getDefenderId() {
        return this.defenderId;
    }

    public void setDefenderId(Integer n) {
        this.defenderId = n;
    }

    public SovereigntyCampaignsResponse defenderScore(Float f) {
        this.defenderScore = f;
        return this;
    }

    @ApiModelProperty(example="null", value="Score for the defending alliance, only present in Defense Events. ")
    public Float getDefenderScore() {
        return this.defenderScore;
    }

    public void setDefenderScore(Float f) {
        this.defenderScore = f;
    }

    public SovereigntyCampaignsResponse attackersScore(Float f) {
        this.attackersScore = f;
        return this;
    }

    @ApiModelProperty(example="null", value="Score for all attacking parties, only present in Defense Events. ")
    public Float getAttackersScore() {
        return this.attackersScore;
    }

    public void setAttackersScore(Float f) {
        this.attackersScore = f;
    }

    public SovereigntyCampaignsResponse participants(List<SovereigntyCampaignParticipant> list) {
        this.participants = list;
        return this;
    }

    public SovereigntyCampaignsResponse addParticipantsItem(SovereigntyCampaignParticipant sovereigntyCampaignParticipant) {
        this.participants.add(sovereigntyCampaignParticipant);
        return this;
    }

    @ApiModelProperty(example="null", value="Alliance participating and their respective scores, only present in Freeport Events. ")
    public List<SovereigntyCampaignParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<SovereigntyCampaignParticipant> list) {
        this.participants = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SovereigntyCampaignsResponse sovereigntyCampaignsResponse = (SovereigntyCampaignsResponse)object;
        return Objects.equals(this.campaignId, sovereigntyCampaignsResponse.campaignId) && Objects.equals(this.structureId, sovereigntyCampaignsResponse.structureId) && Objects.equals(this.solarSystemId, sovereigntyCampaignsResponse.solarSystemId) && Objects.equals(this.constellationId, sovereigntyCampaignsResponse.constellationId) && Objects.equals((Object)this.eventType, (Object)sovereigntyCampaignsResponse.eventType) && Objects.equals(this.startTime, sovereigntyCampaignsResponse.startTime) && Objects.equals(this.defenderId, sovereigntyCampaignsResponse.defenderId) && Objects.equals(this.defenderScore, sovereigntyCampaignsResponse.defenderScore) && Objects.equals(this.attackersScore, sovereigntyCampaignsResponse.attackersScore) && Objects.equals(this.participants, sovereigntyCampaignsResponse.participants);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.campaignId, this.structureId, this.solarSystemId, this.constellationId, this.eventType, this.startTime, this.defenderId, this.defenderScore, this.attackersScore, this.participants});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class SovereigntyCampaignsResponse {\n");
        stringBuilder.append("    campaignId: ").append(this.toIndentedString(this.campaignId)).append("\n");
        stringBuilder.append("    structureId: ").append(this.toIndentedString(this.structureId)).append("\n");
        stringBuilder.append("    solarSystemId: ").append(this.toIndentedString(this.solarSystemId)).append("\n");
        stringBuilder.append("    constellationId: ").append(this.toIndentedString(this.constellationId)).append("\n");
        stringBuilder.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        stringBuilder.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        stringBuilder.append("    defenderId: ").append(this.toIndentedString(this.defenderId)).append("\n");
        stringBuilder.append("    defenderScore: ").append(this.toIndentedString(this.defenderScore)).append("\n");
        stringBuilder.append("    attackersScore: ").append(this.toIndentedString(this.attackersScore)).append("\n");
        stringBuilder.append("    participants: ").append(this.toIndentedString(this.participants)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    public static enum EventTypeEnum {
        TCU_DEFENSE("tcu_defense"),
        IHUB_DEFENSE("ihub_defense"),
        STATION_DEFENSE("station_defense"),
        STATION_FREEPORT("station_freeport");

        private String value;

        private EventTypeEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventTypeEnum fromValue(String string) {
            for (EventTypeEnum eventTypeEnum : EventTypeEnum.values()) {
                if (!String.valueOf(eventTypeEnum.value).equals(string)) continue;
                return eventTypeEnum;
            }
            return null;
        }
    }
}

