/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.Recipient;

@ApiModel(description="200 ok object")
public class MailResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="subject")
    private String subject = null;
    @JsonProperty(value="from")
    private Integer from = null;
    @JsonProperty(value="timestamp")
    private OffsetDateTime timestamp = null;
    @JsonProperty(value="recipients")
    private List<Recipient> recipients = new ArrayList<Recipient>();
    @JsonProperty(value="body")
    private String body = null;
    @JsonProperty(value="labels")
    private List<Long> labels = new ArrayList<Long>();
    @JsonProperty(value="read")
    private Boolean read = null;

    public MailResponse subject(String string) {
        this.subject = string;
        return this;
    }

    @ApiModelProperty(example="null", value="Mail subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public MailResponse from(Integer n) {
        this.from = n;
        return this;
    }

    @ApiModelProperty(example="null", value="From whom the mail was sent")
    public Integer getFrom() {
        return this.from;
    }

    public void setFrom(Integer n) {
        this.from = n;
    }

    public MailResponse timestamp(OffsetDateTime offsetDateTime) {
        this.timestamp = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="When the mail was sent")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime offsetDateTime) {
        this.timestamp = offsetDateTime;
    }

    public MailResponse recipients(List<Recipient> list) {
        this.recipients = list;
        return this;
    }

    public MailResponse addRecipientsItem(Recipient recipient) {
        this.recipients.add(recipient);
        return this;
    }

    @ApiModelProperty(example="null", value="Recipients of the mail")
    public List<Recipient> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<Recipient> list) {
        this.recipients = list;
    }

    public MailResponse body(String string) {
        this.body = string;
        return this;
    }

    @ApiModelProperty(example="null", value="Mail's body")
    public String getBody() {
        return this.body;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public MailResponse labels(List<Long> list) {
        this.labels = list;
        return this;
    }

    public MailResponse addLabelsItem(Long l) {
        this.labels.add(l);
        return this;
    }

    @ApiModelProperty(example="null", value="Labels attached to the mail")
    public List<Long> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Long> list) {
        this.labels = list;
    }

    public MailResponse read(Boolean bl) {
        this.read = bl;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the mail is flagged as read")
    public Boolean getRead() {
        return this.read;
    }

    public void setRead(Boolean bl) {
        this.read = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MailResponse mailResponse = (MailResponse)object;
        return Objects.equals(this.subject, mailResponse.subject) && Objects.equals(this.from, mailResponse.from) && Objects.equals(this.timestamp, mailResponse.timestamp) && Objects.equals(this.recipients, mailResponse.recipients) && Objects.equals(this.body, mailResponse.body) && Objects.equals(this.labels, mailResponse.labels) && Objects.equals(this.read, mailResponse.read);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.from, this.timestamp, this.recipients, this.body, this.labels, this.read);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class MailResponse {\n");
        stringBuilder.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        stringBuilder.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        stringBuilder.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        stringBuilder.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        stringBuilder.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        stringBuilder.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        stringBuilder.append("    read: ").append(this.toIndentedString(this.read)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

