/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.CorporationOutpostCoordinates;
import net.troja.eve.esi.model.CorporationOutpostService;

@ApiModel(description="200 ok object")
public class CorporationOutpostResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="owner_id")
    private Integer ownerId = null;
    @JsonProperty(value="system_id")
    private Integer systemId = null;
    @JsonProperty(value="docking_cost_per_ship_volume")
    private Float dockingCostPerShipVolume = null;
    @JsonProperty(value="office_rental_cost")
    private Long officeRentalCost = null;
    @JsonProperty(value="type_id")
    private Integer typeId = null;
    @JsonProperty(value="reprocessing_efficiency")
    private Float reprocessingEfficiency = null;
    @JsonProperty(value="reprocessing_station_take")
    private Float reprocessingStationTake = null;
    @JsonProperty(value="standing_owner_id")
    private Integer standingOwnerId = null;
    @JsonProperty(value="coordinates")
    private CorporationOutpostCoordinates coordinates = null;
    @JsonProperty(value="services")
    private List<CorporationOutpostService> services = new ArrayList<CorporationOutpostService>();

    public CorporationOutpostResponse ownerId(Integer n) {
        this.ownerId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The entity that owns the station (e.g. the entity whose logo is on the station services bar)")
    public Integer getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(Integer n) {
        this.ownerId = n;
    }

    public CorporationOutpostResponse systemId(Integer n) {
        this.systemId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the solar system the outpost rests in")
    public Integer getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Integer n) {
        this.systemId = n;
    }

    public CorporationOutpostResponse dockingCostPerShipVolume(Float f) {
        this.dockingCostPerShipVolume = f;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="docking_cost_per_ship_volume number")
    public Float getDockingCostPerShipVolume() {
        return this.dockingCostPerShipVolume;
    }

    public void setDockingCostPerShipVolume(Float f) {
        this.dockingCostPerShipVolume = f;
    }

    public CorporationOutpostResponse officeRentalCost(Long l) {
        this.officeRentalCost = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="office_rental_cost integer")
    public Long getOfficeRentalCost() {
        return this.officeRentalCost;
    }

    public void setOfficeRentalCost(Long l) {
        this.officeRentalCost = l;
    }

    public CorporationOutpostResponse typeId(Integer n) {
        this.typeId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type ID of the given outpost")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer n) {
        this.typeId = n;
    }

    public CorporationOutpostResponse reprocessingEfficiency(Float f) {
        this.reprocessingEfficiency = f;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="reprocessing_efficiency number")
    public Float getReprocessingEfficiency() {
        return this.reprocessingEfficiency;
    }

    public void setReprocessingEfficiency(Float f) {
        this.reprocessingEfficiency = f;
    }

    public CorporationOutpostResponse reprocessingStationTake(Float f) {
        this.reprocessingStationTake = f;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="reprocessing_station_take number")
    public Float getReprocessingStationTake() {
        return this.reprocessingStationTake;
    }

    public void setReprocessingStationTake(Float f) {
        this.reprocessingStationTake = f;
    }

    public CorporationOutpostResponse standingOwnerId(Integer n) {
        this.standingOwnerId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The owner ID that sets the ability for someone to dock based on standings.")
    public Integer getStandingOwnerId() {
        return this.standingOwnerId;
    }

    public void setStandingOwnerId(Integer n) {
        this.standingOwnerId = n;
    }

    public CorporationOutpostResponse coordinates(CorporationOutpostCoordinates corporationOutpostCoordinates) {
        this.coordinates = corporationOutpostCoordinates;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public CorporationOutpostCoordinates getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(CorporationOutpostCoordinates corporationOutpostCoordinates) {
        this.coordinates = corporationOutpostCoordinates;
    }

    public CorporationOutpostResponse services(List<CorporationOutpostService> list) {
        this.services = list;
        return this;
    }

    public CorporationOutpostResponse addServicesItem(CorporationOutpostService corporationOutpostService) {
        this.services.add(corporationOutpostService);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A list of services the given outpost provides")
    public List<CorporationOutpostService> getServices() {
        return this.services;
    }

    public void setServices(List<CorporationOutpostService> list) {
        this.services = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CorporationOutpostResponse corporationOutpostResponse = (CorporationOutpostResponse)object;
        return Objects.equals(this.ownerId, corporationOutpostResponse.ownerId) && Objects.equals(this.systemId, corporationOutpostResponse.systemId) && Objects.equals(this.dockingCostPerShipVolume, corporationOutpostResponse.dockingCostPerShipVolume) && Objects.equals(this.officeRentalCost, corporationOutpostResponse.officeRentalCost) && Objects.equals(this.typeId, corporationOutpostResponse.typeId) && Objects.equals(this.reprocessingEfficiency, corporationOutpostResponse.reprocessingEfficiency) && Objects.equals(this.reprocessingStationTake, corporationOutpostResponse.reprocessingStationTake) && Objects.equals(this.standingOwnerId, corporationOutpostResponse.standingOwnerId) && Objects.equals(this.coordinates, corporationOutpostResponse.coordinates) && Objects.equals(this.services, corporationOutpostResponse.services);
    }

    public int hashCode() {
        return Objects.hash(this.ownerId, this.systemId, this.dockingCostPerShipVolume, this.officeRentalCost, this.typeId, this.reprocessingEfficiency, this.reprocessingStationTake, this.standingOwnerId, this.coordinates, this.services);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CorporationOutpostResponse {\n");
        stringBuilder.append("    ownerId: ").append(this.toIndentedString(this.ownerId)).append("\n");
        stringBuilder.append("    systemId: ").append(this.toIndentedString(this.systemId)).append("\n");
        stringBuilder.append("    dockingCostPerShipVolume: ").append(this.toIndentedString(this.dockingCostPerShipVolume)).append("\n");
        stringBuilder.append("    officeRentalCost: ").append(this.toIndentedString(this.officeRentalCost)).append("\n");
        stringBuilder.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        stringBuilder.append("    reprocessingEfficiency: ").append(this.toIndentedString(this.reprocessingEfficiency)).append("\n");
        stringBuilder.append("    reprocessingStationTake: ").append(this.toIndentedString(this.reprocessingStationTake)).append("\n");
        stringBuilder.append("    standingOwnerId: ").append(this.toIndentedString(this.standingOwnerId)).append("\n");
        stringBuilder.append("    coordinates: ").append(this.toIndentedString(this.coordinates)).append("\n");
        stringBuilder.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

