/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CorporationCustomsOfficesResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="office_id")
    private Long officeId = null;
    @JsonProperty(value="system_id")
    private Integer systemId = null;
    @JsonProperty(value="reinforce_exit_start")
    private Integer reinforceExitStart = null;
    @JsonProperty(value="reinforce_exit_end")
    private Integer reinforceExitEnd = null;
    @JsonProperty(value="corporation_tax_rate")
    private Float corporationTaxRate = null;
    @JsonProperty(value="allow_alliance_access")
    private Boolean allowAllianceAccess = null;
    @JsonProperty(value="alliance_tax_rate")
    private Float allianceTaxRate = null;
    @JsonProperty(value="allow_access_with_standings")
    private Boolean allowAccessWithStandings = null;
    @JsonProperty(value="standing_level")
    private StandingLevelEnum standingLevel = null;
    @JsonProperty(value="excellent_standing_tax_rate")
    private Float excellentStandingTaxRate = null;
    @JsonProperty(value="good_standing_tax_rate")
    private Float goodStandingTaxRate = null;
    @JsonProperty(value="neutral_standing_tax_rate")
    private Float neutralStandingTaxRate = null;
    @JsonProperty(value="bad_standing_tax_rate")
    private Float badStandingTaxRate = null;
    @JsonProperty(value="terrible_standing_tax_rate")
    private Float terribleStandingTaxRate = null;

    public CorporationCustomsOfficesResponse officeId(Long l) {
        this.officeId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="unique ID of this customs office")
    public Long getOfficeId() {
        return this.officeId;
    }

    public void setOfficeId(Long l) {
        this.officeId = l;
    }

    public CorporationCustomsOfficesResponse systemId(Integer n) {
        this.systemId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the solar system this customs office is located in")
    public Integer getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Integer n) {
        this.systemId = n;
    }

    public CorporationCustomsOfficesResponse reinforceExitStart(Integer n) {
        this.reinforceExitStart = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Together with reinforce_exit_end, marks a 2-hour period where this customs office could exit reinforcement mode during the day after initial attack")
    public Integer getReinforceExitStart() {
        return this.reinforceExitStart;
    }

    public void setReinforceExitStart(Integer n) {
        this.reinforceExitStart = n;
    }

    public CorporationCustomsOfficesResponse reinforceExitEnd(Integer n) {
        this.reinforceExitEnd = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="reinforce_exit_end integer")
    public Integer getReinforceExitEnd() {
        return this.reinforceExitEnd;
    }

    public void setReinforceExitEnd(Integer n) {
        this.reinforceExitEnd = n;
    }

    public CorporationCustomsOfficesResponse corporationTaxRate(Float f) {
        this.corporationTaxRate = f;
        return this;
    }

    @ApiModelProperty(example="null", value="corporation_tax_rate number")
    public Float getCorporationTaxRate() {
        return this.corporationTaxRate;
    }

    public void setCorporationTaxRate(Float f) {
        this.corporationTaxRate = f;
    }

    public CorporationCustomsOfficesResponse allowAllianceAccess(Boolean bl) {
        this.allowAllianceAccess = bl;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="allow_alliance_access boolean")
    public Boolean getAllowAllianceAccess() {
        return this.allowAllianceAccess;
    }

    public void setAllowAllianceAccess(Boolean bl) {
        this.allowAllianceAccess = bl;
    }

    public CorporationCustomsOfficesResponse allianceTaxRate(Float f) {
        this.allianceTaxRate = f;
        return this;
    }

    @ApiModelProperty(example="null", value="Only present if alliance access is allowed")
    public Float getAllianceTaxRate() {
        return this.allianceTaxRate;
    }

    public void setAllianceTaxRate(Float f) {
        this.allianceTaxRate = f;
    }

    public CorporationCustomsOfficesResponse allowAccessWithStandings(Boolean bl) {
        this.allowAccessWithStandings = bl;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="standing_level and any standing related tax rate only present when this is true")
    public Boolean getAllowAccessWithStandings() {
        return this.allowAccessWithStandings;
    }

    public void setAllowAccessWithStandings(Boolean bl) {
        this.allowAccessWithStandings = bl;
    }

    public CorporationCustomsOfficesResponse standingLevel(StandingLevelEnum standingLevelEnum) {
        this.standingLevel = standingLevelEnum;
        return this;
    }

    @ApiModelProperty(example="null", value="Access is allowed only for entities with this level of standing or better")
    public StandingLevelEnum getStandingLevel() {
        return this.standingLevel;
    }

    public void setStandingLevel(StandingLevelEnum standingLevelEnum) {
        this.standingLevel = standingLevelEnum;
    }

    public CorporationCustomsOfficesResponse excellentStandingTaxRate(Float f) {
        this.excellentStandingTaxRate = f;
        return this;
    }

    @ApiModelProperty(example="null", value="Tax rate for entities with excellent level of standing, only present if this level is allowed, same for all other standing related tax rates")
    public Float getExcellentStandingTaxRate() {
        return this.excellentStandingTaxRate;
    }

    public void setExcellentStandingTaxRate(Float f) {
        this.excellentStandingTaxRate = f;
    }

    public CorporationCustomsOfficesResponse goodStandingTaxRate(Float f) {
        this.goodStandingTaxRate = f;
        return this;
    }

    @ApiModelProperty(example="null", value="good_standing_tax_rate number")
    public Float getGoodStandingTaxRate() {
        return this.goodStandingTaxRate;
    }

    public void setGoodStandingTaxRate(Float f) {
        this.goodStandingTaxRate = f;
    }

    public CorporationCustomsOfficesResponse neutralStandingTaxRate(Float f) {
        this.neutralStandingTaxRate = f;
        return this;
    }

    @ApiModelProperty(example="null", value="neutral_standing_tax_rate number")
    public Float getNeutralStandingTaxRate() {
        return this.neutralStandingTaxRate;
    }

    public void setNeutralStandingTaxRate(Float f) {
        this.neutralStandingTaxRate = f;
    }

    public CorporationCustomsOfficesResponse badStandingTaxRate(Float f) {
        this.badStandingTaxRate = f;
        return this;
    }

    @ApiModelProperty(example="null", value="bad_standing_tax_rate number")
    public Float getBadStandingTaxRate() {
        return this.badStandingTaxRate;
    }

    public void setBadStandingTaxRate(Float f) {
        this.badStandingTaxRate = f;
    }

    public CorporationCustomsOfficesResponse terribleStandingTaxRate(Float f) {
        this.terribleStandingTaxRate = f;
        return this;
    }

    @ApiModelProperty(example="null", value="terrible_standing_tax_rate number")
    public Float getTerribleStandingTaxRate() {
        return this.terribleStandingTaxRate;
    }

    public void setTerribleStandingTaxRate(Float f) {
        this.terribleStandingTaxRate = f;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CorporationCustomsOfficesResponse corporationCustomsOfficesResponse = (CorporationCustomsOfficesResponse)object;
        return Objects.equals(this.officeId, corporationCustomsOfficesResponse.officeId) && Objects.equals(this.systemId, corporationCustomsOfficesResponse.systemId) && Objects.equals(this.reinforceExitStart, corporationCustomsOfficesResponse.reinforceExitStart) && Objects.equals(this.reinforceExitEnd, corporationCustomsOfficesResponse.reinforceExitEnd) && Objects.equals(this.corporationTaxRate, corporationCustomsOfficesResponse.corporationTaxRate) && Objects.equals(this.allowAllianceAccess, corporationCustomsOfficesResponse.allowAllianceAccess) && Objects.equals(this.allianceTaxRate, corporationCustomsOfficesResponse.allianceTaxRate) && Objects.equals(this.allowAccessWithStandings, corporationCustomsOfficesResponse.allowAccessWithStandings) && Objects.equals((Object)this.standingLevel, (Object)corporationCustomsOfficesResponse.standingLevel) && Objects.equals(this.excellentStandingTaxRate, corporationCustomsOfficesResponse.excellentStandingTaxRate) && Objects.equals(this.goodStandingTaxRate, corporationCustomsOfficesResponse.goodStandingTaxRate) && Objects.equals(this.neutralStandingTaxRate, corporationCustomsOfficesResponse.neutralStandingTaxRate) && Objects.equals(this.badStandingTaxRate, corporationCustomsOfficesResponse.badStandingTaxRate) && Objects.equals(this.terribleStandingTaxRate, corporationCustomsOfficesResponse.terribleStandingTaxRate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.officeId, this.systemId, this.reinforceExitStart, this.reinforceExitEnd, this.corporationTaxRate, this.allowAllianceAccess, this.allianceTaxRate, this.allowAccessWithStandings, this.standingLevel, this.excellentStandingTaxRate, this.goodStandingTaxRate, this.neutralStandingTaxRate, this.badStandingTaxRate, this.terribleStandingTaxRate});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CorporationCustomsOfficesResponse {\n");
        stringBuilder.append("    officeId: ").append(this.toIndentedString(this.officeId)).append("\n");
        stringBuilder.append("    systemId: ").append(this.toIndentedString(this.systemId)).append("\n");
        stringBuilder.append("    reinforceExitStart: ").append(this.toIndentedString(this.reinforceExitStart)).append("\n");
        stringBuilder.append("    reinforceExitEnd: ").append(this.toIndentedString(this.reinforceExitEnd)).append("\n");
        stringBuilder.append("    corporationTaxRate: ").append(this.toIndentedString(this.corporationTaxRate)).append("\n");
        stringBuilder.append("    allowAllianceAccess: ").append(this.toIndentedString(this.allowAllianceAccess)).append("\n");
        stringBuilder.append("    allianceTaxRate: ").append(this.toIndentedString(this.allianceTaxRate)).append("\n");
        stringBuilder.append("    allowAccessWithStandings: ").append(this.toIndentedString(this.allowAccessWithStandings)).append("\n");
        stringBuilder.append("    standingLevel: ").append(this.toIndentedString((Object)this.standingLevel)).append("\n");
        stringBuilder.append("    excellentStandingTaxRate: ").append(this.toIndentedString(this.excellentStandingTaxRate)).append("\n");
        stringBuilder.append("    goodStandingTaxRate: ").append(this.toIndentedString(this.goodStandingTaxRate)).append("\n");
        stringBuilder.append("    neutralStandingTaxRate: ").append(this.toIndentedString(this.neutralStandingTaxRate)).append("\n");
        stringBuilder.append("    badStandingTaxRate: ").append(this.toIndentedString(this.badStandingTaxRate)).append("\n");
        stringBuilder.append("    terribleStandingTaxRate: ").append(this.toIndentedString(this.terribleStandingTaxRate)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    public static enum StandingLevelEnum {
        BAD("bad"),
        EXCELLENT("excellent"),
        GOOD("good"),
        NEUTRAL("neutral"),
        TERRIBLE("terrible");

        private String value;

        private StandingLevelEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StandingLevelEnum fromValue(String string) {
            for (StandingLevelEnum standingLevelEnum : StandingLevelEnum.values()) {
                if (!String.valueOf(standingLevelEnum.value).equals(string)) continue;
                return standingLevelEnum;
            }
            return null;
        }
    }
}

