/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CharacterOrdersResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="order_id")
    private Long orderId = null;
    @JsonProperty(value="type_id")
    private Integer typeId = null;
    @JsonProperty(value="region_id")
    private Integer regionId = null;
    @JsonProperty(value="location_id")
    private Long locationId = null;
    @JsonProperty(value="range")
    private RangeEnum range = null;
    @JsonProperty(value="is_buy_order")
    private Boolean isBuyOrder = null;
    @JsonProperty(value="price")
    private Double price = null;
    @JsonProperty(value="volume_total")
    private Integer volumeTotal = null;
    @JsonProperty(value="volume_remain")
    private Integer volumeRemain = null;
    @JsonProperty(value="issued")
    private OffsetDateTime issued = null;
    @JsonProperty(value="state")
    private StateEnum state = null;
    @JsonProperty(value="min_volume")
    private Integer minVolume = null;
    @JsonProperty(value="account_id")
    private Integer accountId = null;
    @JsonProperty(value="duration")
    private Integer duration = null;
    @JsonProperty(value="is_corp")
    private Boolean isCorp = null;
    @JsonProperty(value="escrow")
    private Double escrow = null;

    public CharacterOrdersResponse orderId(Long l) {
        this.orderId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Unique order ID")
    public Long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Long l) {
        this.orderId = l;
    }

    public CharacterOrdersResponse typeId(Integer n) {
        this.typeId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type ID of the item transacted in this order")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer n) {
        this.typeId = n;
    }

    public CharacterOrdersResponse regionId(Integer n) {
        this.regionId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the region where order was placed")
    public Integer getRegionId() {
        return this.regionId;
    }

    public void setRegionId(Integer n) {
        this.regionId = n;
    }

    public CharacterOrdersResponse locationId(Long l) {
        this.locationId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the location where order was placed")
    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Long l) {
        this.locationId = l;
    }

    public CharacterOrdersResponse range(RangeEnum rangeEnum) {
        this.range = rangeEnum;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Valid order range, numbers are ranges in jumps")
    public RangeEnum getRange() {
        return this.range;
    }

    public void setRange(RangeEnum rangeEnum) {
        this.range = rangeEnum;
    }

    public CharacterOrdersResponse isBuyOrder(Boolean bl) {
        this.isBuyOrder = bl;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="True for a bid (buy) order. False for an offer (sell) order")
    public Boolean getIsBuyOrder() {
        return this.isBuyOrder;
    }

    public void setIsBuyOrder(Boolean bl) {
        this.isBuyOrder = bl;
    }

    public CharacterOrdersResponse price(Double d) {
        this.price = d;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Cost per unit for this order")
    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double d) {
        this.price = d;
    }

    public CharacterOrdersResponse volumeTotal(Integer n) {
        this.volumeTotal = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Quantity of items required or offered at time order was placed")
    public Integer getVolumeTotal() {
        return this.volumeTotal;
    }

    public void setVolumeTotal(Integer n) {
        this.volumeTotal = n;
    }

    public CharacterOrdersResponse volumeRemain(Integer n) {
        this.volumeRemain = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Quantity of items still required or offered")
    public Integer getVolumeRemain() {
        return this.volumeRemain;
    }

    public void setVolumeRemain(Integer n) {
        this.volumeRemain = n;
    }

    public CharacterOrdersResponse issued(OffsetDateTime offsetDateTime) {
        this.issued = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Date and time when this order was issued")
    public OffsetDateTime getIssued() {
        return this.issued;
    }

    public void setIssued(OffsetDateTime offsetDateTime) {
        this.issued = offsetDateTime;
    }

    public CharacterOrdersResponse state(StateEnum stateEnum) {
        this.state = stateEnum;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Current order state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum stateEnum) {
        this.state = stateEnum;
    }

    public CharacterOrdersResponse minVolume(Integer n) {
        this.minVolume = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="For bids (buy orders), the minimum quantity that will be accepted in a matching offer (sell order)")
    public Integer getMinVolume() {
        return this.minVolume;
    }

    public void setMinVolume(Integer n) {
        this.minVolume = n;
    }

    public CharacterOrdersResponse accountId(Integer n) {
        this.accountId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Wallet division for the buyer or seller of this order. Always 1000 for characters. Currently 1000 through 1006 for corporations")
    public Integer getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Integer n) {
        this.accountId = n;
    }

    public CharacterOrdersResponse duration(Integer n) {
        this.duration = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Numer of days for which order is valid (starting from the issued date). An order expires at time issued + duration")
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer n) {
        this.duration = n;
    }

    public CharacterOrdersResponse isCorp(Boolean bl) {
        this.isCorp = bl;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="is_corp boolean")
    public Boolean getIsCorp() {
        return this.isCorp;
    }

    public void setIsCorp(Boolean bl) {
        this.isCorp = bl;
    }

    public CharacterOrdersResponse escrow(Double d) {
        this.escrow = d;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="For buy orders, the amount of ISK in escrow")
    public Double getEscrow() {
        return this.escrow;
    }

    public void setEscrow(Double d) {
        this.escrow = d;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CharacterOrdersResponse characterOrdersResponse = (CharacterOrdersResponse)object;
        return Objects.equals(this.orderId, characterOrdersResponse.orderId) && Objects.equals(this.typeId, characterOrdersResponse.typeId) && Objects.equals(this.regionId, characterOrdersResponse.regionId) && Objects.equals(this.locationId, characterOrdersResponse.locationId) && Objects.equals((Object)this.range, (Object)characterOrdersResponse.range) && Objects.equals(this.isBuyOrder, characterOrdersResponse.isBuyOrder) && Objects.equals(this.price, characterOrdersResponse.price) && Objects.equals(this.volumeTotal, characterOrdersResponse.volumeTotal) && Objects.equals(this.volumeRemain, characterOrdersResponse.volumeRemain) && Objects.equals(this.issued, characterOrdersResponse.issued) && Objects.equals((Object)this.state, (Object)characterOrdersResponse.state) && Objects.equals(this.minVolume, characterOrdersResponse.minVolume) && Objects.equals(this.accountId, characterOrdersResponse.accountId) && Objects.equals(this.duration, characterOrdersResponse.duration) && Objects.equals(this.isCorp, characterOrdersResponse.isCorp) && Objects.equals(this.escrow, characterOrdersResponse.escrow);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.orderId, this.typeId, this.regionId, this.locationId, this.range, this.isBuyOrder, this.price, this.volumeTotal, this.volumeRemain, this.issued, this.state, this.minVolume, this.accountId, this.duration, this.isCorp, this.escrow});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CharacterOrdersResponse {\n");
        stringBuilder.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        stringBuilder.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        stringBuilder.append("    regionId: ").append(this.toIndentedString(this.regionId)).append("\n");
        stringBuilder.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        stringBuilder.append("    range: ").append(this.toIndentedString((Object)this.range)).append("\n");
        stringBuilder.append("    isBuyOrder: ").append(this.toIndentedString(this.isBuyOrder)).append("\n");
        stringBuilder.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        stringBuilder.append("    volumeTotal: ").append(this.toIndentedString(this.volumeTotal)).append("\n");
        stringBuilder.append("    volumeRemain: ").append(this.toIndentedString(this.volumeRemain)).append("\n");
        stringBuilder.append("    issued: ").append(this.toIndentedString(this.issued)).append("\n");
        stringBuilder.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        stringBuilder.append("    minVolume: ").append(this.toIndentedString(this.minVolume)).append("\n");
        stringBuilder.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        stringBuilder.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        stringBuilder.append("    isCorp: ").append(this.toIndentedString(this.isCorp)).append("\n");
        stringBuilder.append("    escrow: ").append(this.toIndentedString(this.escrow)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        CANCELLED("cancelled"),
        CHARACTER_DELETED("character_deleted"),
        CLOSED("closed"),
        EXPIRED("expired"),
        OPEN("open"),
        PENDING("pending");

        private String value;

        private StateEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String string) {
            for (StateEnum stateEnum : StateEnum.values()) {
                if (!String.valueOf(stateEnum.value).equals(string)) continue;
                return stateEnum;
            }
            return null;
        }
    }

    public static enum RangeEnum {
        _1("1"),
        _10("10"),
        _2("2"),
        _20("20"),
        _3("3"),
        _30("30"),
        _4("4"),
        _40("40"),
        _5("5"),
        REGION("region"),
        SOLARSYSTEM("solarsystem"),
        STATION("station");

        private String value;

        private RangeEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RangeEnum fromValue(String string) {
            for (RangeEnum rangeEnum : RangeEnum.values()) {
                if (!String.valueOf(rangeEnum.value).equals(string)) continue;
                return rangeEnum;
            }
            return null;
        }
    }
}

