/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class CorporationIndustryJobsResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("job_id")
    private Integer jobId = null;

    @JsonProperty("installer_id")
    private Integer installerId = null;

    @JsonProperty("facility_id")
    private Long facilityId = null;

    @JsonProperty("location_id")
    private Long locationId = null;

    @JsonProperty("activity_id")
    private Integer activityId = null;

    @JsonProperty("blueprint_id")
    private Long blueprintId = null;

    @JsonProperty("blueprint_type_id")
    private Integer blueprintTypeId = null;

    @JsonProperty("blueprint_location_id")
    private Long blueprintLocationId = null;

    @JsonProperty("output_location_id")
    private Long outputLocationId = null;

    @JsonProperty("runs")
    private Integer runs = null;

    @JsonProperty("cost")
    private Double cost = null;

    @JsonProperty("licensed_runs")
    private Integer licensedRuns = null;

    @JsonProperty("probability")
    private Float probability = null;

    @JsonProperty("product_type_id")
    private Integer productTypeId = null;

    /**
     * status string
     */
    public enum StatusEnum {
        ACTIVE("active"),

        CANCELLED("cancelled"),

        DELIVERED("delivered"),

        PAUSED("paused"),

        READY("ready"),

        REVERTED("reverted");

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("status")
    private StatusEnum status = null;

    @JsonProperty("duration")
    private Integer duration = null;

    @JsonProperty("start_date")
    private OffsetDateTime startDate = null;

    @JsonProperty("end_date")
    private OffsetDateTime endDate = null;

    @JsonProperty("pause_date")
    private OffsetDateTime pauseDate = null;

    @JsonProperty("completed_date")
    private OffsetDateTime completedDate = null;

    @JsonProperty("completed_character_id")
    private Integer completedCharacterId = null;

    @JsonProperty("successful_runs")
    private Integer successfulRuns = null;

    public CorporationIndustryJobsResponse jobId(Integer jobId) {
        this.jobId = jobId;
        return this;
    }

    /**
     * Unique job ID
     * 
     * @return jobId
     **/
    @ApiModelProperty(example = "null", required = true, value = "Unique job ID")
    public Integer getJobId() {
        return jobId;
    }

    public void setJobId(Integer jobId) {
        this.jobId = jobId;
    }

    public CorporationIndustryJobsResponse installerId(Integer installerId) {
        this.installerId = installerId;
        return this;
    }

    /**
     * ID of the character which installed this job
     * 
     * @return installerId
     **/
    @ApiModelProperty(example = "null", required = true, value = "ID of the character which installed this job")
    public Integer getInstallerId() {
        return installerId;
    }

    public void setInstallerId(Integer installerId) {
        this.installerId = installerId;
    }

    public CorporationIndustryJobsResponse facilityId(Long facilityId) {
        this.facilityId = facilityId;
        return this;
    }

    /**
     * ID of the facility where this job is running
     * 
     * @return facilityId
     **/
    @ApiModelProperty(example = "null", required = true, value = "ID of the facility where this job is running")
    public Long getFacilityId() {
        return facilityId;
    }

    public void setFacilityId(Long facilityId) {
        this.facilityId = facilityId;
    }

    public CorporationIndustryJobsResponse locationId(Long locationId) {
        this.locationId = locationId;
        return this;
    }

    /**
     * ID of the location for the industry facility
     * 
     * @return locationId
     **/
    @ApiModelProperty(example = "null", required = true, value = "ID of the location for the industry facility")
    public Long getLocationId() {
        return locationId;
    }

    public void setLocationId(Long locationId) {
        this.locationId = locationId;
    }

    public CorporationIndustryJobsResponse activityId(Integer activityId) {
        this.activityId = activityId;
        return this;
    }

    /**
     * Job activity ID
     * 
     * @return activityId
     **/
    @ApiModelProperty(example = "null", required = true, value = "Job activity ID")
    public Integer getActivityId() {
        return activityId;
    }

    public void setActivityId(Integer activityId) {
        this.activityId = activityId;
    }

    public CorporationIndustryJobsResponse blueprintId(Long blueprintId) {
        this.blueprintId = blueprintId;
        return this;
    }

    /**
     * blueprint_id integer
     * 
     * @return blueprintId
     **/
    @ApiModelProperty(example = "null", required = true, value = "blueprint_id integer")
    public Long getBlueprintId() {
        return blueprintId;
    }

    public void setBlueprintId(Long blueprintId) {
        this.blueprintId = blueprintId;
    }

    public CorporationIndustryJobsResponse blueprintTypeId(Integer blueprintTypeId) {
        this.blueprintTypeId = blueprintTypeId;
        return this;
    }

    /**
     * blueprint_type_id integer
     * 
     * @return blueprintTypeId
     **/
    @ApiModelProperty(example = "null", required = true, value = "blueprint_type_id integer")
    public Integer getBlueprintTypeId() {
        return blueprintTypeId;
    }

    public void setBlueprintTypeId(Integer blueprintTypeId) {
        this.blueprintTypeId = blueprintTypeId;
    }

    public CorporationIndustryJobsResponse blueprintLocationId(Long blueprintLocationId) {
        this.blueprintLocationId = blueprintLocationId;
        return this;
    }

    /**
     * Location ID of the location from which the blueprint was installed.
     * Normally a station ID, but can also be an asset (e.g. container) or
     * corporation facility
     * 
     * @return blueprintLocationId
     **/
    @ApiModelProperty(example = "null", required = true, value = "Location ID of the location from which the blueprint was installed. Normally a station ID, but can also be an asset (e.g. container) or corporation facility")
    public Long getBlueprintLocationId() {
        return blueprintLocationId;
    }

    public void setBlueprintLocationId(Long blueprintLocationId) {
        this.blueprintLocationId = blueprintLocationId;
    }

    public CorporationIndustryJobsResponse outputLocationId(Long outputLocationId) {
        this.outputLocationId = outputLocationId;
        return this;
    }

    /**
     * Location ID of the location to which the output of the job will be
     * delivered. Normally a station ID, but can also be a corporation facility
     * 
     * @return outputLocationId
     **/
    @ApiModelProperty(example = "null", required = true, value = "Location ID of the location to which the output of the job will be delivered. Normally a station ID, but can also be a corporation facility")
    public Long getOutputLocationId() {
        return outputLocationId;
    }

    public void setOutputLocationId(Long outputLocationId) {
        this.outputLocationId = outputLocationId;
    }

    public CorporationIndustryJobsResponse runs(Integer runs) {
        this.runs = runs;
        return this;
    }

    /**
     * Number of runs for a manufacturing job, or number of copies to make for a
     * blueprint copy
     * 
     * @return runs
     **/
    @ApiModelProperty(example = "null", required = true, value = "Number of runs for a manufacturing job, or number of copies to make for a blueprint copy")
    public Integer getRuns() {
        return runs;
    }

    public void setRuns(Integer runs) {
        this.runs = runs;
    }

    public CorporationIndustryJobsResponse cost(Double cost) {
        this.cost = cost;
        return this;
    }

    /**
     * The sume of job installation fee and industry facility tax
     * 
     * @return cost
     **/
    @ApiModelProperty(example = "null", value = "The sume of job installation fee and industry facility tax")
    public Double getCost() {
        return cost;
    }

    public void setCost(Double cost) {
        this.cost = cost;
    }

    public CorporationIndustryJobsResponse licensedRuns(Integer licensedRuns) {
        this.licensedRuns = licensedRuns;
        return this;
    }

    /**
     * Number of runs blueprint is licensed for
     * 
     * @return licensedRuns
     **/
    @ApiModelProperty(example = "null", value = "Number of runs blueprint is licensed for")
    public Integer getLicensedRuns() {
        return licensedRuns;
    }

    public void setLicensedRuns(Integer licensedRuns) {
        this.licensedRuns = licensedRuns;
    }

    public CorporationIndustryJobsResponse probability(Float probability) {
        this.probability = probability;
        return this;
    }

    /**
     * Chance of success for invention
     * 
     * @return probability
     **/
    @ApiModelProperty(example = "null", value = "Chance of success for invention")
    public Float getProbability() {
        return probability;
    }

    public void setProbability(Float probability) {
        this.probability = probability;
    }

    public CorporationIndustryJobsResponse productTypeId(Integer productTypeId) {
        this.productTypeId = productTypeId;
        return this;
    }

    /**
     * Type ID of product (manufactured, copied or invented)
     * 
     * @return productTypeId
     **/
    @ApiModelProperty(example = "null", value = "Type ID of product (manufactured, copied or invented)")
    public Integer getProductTypeId() {
        return productTypeId;
    }

    public void setProductTypeId(Integer productTypeId) {
        this.productTypeId = productTypeId;
    }

    public CorporationIndustryJobsResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    /**
     * status string
     * 
     * @return status
     **/
    @ApiModelProperty(example = "null", required = true, value = "status string")
    public StatusEnum getStatus() {
        return status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public CorporationIndustryJobsResponse duration(Integer duration) {
        this.duration = duration;
        return this;
    }

    /**
     * Job duration in seconds
     * 
     * @return duration
     **/
    @ApiModelProperty(example = "null", required = true, value = "Job duration in seconds")
    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public CorporationIndustryJobsResponse startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    /**
     * Date and time when this job started
     * 
     * @return startDate
     **/
    @ApiModelProperty(example = "null", required = true, value = "Date and time when this job started")
    public OffsetDateTime getStartDate() {
        return startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public CorporationIndustryJobsResponse endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    /**
     * Date and time when this job finished
     * 
     * @return endDate
     **/
    @ApiModelProperty(example = "null", required = true, value = "Date and time when this job finished")
    public OffsetDateTime getEndDate() {
        return endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public CorporationIndustryJobsResponse pauseDate(OffsetDateTime pauseDate) {
        this.pauseDate = pauseDate;
        return this;
    }

    /**
     * Date and time when this job was paused (i.e. time when the facility where
     * this job was installed went offline)
     * 
     * @return pauseDate
     **/
    @ApiModelProperty(example = "null", value = "Date and time when this job was paused (i.e. time when the facility where this job was installed went offline)")
    public OffsetDateTime getPauseDate() {
        return pauseDate;
    }

    public void setPauseDate(OffsetDateTime pauseDate) {
        this.pauseDate = pauseDate;
    }

    public CorporationIndustryJobsResponse completedDate(OffsetDateTime completedDate) {
        this.completedDate = completedDate;
        return this;
    }

    /**
     * Date and time when this job was completed
     * 
     * @return completedDate
     **/
    @ApiModelProperty(example = "null", value = "Date and time when this job was completed")
    public OffsetDateTime getCompletedDate() {
        return completedDate;
    }

    public void setCompletedDate(OffsetDateTime completedDate) {
        this.completedDate = completedDate;
    }

    public CorporationIndustryJobsResponse completedCharacterId(Integer completedCharacterId) {
        this.completedCharacterId = completedCharacterId;
        return this;
    }

    /**
     * ID of the character which completed this job
     * 
     * @return completedCharacterId
     **/
    @ApiModelProperty(example = "null", value = "ID of the character which completed this job")
    public Integer getCompletedCharacterId() {
        return completedCharacterId;
    }

    public void setCompletedCharacterId(Integer completedCharacterId) {
        this.completedCharacterId = completedCharacterId;
    }

    public CorporationIndustryJobsResponse successfulRuns(Integer successfulRuns) {
        this.successfulRuns = successfulRuns;
        return this;
    }

    /**
     * Number of successful runs for this job. Equal to runs unless this is an
     * invention job
     * 
     * @return successfulRuns
     **/
    @ApiModelProperty(example = "null", value = "Number of successful runs for this job. Equal to runs unless this is an invention job")
    public Integer getSuccessfulRuns() {
        return successfulRuns;
    }

    public void setSuccessfulRuns(Integer successfulRuns) {
        this.successfulRuns = successfulRuns;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CorporationIndustryJobsResponse corporationIndustryJobsResponse = (CorporationIndustryJobsResponse) o;
        return Objects.equals(this.jobId, corporationIndustryJobsResponse.jobId)
                && Objects.equals(this.installerId, corporationIndustryJobsResponse.installerId)
                && Objects.equals(this.facilityId, corporationIndustryJobsResponse.facilityId)
                && Objects.equals(this.locationId, corporationIndustryJobsResponse.locationId)
                && Objects.equals(this.activityId, corporationIndustryJobsResponse.activityId)
                && Objects.equals(this.blueprintId, corporationIndustryJobsResponse.blueprintId)
                && Objects.equals(this.blueprintTypeId, corporationIndustryJobsResponse.blueprintTypeId)
                && Objects.equals(this.blueprintLocationId, corporationIndustryJobsResponse.blueprintLocationId)
                && Objects.equals(this.outputLocationId, corporationIndustryJobsResponse.outputLocationId)
                && Objects.equals(this.runs, corporationIndustryJobsResponse.runs)
                && Objects.equals(this.cost, corporationIndustryJobsResponse.cost)
                && Objects.equals(this.licensedRuns, corporationIndustryJobsResponse.licensedRuns)
                && Objects.equals(this.probability, corporationIndustryJobsResponse.probability)
                && Objects.equals(this.productTypeId, corporationIndustryJobsResponse.productTypeId)
                && Objects.equals(this.status, corporationIndustryJobsResponse.status)
                && Objects.equals(this.duration, corporationIndustryJobsResponse.duration)
                && Objects.equals(this.startDate, corporationIndustryJobsResponse.startDate)
                && Objects.equals(this.endDate, corporationIndustryJobsResponse.endDate)
                && Objects.equals(this.pauseDate, corporationIndustryJobsResponse.pauseDate)
                && Objects.equals(this.completedDate, corporationIndustryJobsResponse.completedDate)
                && Objects.equals(this.completedCharacterId, corporationIndustryJobsResponse.completedCharacterId)
                && Objects.equals(this.successfulRuns, corporationIndustryJobsResponse.successfulRuns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(jobId, installerId, facilityId, locationId, activityId, blueprintId, blueprintTypeId,
                blueprintLocationId, outputLocationId, runs, cost, licensedRuns, probability, productTypeId, status,
                duration, startDate, endDate, pauseDate, completedDate, completedCharacterId, successfulRuns);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporationIndustryJobsResponse {\n");

        sb.append("    jobId: ").append(toIndentedString(jobId)).append("\n");
        sb.append("    installerId: ").append(toIndentedString(installerId)).append("\n");
        sb.append("    facilityId: ").append(toIndentedString(facilityId)).append("\n");
        sb.append("    locationId: ").append(toIndentedString(locationId)).append("\n");
        sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
        sb.append("    blueprintId: ").append(toIndentedString(blueprintId)).append("\n");
        sb.append("    blueprintTypeId: ").append(toIndentedString(blueprintTypeId)).append("\n");
        sb.append("    blueprintLocationId: ").append(toIndentedString(blueprintLocationId)).append("\n");
        sb.append("    outputLocationId: ").append(toIndentedString(outputLocationId)).append("\n");
        sb.append("    runs: ").append(toIndentedString(runs)).append("\n");
        sb.append("    cost: ").append(toIndentedString(cost)).append("\n");
        sb.append("    licensedRuns: ").append(toIndentedString(licensedRuns)).append("\n");
        sb.append("    probability: ").append(toIndentedString(probability)).append("\n");
        sb.append("    productTypeId: ").append(toIndentedString(productTypeId)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
        sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
        sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
        sb.append("    pauseDate: ").append(toIndentedString(pauseDate)).append("\n");
        sb.append("    completedDate: ").append(toIndentedString(completedDate)).append("\n");
        sb.append("    completedCharacterId: ").append(toIndentedString(completedCharacterId)).append("\n");
        sb.append("    successfulRuns: ").append(toIndentedString(successfulRuns)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
