/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import net.troja.eve.esi.model.CharacterWalletJournalExtraInfoResponse;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class CharacterWalletJournalResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("date")
    private OffsetDateTime date = null;

    @JsonProperty("ref_id")
    private Long refId = null;

    /**
     * Transaction type, different type of transaction will populate different
     * fields in `extra_info` Note: If you have an existing XML API application
     * that is using ref_types, you will need to know which string ESI ref_type
     * maps to which integer. You can use the following gist to see string->int
     * mappings:
     * https://gist.github.com/ccp-zoetrope/c03db66d90c2148724c06171bc52e0ec
     */
    public enum RefTypeEnum {
        ACCELERATION_GATE_FEE("acceleration_gate_fee"),

        ADVERTISEMENT_LISTING_FEE("advertisement_listing_fee"),

        AGENT_DONATION("agent_donation"),

        AGENT_LOCATION_SERVICES("agent_location_services"),

        AGENT_MISCELLANEOUS("agent_miscellaneous"),

        AGENT_MISSION_COLLATERAL_PAID("agent_mission_collateral_paid"),

        AGENT_MISSION_COLLATERAL_REFUNDED("agent_mission_collateral_refunded"),

        AGENT_MISSION_REWARD("agent_mission_reward"),

        AGENT_MISSION_REWARD_CORPORATION_TAX("agent_mission_reward_corporation_tax"),

        AGENT_MISSION_TIME_BONUS_REWARD("agent_mission_time_bonus_reward"),

        AGENT_MISSION_TIME_BONUS_REWARD_CORPORATION_TAX("agent_mission_time_bonus_reward_corporation_tax"),

        AGENT_SECURITY_SERVICES("agent_security_services"),

        AGENT_SERVICES_RENDERED("agent_services_rendered"),

        AGENTS_PREWARD("agents_preward"),

        ALLIANCE_MAINTAINANCE_FEE("alliance_maintainance_fee"),

        ALLIANCE_REGISTRATION_FEE("alliance_registration_fee"),

        ASSET_SAFETY_RECOVERY_TAX("asset_safety_recovery_tax"),

        BOUNTY("bounty"),

        BOUNTY_PRIZE("bounty_prize"),

        BOUNTY_PRIZE_CORPORATION_TAX("bounty_prize_corporation_tax"),

        BOUNTY_PRIZES("bounty_prizes"),

        BOUNTY_REIMBURSEMENT("bounty_reimbursement"),

        BOUNTY_SURCHARGE("bounty_surcharge"),

        BROKERS_FEE("brokers_fee"),

        CLONE_ACTIVATION("clone_activation"),

        CLONE_TRANSFER("clone_transfer"),

        CONTRABAND_FINE("contraband_fine"),

        CONTRACT_AUCTION_BID("contract_auction_bid"),

        CONTRACT_AUCTION_BID_CORP("contract_auction_bid_corp"),

        CONTRACT_AUCTION_BID_REFUND("contract_auction_bid_refund"),

        CONTRACT_AUCTION_SOLD("contract_auction_sold"),

        CONTRACT_BROKERS_FEE("contract_brokers_fee"),

        CONTRACT_BROKERS_FEE_CORP("contract_brokers_fee_corp"),

        CONTRACT_COLLATERAL("contract_collateral"),

        CONTRACT_COLLATERAL_DEPOSITED_CORP("contract_collateral_deposited_corp"),

        CONTRACT_COLLATERAL_PAYOUT("contract_collateral_payout"),

        CONTRACT_COLLATERAL_REFUND("contract_collateral_refund"),

        CONTRACT_DEPOSIT("contract_deposit"),

        CONTRACT_DEPOSIT_CORP("contract_deposit_corp"),

        CONTRACT_DEPOSIT_REFUND("contract_deposit_refund"),

        CONTRACT_DEPOSIT_SALES_TAX("contract_deposit_sales_tax"),

        CONTRACT_PRICE("contract_price"),

        CONTRACT_PRICE_PAYMENT_CORP("contract_price_payment_corp"),

        CONTRACT_REVERSAL("contract_reversal"),

        CONTRACT_REWARD("contract_reward"),

        CONTRACT_REWARD_DEPOSITED("contract_reward_deposited"),

        CONTRACT_REWARD_DEPOSITED_CORP("contract_reward_deposited_corp"),

        CONTRACT_REWARD_REFUND("contract_reward_refund"),

        CONTRACT_SALES_TAX("contract_sales_tax"),

        COPYING("copying"),

        CORPORATE_REWARD_PAYOUT("corporate_reward_payout"),

        CORPORATE_REWARD_TAX("corporate_reward_tax"),

        CORPORATION_ACCOUNT_WITHDRAWAL("corporation_account_withdrawal"),

        CORPORATION_BULK_PAYMENT("corporation_bulk_payment"),

        CORPORATION_DIVIDEND_PAYMENT("corporation_dividend_payment"),

        CORPORATION_LIQUIDATION("corporation_liquidation"),

        CORPORATION_LOGO_CHANGE_COST("corporation_logo_change_cost"),

        CORPORATION_PAYMENT("corporation_payment"),

        CORPORATION_REGISTRATION_FEE("corporation_registration_fee"),

        COURIER_MISSION_ESCROW("courier_mission_escrow"),

        CSPA("cspa"),

        CSPAOFFLINEREFUND("cspaofflinerefund"),

        DATACORE_FEE("datacore_fee"),

        DNA_MODIFICATION_FEE("dna_modification_fee"),

        DOCKING_FEE("docking_fee"),

        DUEL_WAGER_ESCROW("duel_wager_escrow"),

        DUEL_WAGER_PAYMENT("duel_wager_payment"),

        DUEL_WAGER_REFUND("duel_wager_refund"),

        FACTORY_SLOT_RENTAL_FEE("factory_slot_rental_fee"),

        GM_CASH_TRANSFER("gm_cash_transfer"),

        INDUSTRY_JOB_TAX("industry_job_tax"),

        INFRASTRUCTURE_HUB_MAINTENANCE("infrastructure_hub_maintenance"),

        INHERITANCE("inheritance"),

        INSURANCE("insurance"),

        JUMP_CLONE_ACTIVATION_FEE("jump_clone_activation_fee"),

        JUMP_CLONE_INSTALLATION_FEE("jump_clone_installation_fee"),

        KILL_RIGHT_FEE("kill_right_fee"),

        LP_STORE("lp_store"),

        MANUFACTURING("manufacturing"),

        MARKET_ESCROW("market_escrow"),

        MARKET_FINE_PAID("market_fine_paid"),

        MARKET_TRANSACTION("market_transaction"),

        MEDAL_CREATION("medal_creation"),

        MEDAL_ISSUED("medal_issued"),

        MISSION_COMPLETION("mission_completion"),

        MISSION_COST("mission_cost"),

        MISSION_EXPIRATION("mission_expiration"),

        MISSION_REWARD("mission_reward"),

        OFFICE_RENTAL_FEE("office_rental_fee"),

        OPERATION_BONUS("operation_bonus"),

        OPPORTUNITY_REWARD("opportunity_reward"),

        PLANETARY_CONSTRUCTION("planetary_construction"),

        PLANETARY_EXPORT_TAX("planetary_export_tax"),

        PLANETARY_IMPORT_TAX("planetary_import_tax"),

        PLAYER_DONATION("player_donation"),

        PLAYER_TRADING("player_trading"),

        PROJECT_DISCOVERY_REWARD("project_discovery_reward"),

        PROJECT_DISCOVERY_TAX("project_discovery_tax"),

        REACTION("reaction"),

        RELEASE_OF_IMPOUNDED_PROPERTY("release_of_impounded_property"),

        REPAIR_BILL("repair_bill"),

        REPROCESSING_TAX("reprocessing_tax"),

        RESEARCHING_MATERIAL_PRODUCTIVITY("researching_material_productivity"),

        RESEARCHING_TECHNOLOGY("researching_technology"),

        RESEARCHING_TIME_PRODUCTIVITY("researching_time_productivity"),

        RESOURCE_WARS_REWARD("resource_wars_reward"),

        REVERSE_ENGINEERING("reverse_engineering"),

        SECURITY_PROCESSING_FEE("security_processing_fee"),

        SHARES("shares"),

        SOVEREIGNITY_BILL("sovereignity_bill"),

        STORE_PURCHASE("store_purchase"),

        STORE_PURCHASE_REFUND("store_purchase_refund"),

        TRANSACTION_TAX("transaction_tax"),

        UPKEEP_ADJUSTMENT_FEE("upkeep_adjustment_fee"),

        WAR_ALLY_CONTRACT("war_ally_contract"),

        WAR_FEE("war_fee"),

        WAR_FEE_SURRENDER("war_fee_surrender");

        private String value;

        RefTypeEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static RefTypeEnum fromValue(String text) {
            for (RefTypeEnum b : RefTypeEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("ref_type")
    private RefTypeEnum refType = null;

    @JsonProperty("first_party_id")
    private Integer firstPartyId = null;

    /**
     * first_party_type string
     */
    public enum FirstPartyTypeEnum {
        CHARACTER("character"),

        CORPORATION("corporation"),

        ALLIANCE("alliance"),

        FACTION("faction"),

        SYSTEM("system");

        private String value;

        FirstPartyTypeEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static FirstPartyTypeEnum fromValue(String text) {
            for (FirstPartyTypeEnum b : FirstPartyTypeEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("first_party_type")
    private FirstPartyTypeEnum firstPartyType = null;

    @JsonProperty("second_party_id")
    private Integer secondPartyId = null;

    /**
     * second_party_type string
     */
    public enum SecondPartyTypeEnum {
        CHARACTER("character"),

        CORPORATION("corporation"),

        ALLIANCE("alliance"),

        FACTION("faction"),

        SYSTEM("system");

        private String value;

        SecondPartyTypeEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static SecondPartyTypeEnum fromValue(String text) {
            for (SecondPartyTypeEnum b : SecondPartyTypeEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("second_party_type")
    private SecondPartyTypeEnum secondPartyType = null;

    @JsonProperty("amount")
    private Double amount = null;

    @JsonProperty("balance")
    private Double balance = null;

    @JsonProperty("reason")
    private String reason = null;

    @JsonProperty("tax_reciever_id")
    private Integer taxRecieverId = null;

    @JsonProperty("tax")
    private Double tax = null;

    @JsonProperty("extra_info")
    private CharacterWalletJournalExtraInfoResponse extraInfo = null;

    public CharacterWalletJournalResponse date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    /**
     * Date and time of transaction
     * 
     * @return date
     **/
    @ApiModelProperty(example = "null", required = true, value = "Date and time of transaction")
    public OffsetDateTime getDate() {
        return date;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public CharacterWalletJournalResponse refId(Long refId) {
        this.refId = refId;
        return this;
    }

    /**
     * Unique journal reference ID
     * 
     * @return refId
     **/
    @ApiModelProperty(example = "null", required = true, value = "Unique journal reference ID")
    public Long getRefId() {
        return refId;
    }

    public void setRefId(Long refId) {
        this.refId = refId;
    }

    public CharacterWalletJournalResponse refType(RefTypeEnum refType) {
        this.refType = refType;
        return this;
    }

    /**
     * Transaction type, different type of transaction will populate different
     * fields in `extra_info` Note: If you have an existing XML API application
     * that is using ref_types, you will need to know which string ESI ref_type
     * maps to which integer. You can use the following gist to see string->int
     * mappings:
     * https://gist.github.com/ccp-zoetrope/c03db66d90c2148724c06171bc52e0ec
     * 
     * @return refType
     **/
    @ApiModelProperty(example = "null", required = true, value = "Transaction type, different type of transaction will populate different fields in `extra_info` Note: If you have an existing XML API application that is using ref_types, you will need to know which string ESI ref_type maps to which integer. You can use the following gist to see string->int mappings: https://gist.github.com/ccp-zoetrope/c03db66d90c2148724c06171bc52e0ec")
    public RefTypeEnum getRefType() {
        return refType;
    }

    public void setRefType(RefTypeEnum refType) {
        this.refType = refType;
    }

    public CharacterWalletJournalResponse firstPartyId(Integer firstPartyId) {
        this.firstPartyId = firstPartyId;
        return this;
    }

    /**
     * first_party_id integer
     * 
     * @return firstPartyId
     **/
    @ApiModelProperty(example = "null", value = "first_party_id integer")
    public Integer getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Integer firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public CharacterWalletJournalResponse firstPartyType(FirstPartyTypeEnum firstPartyType) {
        this.firstPartyType = firstPartyType;
        return this;
    }

    /**
     * first_party_type string
     * 
     * @return firstPartyType
     **/
    @ApiModelProperty(example = "null", value = "first_party_type string")
    public FirstPartyTypeEnum getFirstPartyType() {
        return firstPartyType;
    }

    public void setFirstPartyType(FirstPartyTypeEnum firstPartyType) {
        this.firstPartyType = firstPartyType;
    }

    public CharacterWalletJournalResponse secondPartyId(Integer secondPartyId) {
        this.secondPartyId = secondPartyId;
        return this;
    }

    /**
     * second_party_id integer
     * 
     * @return secondPartyId
     **/
    @ApiModelProperty(example = "null", value = "second_party_id integer")
    public Integer getSecondPartyId() {
        return secondPartyId;
    }

    public void setSecondPartyId(Integer secondPartyId) {
        this.secondPartyId = secondPartyId;
    }

    public CharacterWalletJournalResponse secondPartyType(SecondPartyTypeEnum secondPartyType) {
        this.secondPartyType = secondPartyType;
        return this;
    }

    /**
     * second_party_type string
     * 
     * @return secondPartyType
     **/
    @ApiModelProperty(example = "null", value = "second_party_type string")
    public SecondPartyTypeEnum getSecondPartyType() {
        return secondPartyType;
    }

    public void setSecondPartyType(SecondPartyTypeEnum secondPartyType) {
        this.secondPartyType = secondPartyType;
    }

    public CharacterWalletJournalResponse amount(Double amount) {
        this.amount = amount;
        return this;
    }

    /**
     * Transaction amount. Positive when value transferred to the first party.
     * Negative otherwise
     * 
     * @return amount
     **/
    @ApiModelProperty(example = "null", value = "Transaction amount. Positive when value transferred to the first party. Negative otherwise")
    public Double getAmount() {
        return amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public CharacterWalletJournalResponse balance(Double balance) {
        this.balance = balance;
        return this;
    }

    /**
     * Wallet balance after transaction occurred
     * 
     * @return balance
     **/
    @ApiModelProperty(example = "null", value = "Wallet balance after transaction occurred")
    public Double getBalance() {
        return balance;
    }

    public void setBalance(Double balance) {
        this.balance = balance;
    }

    public CharacterWalletJournalResponse reason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * reason string
     * 
     * @return reason
     **/
    @ApiModelProperty(example = "null", value = "reason string")
    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public CharacterWalletJournalResponse taxRecieverId(Integer taxRecieverId) {
        this.taxRecieverId = taxRecieverId;
        return this;
    }

    /**
     * the corporation ID receiving any tax paid
     * 
     * @return taxRecieverId
     **/
    @ApiModelProperty(example = "null", value = "the corporation ID receiving any tax paid")
    public Integer getTaxRecieverId() {
        return taxRecieverId;
    }

    public void setTaxRecieverId(Integer taxRecieverId) {
        this.taxRecieverId = taxRecieverId;
    }

    public CharacterWalletJournalResponse tax(Double tax) {
        this.tax = tax;
        return this;
    }

    /**
     * Tax amount received for tax related transactions
     * 
     * @return tax
     **/
    @ApiModelProperty(example = "null", value = "Tax amount received for tax related transactions")
    public Double getTax() {
        return tax;
    }

    public void setTax(Double tax) {
        this.tax = tax;
    }

    public CharacterWalletJournalResponse extraInfo(CharacterWalletJournalExtraInfoResponse extraInfo) {
        this.extraInfo = extraInfo;
        return this;
    }

    /**
     * Get extraInfo
     * 
     * @return extraInfo
     **/
    @ApiModelProperty(example = "null", value = "")
    public CharacterWalletJournalExtraInfoResponse getExtraInfo() {
        return extraInfo;
    }

    public void setExtraInfo(CharacterWalletJournalExtraInfoResponse extraInfo) {
        this.extraInfo = extraInfo;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CharacterWalletJournalResponse characterWalletJournalResponse = (CharacterWalletJournalResponse) o;
        return Objects.equals(this.date, characterWalletJournalResponse.date)
                && Objects.equals(this.refId, characterWalletJournalResponse.refId)
                && Objects.equals(this.refType, characterWalletJournalResponse.refType)
                && Objects.equals(this.firstPartyId, characterWalletJournalResponse.firstPartyId)
                && Objects.equals(this.firstPartyType, characterWalletJournalResponse.firstPartyType)
                && Objects.equals(this.secondPartyId, characterWalletJournalResponse.secondPartyId)
                && Objects.equals(this.secondPartyType, characterWalletJournalResponse.secondPartyType)
                && Objects.equals(this.amount, characterWalletJournalResponse.amount)
                && Objects.equals(this.balance, characterWalletJournalResponse.balance)
                && Objects.equals(this.reason, characterWalletJournalResponse.reason)
                && Objects.equals(this.taxRecieverId, characterWalletJournalResponse.taxRecieverId)
                && Objects.equals(this.tax, characterWalletJournalResponse.tax)
                && Objects.equals(this.extraInfo, characterWalletJournalResponse.extraInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(date, refId, refType, firstPartyId, firstPartyType, secondPartyId, secondPartyType, amount,
                balance, reason, taxRecieverId, tax, extraInfo);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacterWalletJournalResponse {\n");

        sb.append("    date: ").append(toIndentedString(date)).append("\n");
        sb.append("    refId: ").append(toIndentedString(refId)).append("\n");
        sb.append("    refType: ").append(toIndentedString(refType)).append("\n");
        sb.append("    firstPartyId: ").append(toIndentedString(firstPartyId)).append("\n");
        sb.append("    firstPartyType: ").append(toIndentedString(firstPartyType)).append("\n");
        sb.append("    secondPartyId: ").append(toIndentedString(secondPartyId)).append("\n");
        sb.append("    secondPartyType: ").append(toIndentedString(secondPartyType)).append("\n");
        sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
        sb.append("    balance: ").append(toIndentedString(balance)).append("\n");
        sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
        sb.append("    taxRecieverId: ").append(toIndentedString(taxRecieverId)).append("\n");
        sb.append("    tax: ").append(toIndentedString(tax)).append("\n");
        sb.append("    extraInfo: ").append(toIndentedString(extraInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
