/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CorporationResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="corporation_name")
    private String corporationName = null;
    @JsonProperty(value="ticker")
    private String ticker = null;
    @JsonProperty(value="member_count")
    private Integer memberCount = null;
    @JsonProperty(value="ceo_id")
    private Integer ceoId = null;
    @JsonProperty(value="alliance_id")
    private Integer allianceId = null;
    @JsonProperty(value="corporation_description")
    private String corporationDescription = null;
    @JsonProperty(value="tax_rate")
    private Float taxRate = null;
    @JsonProperty(value="creation_date")
    private OffsetDateTime creationDate = null;
    @JsonProperty(value="creator_id")
    private Integer creatorId = null;
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="faction")
    private FactionEnum faction = null;

    public CorporationResponse corporationName(String string) {
        this.corporationName = string;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="the full name of the corporation")
    public String getCorporationName() {
        return this.corporationName;
    }

    public void setCorporationName(String string) {
        this.corporationName = string;
    }

    public CorporationResponse ticker(String string) {
        this.ticker = string;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="the short name of the corporation")
    public String getTicker() {
        return this.ticker;
    }

    public void setTicker(String string) {
        this.ticker = string;
    }

    public CorporationResponse memberCount(Integer n) {
        this.memberCount = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="member_count integer")
    public Integer getMemberCount() {
        return this.memberCount;
    }

    public void setMemberCount(Integer n) {
        this.memberCount = n;
    }

    public CorporationResponse ceoId(Integer n) {
        this.ceoId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ceo_id integer")
    public Integer getCeoId() {
        return this.ceoId;
    }

    public void setCeoId(Integer n) {
        this.ceoId = n;
    }

    public CorporationResponse allianceId(Integer n) {
        this.allianceId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="id of alliance that corporation is a member of, if any")
    public Integer getAllianceId() {
        return this.allianceId;
    }

    public void setAllianceId(Integer n) {
        this.allianceId = n;
    }

    public CorporationResponse corporationDescription(String string) {
        this.corporationDescription = string;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="corporation_description string")
    public String getCorporationDescription() {
        return this.corporationDescription;
    }

    public void setCorporationDescription(String string) {
        this.corporationDescription = string;
    }

    public CorporationResponse taxRate(Float f) {
        this.taxRate = f;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="tax_rate number")
    public Float getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(Float f) {
        this.taxRate = f;
    }

    public CorporationResponse creationDate(OffsetDateTime offsetDateTime) {
        this.creationDate = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="creation_date string")
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(OffsetDateTime offsetDateTime) {
        this.creationDate = offsetDateTime;
    }

    public CorporationResponse creatorId(Integer n) {
        this.creatorId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="creator_id integer")
    public Integer getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(Integer n) {
        this.creatorId = n;
    }

    public CorporationResponse url(String string) {
        this.url = string;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="url string")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public CorporationResponse faction(FactionEnum factionEnum) {
        this.faction = factionEnum;
        return this;
    }

    @ApiModelProperty(example="null", value="faction string")
    public FactionEnum getFaction() {
        return this.faction;
    }

    public void setFaction(FactionEnum factionEnum) {
        this.faction = factionEnum;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CorporationResponse corporationResponse = (CorporationResponse)object;
        return Objects.equals(this.corporationName, corporationResponse.corporationName) && Objects.equals(this.ticker, corporationResponse.ticker) && Objects.equals(this.memberCount, corporationResponse.memberCount) && Objects.equals(this.ceoId, corporationResponse.ceoId) && Objects.equals(this.allianceId, corporationResponse.allianceId) && Objects.equals(this.corporationDescription, corporationResponse.corporationDescription) && Objects.equals(this.taxRate, corporationResponse.taxRate) && Objects.equals(this.creationDate, corporationResponse.creationDate) && Objects.equals(this.creatorId, corporationResponse.creatorId) && Objects.equals(this.url, corporationResponse.url) && Objects.equals((Object)this.faction, (Object)corporationResponse.faction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.corporationName, this.ticker, this.memberCount, this.ceoId, this.allianceId, this.corporationDescription, this.taxRate, this.creationDate, this.creatorId, this.url, this.faction});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CorporationResponse {\n");
        stringBuilder.append("    corporationName: ").append(this.toIndentedString(this.corporationName)).append("\n");
        stringBuilder.append("    ticker: ").append(this.toIndentedString(this.ticker)).append("\n");
        stringBuilder.append("    memberCount: ").append(this.toIndentedString(this.memberCount)).append("\n");
        stringBuilder.append("    ceoId: ").append(this.toIndentedString(this.ceoId)).append("\n");
        stringBuilder.append("    allianceId: ").append(this.toIndentedString(this.allianceId)).append("\n");
        stringBuilder.append("    corporationDescription: ").append(this.toIndentedString(this.corporationDescription)).append("\n");
        stringBuilder.append("    taxRate: ").append(this.toIndentedString(this.taxRate)).append("\n");
        stringBuilder.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        stringBuilder.append("    creatorId: ").append(this.toIndentedString(this.creatorId)).append("\n");
        stringBuilder.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        stringBuilder.append("    faction: ").append(this.toIndentedString((Object)this.faction)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    public static enum FactionEnum {
        MINMATAR("Minmatar"),
        GALLENTE("Gallente"),
        CALDARI("Caldari"),
        AMARR("Amarr");

        private String value;

        private FactionEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FactionEnum fromValue(String string) {
            for (FactionEnum factionEnum : FactionEnum.values()) {
                if (!String.valueOf(factionEnum.value).equals(string)) continue;
                return factionEnum;
            }
            return null;
        }
    }
}

