/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CharacterResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="corporation_id")
    private Integer corporationId = null;
    @JsonProperty(value="alliance_id")
    private Integer allianceId = null;
    @JsonProperty(value="birthday")
    private OffsetDateTime birthday = null;
    @JsonProperty(value="gender")
    private GenderEnum gender = null;
    @JsonProperty(value="race_id")
    private Integer raceId = null;
    @JsonProperty(value="bloodline_id")
    private Integer bloodlineId = null;
    @JsonProperty(value="ancestry_id")
    private Integer ancestryId = null;
    @JsonProperty(value="security_status")
    private Float securityStatus = null;
    @JsonProperty(value="faction_id")
    private Integer factionId = null;

    public CharacterResponse name(String string) {
        this.name = string;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="name string")
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public CharacterResponse description(String string) {
        this.description = string;
        return this;
    }

    @ApiModelProperty(example="null", value="description string")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public CharacterResponse corporationId(Integer n) {
        this.corporationId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The character's corporation ID")
    public Integer getCorporationId() {
        return this.corporationId;
    }

    public void setCorporationId(Integer n) {
        this.corporationId = n;
    }

    public CharacterResponse allianceId(Integer n) {
        this.allianceId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="The character's alliance ID")
    public Integer getAllianceId() {
        return this.allianceId;
    }

    public void setAllianceId(Integer n) {
        this.allianceId = n;
    }

    public CharacterResponse birthday(OffsetDateTime offsetDateTime) {
        this.birthday = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Creation date of the character")
    public OffsetDateTime getBirthday() {
        return this.birthday;
    }

    public void setBirthday(OffsetDateTime offsetDateTime) {
        this.birthday = offsetDateTime;
    }

    public CharacterResponse gender(GenderEnum genderEnum) {
        this.gender = genderEnum;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="gender string")
    public GenderEnum getGender() {
        return this.gender;
    }

    public void setGender(GenderEnum genderEnum) {
        this.gender = genderEnum;
    }

    public CharacterResponse raceId(Integer n) {
        this.raceId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="race_id integer")
    public Integer getRaceId() {
        return this.raceId;
    }

    public void setRaceId(Integer n) {
        this.raceId = n;
    }

    public CharacterResponse bloodlineId(Integer n) {
        this.bloodlineId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="bloodline_id integer")
    public Integer getBloodlineId() {
        return this.bloodlineId;
    }

    public void setBloodlineId(Integer n) {
        this.bloodlineId = n;
    }

    public CharacterResponse ancestryId(Integer n) {
        this.ancestryId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="ancestry_id integer")
    public Integer getAncestryId() {
        return this.ancestryId;
    }

    public void setAncestryId(Integer n) {
        this.ancestryId = n;
    }

    public CharacterResponse securityStatus(Float f) {
        this.securityStatus = f;
        return this;
    }

    @ApiModelProperty(example="null", value="security_status number")
    public Float getSecurityStatus() {
        return this.securityStatus;
    }

    public void setSecurityStatus(Float f) {
        this.securityStatus = f;
    }

    public CharacterResponse factionId(Integer n) {
        this.factionId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the faction the character is fighting for, if the character is enlisted in Factional Warfare")
    public Integer getFactionId() {
        return this.factionId;
    }

    public void setFactionId(Integer n) {
        this.factionId = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CharacterResponse characterResponse = (CharacterResponse)object;
        return Objects.equals(this.name, characterResponse.name) && Objects.equals(this.description, characterResponse.description) && Objects.equals(this.corporationId, characterResponse.corporationId) && Objects.equals(this.allianceId, characterResponse.allianceId) && Objects.equals(this.birthday, characterResponse.birthday) && Objects.equals((Object)this.gender, (Object)characterResponse.gender) && Objects.equals(this.raceId, characterResponse.raceId) && Objects.equals(this.bloodlineId, characterResponse.bloodlineId) && Objects.equals(this.ancestryId, characterResponse.ancestryId) && Objects.equals(this.securityStatus, characterResponse.securityStatus) && Objects.equals(this.factionId, characterResponse.factionId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.corporationId, this.allianceId, this.birthday, this.gender, this.raceId, this.bloodlineId, this.ancestryId, this.securityStatus, this.factionId});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CharacterResponse {\n");
        stringBuilder.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        stringBuilder.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        stringBuilder.append("    corporationId: ").append(this.toIndentedString(this.corporationId)).append("\n");
        stringBuilder.append("    allianceId: ").append(this.toIndentedString(this.allianceId)).append("\n");
        stringBuilder.append("    birthday: ").append(this.toIndentedString(this.birthday)).append("\n");
        stringBuilder.append("    gender: ").append(this.toIndentedString((Object)this.gender)).append("\n");
        stringBuilder.append("    raceId: ").append(this.toIndentedString(this.raceId)).append("\n");
        stringBuilder.append("    bloodlineId: ").append(this.toIndentedString(this.bloodlineId)).append("\n");
        stringBuilder.append("    ancestryId: ").append(this.toIndentedString(this.ancestryId)).append("\n");
        stringBuilder.append("    securityStatus: ").append(this.toIndentedString(this.securityStatus)).append("\n");
        stringBuilder.append("    factionId: ").append(this.toIndentedString(this.factionId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    public static enum GenderEnum {
        FEMALE("female"),
        MALE("male");

        private String value;

        private GenderEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GenderEnum fromValue(String string) {
            for (GenderEnum genderEnum : GenderEnum.values()) {
                if (!String.valueOf(genderEnum.value).equals(string)) continue;
                return genderEnum;
            }
            return null;
        }
    }
}

