/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CharacterIndustryJobsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="job_id")
    private Integer jobId = null;
    @JsonProperty(value="installer_id")
    private Integer installerId = null;
    @JsonProperty(value="facility_id")
    private Long facilityId = null;
    @JsonProperty(value="station_id")
    private Long stationId = null;
    @JsonProperty(value="activity_id")
    private Integer activityId = null;
    @JsonProperty(value="blueprint_id")
    private Long blueprintId = null;
    @JsonProperty(value="blueprint_type_id")
    private Integer blueprintTypeId = null;
    @JsonProperty(value="blueprint_location_id")
    private Long blueprintLocationId = null;
    @JsonProperty(value="output_location_id")
    private Long outputLocationId = null;
    @JsonProperty(value="runs")
    private Integer runs = null;
    @JsonProperty(value="cost")
    private Float cost = null;
    @JsonProperty(value="licensed_runs")
    private Integer licensedRuns = null;
    @JsonProperty(value="probability")
    private Float probability = null;
    @JsonProperty(value="product_type_id")
    private Integer productTypeId = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="duration")
    private Integer duration = null;
    @JsonProperty(value="start_date")
    private OffsetDateTime startDate = null;
    @JsonProperty(value="end_date")
    private OffsetDateTime endDate = null;
    @JsonProperty(value="pause_date")
    private OffsetDateTime pauseDate = null;
    @JsonProperty(value="completed_date")
    private OffsetDateTime completedDate = null;
    @JsonProperty(value="completed_character_id")
    private Integer completedCharacterId = null;
    @JsonProperty(value="successful_runs")
    private Integer successfulRuns = null;

    public CharacterIndustryJobsResponse jobId(Integer n) {
        this.jobId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Unique job ID")
    public Integer getJobId() {
        return this.jobId;
    }

    public void setJobId(Integer n) {
        this.jobId = n;
    }

    public CharacterIndustryJobsResponse installerId(Integer n) {
        this.installerId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the character which installed this job")
    public Integer getInstallerId() {
        return this.installerId;
    }

    public void setInstallerId(Integer n) {
        this.installerId = n;
    }

    public CharacterIndustryJobsResponse facilityId(Long l) {
        this.facilityId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the facility where this job is running")
    public Long getFacilityId() {
        return this.facilityId;
    }

    public void setFacilityId(Long l) {
        this.facilityId = l;
    }

    public CharacterIndustryJobsResponse stationId(Long l) {
        this.stationId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the station where industry facility is located")
    public Long getStationId() {
        return this.stationId;
    }

    public void setStationId(Long l) {
        this.stationId = l;
    }

    public CharacterIndustryJobsResponse activityId(Integer n) {
        this.activityId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Job activity ID")
    public Integer getActivityId() {
        return this.activityId;
    }

    public void setActivityId(Integer n) {
        this.activityId = n;
    }

    public CharacterIndustryJobsResponse blueprintId(Long l) {
        this.blueprintId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="blueprint_id integer")
    public Long getBlueprintId() {
        return this.blueprintId;
    }

    public void setBlueprintId(Long l) {
        this.blueprintId = l;
    }

    public CharacterIndustryJobsResponse blueprintTypeId(Integer n) {
        this.blueprintTypeId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="blueprint_type_id integer")
    public Integer getBlueprintTypeId() {
        return this.blueprintTypeId;
    }

    public void setBlueprintTypeId(Integer n) {
        this.blueprintTypeId = n;
    }

    public CharacterIndustryJobsResponse blueprintLocationId(Long l) {
        this.blueprintLocationId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Location ID of the location from which the blueprint was installed. Normally a station ID, but can also be an asset (e.g. container) or corporation facility")
    public Long getBlueprintLocationId() {
        return this.blueprintLocationId;
    }

    public void setBlueprintLocationId(Long l) {
        this.blueprintLocationId = l;
    }

    public CharacterIndustryJobsResponse outputLocationId(Long l) {
        this.outputLocationId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Location ID of the location to which the output of the job will be delivered. Normally a station ID, but can also be a corporation facility")
    public Long getOutputLocationId() {
        return this.outputLocationId;
    }

    public void setOutputLocationId(Long l) {
        this.outputLocationId = l;
    }

    public CharacterIndustryJobsResponse runs(Integer n) {
        this.runs = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Number of runs for a manufacturing job, or number of copies to make for a blueprint copy")
    public Integer getRuns() {
        return this.runs;
    }

    public void setRuns(Integer n) {
        this.runs = n;
    }

    public CharacterIndustryJobsResponse cost(Float f) {
        this.cost = f;
        return this;
    }

    @ApiModelProperty(example="null", value="The sume of job installation fee and industry facility tax")
    public Float getCost() {
        return this.cost;
    }

    public void setCost(Float f) {
        this.cost = f;
    }

    public CharacterIndustryJobsResponse licensedRuns(Integer n) {
        this.licensedRuns = n;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of runs blueprint is licensed for")
    public Integer getLicensedRuns() {
        return this.licensedRuns;
    }

    public void setLicensedRuns(Integer n) {
        this.licensedRuns = n;
    }

    public CharacterIndustryJobsResponse probability(Float f) {
        this.probability = f;
        return this;
    }

    @ApiModelProperty(example="null", value="Chance of success for invention")
    public Float getProbability() {
        return this.probability;
    }

    public void setProbability(Float f) {
        this.probability = f;
    }

    public CharacterIndustryJobsResponse productTypeId(Integer n) {
        this.productTypeId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="Type ID of product (manufactured, copied or invented)")
    public Integer getProductTypeId() {
        return this.productTypeId;
    }

    public void setProductTypeId(Integer n) {
        this.productTypeId = n;
    }

    public CharacterIndustryJobsResponse status(StatusEnum statusEnum) {
        this.status = statusEnum;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="status string")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum statusEnum) {
        this.status = statusEnum;
    }

    public CharacterIndustryJobsResponse duration(Integer n) {
        this.duration = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Job duration in seconds")
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer n) {
        this.duration = n;
    }

    public CharacterIndustryJobsResponse startDate(OffsetDateTime offsetDateTime) {
        this.startDate = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Date and time when this job started")
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime offsetDateTime) {
        this.startDate = offsetDateTime;
    }

    public CharacterIndustryJobsResponse endDate(OffsetDateTime offsetDateTime) {
        this.endDate = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Date and time when this job finished")
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime offsetDateTime) {
        this.endDate = offsetDateTime;
    }

    public CharacterIndustryJobsResponse pauseDate(OffsetDateTime offsetDateTime) {
        this.pauseDate = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Date and time when this job was paused (i.e. time when the facility where this job was installed went offline)")
    public OffsetDateTime getPauseDate() {
        return this.pauseDate;
    }

    public void setPauseDate(OffsetDateTime offsetDateTime) {
        this.pauseDate = offsetDateTime;
    }

    public CharacterIndustryJobsResponse completedDate(OffsetDateTime offsetDateTime) {
        this.completedDate = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Date and time when this job was completed")
    public OffsetDateTime getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(OffsetDateTime offsetDateTime) {
        this.completedDate = offsetDateTime;
    }

    public CharacterIndustryJobsResponse completedCharacterId(Integer n) {
        this.completedCharacterId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the character which completed this job")
    public Integer getCompletedCharacterId() {
        return this.completedCharacterId;
    }

    public void setCompletedCharacterId(Integer n) {
        this.completedCharacterId = n;
    }

    public CharacterIndustryJobsResponse successfulRuns(Integer n) {
        this.successfulRuns = n;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of successful runs for this job. Equal to runs unless this is an invention job")
    public Integer getSuccessfulRuns() {
        return this.successfulRuns;
    }

    public void setSuccessfulRuns(Integer n) {
        this.successfulRuns = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CharacterIndustryJobsResponse characterIndustryJobsResponse = (CharacterIndustryJobsResponse)object;
        return Objects.equals(this.jobId, characterIndustryJobsResponse.jobId) && Objects.equals(this.installerId, characterIndustryJobsResponse.installerId) && Objects.equals(this.facilityId, characterIndustryJobsResponse.facilityId) && Objects.equals(this.stationId, characterIndustryJobsResponse.stationId) && Objects.equals(this.activityId, characterIndustryJobsResponse.activityId) && Objects.equals(this.blueprintId, characterIndustryJobsResponse.blueprintId) && Objects.equals(this.blueprintTypeId, characterIndustryJobsResponse.blueprintTypeId) && Objects.equals(this.blueprintLocationId, characterIndustryJobsResponse.blueprintLocationId) && Objects.equals(this.outputLocationId, characterIndustryJobsResponse.outputLocationId) && Objects.equals(this.runs, characterIndustryJobsResponse.runs) && Objects.equals(this.cost, characterIndustryJobsResponse.cost) && Objects.equals(this.licensedRuns, characterIndustryJobsResponse.licensedRuns) && Objects.equals(this.probability, characterIndustryJobsResponse.probability) && Objects.equals(this.productTypeId, characterIndustryJobsResponse.productTypeId) && Objects.equals((Object)this.status, (Object)characterIndustryJobsResponse.status) && Objects.equals(this.duration, characterIndustryJobsResponse.duration) && Objects.equals(this.startDate, characterIndustryJobsResponse.startDate) && Objects.equals(this.endDate, characterIndustryJobsResponse.endDate) && Objects.equals(this.pauseDate, characterIndustryJobsResponse.pauseDate) && Objects.equals(this.completedDate, characterIndustryJobsResponse.completedDate) && Objects.equals(this.completedCharacterId, characterIndustryJobsResponse.completedCharacterId) && Objects.equals(this.successfulRuns, characterIndustryJobsResponse.successfulRuns);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.installerId, this.facilityId, this.stationId, this.activityId, this.blueprintId, this.blueprintTypeId, this.blueprintLocationId, this.outputLocationId, this.runs, this.cost, this.licensedRuns, this.probability, this.productTypeId, this.status, this.duration, this.startDate, this.endDate, this.pauseDate, this.completedDate, this.completedCharacterId, this.successfulRuns});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CharacterIndustryJobsResponse {\n");
        stringBuilder.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        stringBuilder.append("    installerId: ").append(this.toIndentedString(this.installerId)).append("\n");
        stringBuilder.append("    facilityId: ").append(this.toIndentedString(this.facilityId)).append("\n");
        stringBuilder.append("    stationId: ").append(this.toIndentedString(this.stationId)).append("\n");
        stringBuilder.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        stringBuilder.append("    blueprintId: ").append(this.toIndentedString(this.blueprintId)).append("\n");
        stringBuilder.append("    blueprintTypeId: ").append(this.toIndentedString(this.blueprintTypeId)).append("\n");
        stringBuilder.append("    blueprintLocationId: ").append(this.toIndentedString(this.blueprintLocationId)).append("\n");
        stringBuilder.append("    outputLocationId: ").append(this.toIndentedString(this.outputLocationId)).append("\n");
        stringBuilder.append("    runs: ").append(this.toIndentedString(this.runs)).append("\n");
        stringBuilder.append("    cost: ").append(this.toIndentedString(this.cost)).append("\n");
        stringBuilder.append("    licensedRuns: ").append(this.toIndentedString(this.licensedRuns)).append("\n");
        stringBuilder.append("    probability: ").append(this.toIndentedString(this.probability)).append("\n");
        stringBuilder.append("    productTypeId: ").append(this.toIndentedString(this.productTypeId)).append("\n");
        stringBuilder.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        stringBuilder.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        stringBuilder.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        stringBuilder.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        stringBuilder.append("    pauseDate: ").append(this.toIndentedString(this.pauseDate)).append("\n");
        stringBuilder.append("    completedDate: ").append(this.toIndentedString(this.completedDate)).append("\n");
        stringBuilder.append("    completedCharacterId: ").append(this.toIndentedString(this.completedCharacterId)).append("\n");
        stringBuilder.append("    successfulRuns: ").append(this.toIndentedString(this.successfulRuns)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("active"),
        CANCELLED("cancelled"),
        DELIVERED("delivered"),
        PAUSED("paused"),
        READY("ready"),
        REVERTED("reverted");

        private String value;

        private StatusEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String string) {
            for (StatusEnum statusEnum : StatusEnum.values()) {
                if (!String.valueOf(statusEnum.value).equals(string)) continue;
                return statusEnum;
            }
            return null;
        }
    }
}

