/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.StructureService;
import net.troja.eve.esi.model.VulnerabilityWindow;

@ApiModel(description="200 ok object")
public class CorporationStructuresResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="structure_id")
    private Long structureId = null;
    @JsonProperty(value="type_id")
    private Integer typeId = null;
    @JsonProperty(value="corporation_id")
    private Integer corporationId = null;
    @JsonProperty(value="system_id")
    private Integer systemId = null;
    @JsonProperty(value="profile_id")
    private Integer profileId = null;
    @JsonProperty(value="current_vul")
    private List<VulnerabilityWindow> currentVul = new ArrayList<VulnerabilityWindow>();
    @JsonProperty(value="next_vul")
    private List<VulnerabilityWindow> nextVul = new ArrayList<VulnerabilityWindow>();
    @JsonProperty(value="fuel_expires")
    private LocalDate fuelExpires = null;
    @JsonProperty(value="services")
    private List<StructureService> services = new ArrayList<StructureService>();
    @JsonProperty(value="state_timer_start")
    private LocalDate stateTimerStart = null;
    @JsonProperty(value="state_timer_end")
    private LocalDate stateTimerEnd = null;
    @JsonProperty(value="unanchors_at")
    private LocalDate unanchorsAt = null;

    public CorporationStructuresResponse structureId(Long l) {
        this.structureId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Item ID of the structure")
    public Long getStructureId() {
        return this.structureId;
    }

    public void setStructureId(Long l) {
        this.structureId = l;
    }

    public CorporationStructuresResponse typeId(Integer n) {
        this.typeId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type id of the structure")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer n) {
        this.typeId = n;
    }

    public CorporationStructuresResponse corporationId(Integer n) {
        this.corporationId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the corporation that owns the structure")
    public Integer getCorporationId() {
        return this.corporationId;
    }

    public void setCorporationId(Integer n) {
        this.corporationId = n;
    }

    public CorporationStructuresResponse systemId(Integer n) {
        this.systemId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The solar system the structure is in")
    public Integer getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Integer n) {
        this.systemId = n;
    }

    public CorporationStructuresResponse profileId(Integer n) {
        this.profileId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id of the ACL profile for this citadel")
    public Integer getProfileId() {
        return this.profileId;
    }

    public void setProfileId(Integer n) {
        this.profileId = n;
    }

    public CorporationStructuresResponse currentVul(List<VulnerabilityWindow> list) {
        this.currentVul = list;
        return this;
    }

    public CorporationStructuresResponse addCurrentVulItem(VulnerabilityWindow vulnerabilityWindow) {
        this.currentVul.add(vulnerabilityWindow);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="This week's vulnerability windows, Monday is day 0")
    public List<VulnerabilityWindow> getCurrentVul() {
        return this.currentVul;
    }

    public void setCurrentVul(List<VulnerabilityWindow> list) {
        this.currentVul = list;
    }

    public CorporationStructuresResponse nextVul(List<VulnerabilityWindow> list) {
        this.nextVul = list;
        return this;
    }

    public CorporationStructuresResponse addNextVulItem(VulnerabilityWindow vulnerabilityWindow) {
        this.nextVul.add(vulnerabilityWindow);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Next week's vulnerability windows, Monday is day 0")
    public List<VulnerabilityWindow> getNextVul() {
        return this.nextVul;
    }

    public void setNextVul(List<VulnerabilityWindow> list) {
        this.nextVul = list;
    }

    public CorporationStructuresResponse fuelExpires(LocalDate localDate) {
        this.fuelExpires = localDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date on which the structure will run out of fuel")
    public LocalDate getFuelExpires() {
        return this.fuelExpires;
    }

    public void setFuelExpires(LocalDate localDate) {
        this.fuelExpires = localDate;
    }

    public CorporationStructuresResponse services(List<StructureService> list) {
        this.services = list;
        return this;
    }

    public CorporationStructuresResponse addServicesItem(StructureService structureService) {
        this.services.add(structureService);
        return this;
    }

    @ApiModelProperty(example="null", value="Contains a list of service upgrades, and their state")
    public List<StructureService> getServices() {
        return this.services;
    }

    public void setServices(List<StructureService> list) {
        this.services = list;
    }

    public CorporationStructuresResponse stateTimerStart(LocalDate localDate) {
        this.stateTimerStart = localDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date at which the structure entered it's current state")
    public LocalDate getStateTimerStart() {
        return this.stateTimerStart;
    }

    public void setStateTimerStart(LocalDate localDate) {
        this.stateTimerStart = localDate;
    }

    public CorporationStructuresResponse stateTimerEnd(LocalDate localDate) {
        this.stateTimerEnd = localDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date at which the structure will move to it's next state")
    public LocalDate getStateTimerEnd() {
        return this.stateTimerEnd;
    }

    public void setStateTimerEnd(LocalDate localDate) {
        this.stateTimerEnd = localDate;
    }

    public CorporationStructuresResponse unanchorsAt(LocalDate localDate) {
        this.unanchorsAt = localDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date at which the structure will unanchor")
    public LocalDate getUnanchorsAt() {
        return this.unanchorsAt;
    }

    public void setUnanchorsAt(LocalDate localDate) {
        this.unanchorsAt = localDate;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CorporationStructuresResponse corporationStructuresResponse = (CorporationStructuresResponse)object;
        return Objects.equals(this.structureId, corporationStructuresResponse.structureId) && Objects.equals(this.typeId, corporationStructuresResponse.typeId) && Objects.equals(this.corporationId, corporationStructuresResponse.corporationId) && Objects.equals(this.systemId, corporationStructuresResponse.systemId) && Objects.equals(this.profileId, corporationStructuresResponse.profileId) && Objects.equals(this.currentVul, corporationStructuresResponse.currentVul) && Objects.equals(this.nextVul, corporationStructuresResponse.nextVul) && Objects.equals(this.fuelExpires, corporationStructuresResponse.fuelExpires) && Objects.equals(this.services, corporationStructuresResponse.services) && Objects.equals(this.stateTimerStart, corporationStructuresResponse.stateTimerStart) && Objects.equals(this.stateTimerEnd, corporationStructuresResponse.stateTimerEnd) && Objects.equals(this.unanchorsAt, corporationStructuresResponse.unanchorsAt);
    }

    public int hashCode() {
        return Objects.hash(this.structureId, this.typeId, this.corporationId, this.systemId, this.profileId, this.currentVul, this.nextVul, this.fuelExpires, this.services, this.stateTimerStart, this.stateTimerEnd, this.unanchorsAt);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CorporationStructuresResponse {\n");
        stringBuilder.append("    structureId: ").append(this.toIndentedString(this.structureId)).append("\n");
        stringBuilder.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        stringBuilder.append("    corporationId: ").append(this.toIndentedString(this.corporationId)).append("\n");
        stringBuilder.append("    systemId: ").append(this.toIndentedString(this.systemId)).append("\n");
        stringBuilder.append("    profileId: ").append(this.toIndentedString(this.profileId)).append("\n");
        stringBuilder.append("    currentVul: ").append(this.toIndentedString(this.currentVul)).append("\n");
        stringBuilder.append("    nextVul: ").append(this.toIndentedString(this.nextVul)).append("\n");
        stringBuilder.append("    fuelExpires: ").append(this.toIndentedString(this.fuelExpires)).append("\n");
        stringBuilder.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        stringBuilder.append("    stateTimerStart: ").append(this.toIndentedString(this.stateTimerStart)).append("\n");
        stringBuilder.append("    stateTimerEnd: ").append(this.toIndentedString(this.stateTimerEnd)).append("\n");
        stringBuilder.append("    unanchorsAt: ").append(this.toIndentedString(this.unanchorsAt)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

