/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.KillmailItem;
import net.troja.eve.esi.model.Position;

@ApiModel(description="victim object")
public class KillmailVictim
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="character_id")
    private Integer characterId = null;
    @JsonProperty(value="corporation_id")
    private Integer corporationId = null;
    @JsonProperty(value="alliance_id")
    private Integer allianceId = null;
    @JsonProperty(value="faction_id")
    private Integer factionId = null;
    @JsonProperty(value="damage_taken")
    private Integer damageTaken = null;
    @JsonProperty(value="ship_type_id")
    private Integer shipTypeId = null;
    @JsonProperty(value="items")
    private List<KillmailItem> items = new ArrayList<KillmailItem>();
    @JsonProperty(value="position")
    private Position position = null;

    public KillmailVictim characterId(Integer n) {
        this.characterId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="character_id integer")
    public Integer getCharacterId() {
        return this.characterId;
    }

    public void setCharacterId(Integer n) {
        this.characterId = n;
    }

    public KillmailVictim corporationId(Integer n) {
        this.corporationId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="corporation_id integer")
    public Integer getCorporationId() {
        return this.corporationId;
    }

    public void setCorporationId(Integer n) {
        this.corporationId = n;
    }

    public KillmailVictim allianceId(Integer n) {
        this.allianceId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="alliance_id integer")
    public Integer getAllianceId() {
        return this.allianceId;
    }

    public void setAllianceId(Integer n) {
        this.allianceId = n;
    }

    public KillmailVictim factionId(Integer n) {
        this.factionId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="faction_id integer")
    public Integer getFactionId() {
        return this.factionId;
    }

    public void setFactionId(Integer n) {
        this.factionId = n;
    }

    public KillmailVictim damageTaken(Integer n) {
        this.damageTaken = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="How much total damage was taken by the victim ")
    public Integer getDamageTaken() {
        return this.damageTaken;
    }

    public void setDamageTaken(Integer n) {
        this.damageTaken = n;
    }

    public KillmailVictim shipTypeId(Integer n) {
        this.shipTypeId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ship that the victim was piloting and was destroyed ")
    public Integer getShipTypeId() {
        return this.shipTypeId;
    }

    public void setShipTypeId(Integer n) {
        this.shipTypeId = n;
    }

    public KillmailVictim items(List<KillmailItem> list) {
        this.items = list;
        return this;
    }

    public KillmailVictim addItemsItem(KillmailItem killmailItem) {
        this.items.add(killmailItem);
        return this;
    }

    @ApiModelProperty(example="null", value="items array")
    public List<KillmailItem> getItems() {
        return this.items;
    }

    public void setItems(List<KillmailItem> list) {
        this.items = list;
    }

    public KillmailVictim position(Position position) {
        this.position = position;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        KillmailVictim killmailVictim = (KillmailVictim)object;
        return Objects.equals(this.characterId, killmailVictim.characterId) && Objects.equals(this.corporationId, killmailVictim.corporationId) && Objects.equals(this.allianceId, killmailVictim.allianceId) && Objects.equals(this.factionId, killmailVictim.factionId) && Objects.equals(this.damageTaken, killmailVictim.damageTaken) && Objects.equals(this.shipTypeId, killmailVictim.shipTypeId) && Objects.equals(this.items, killmailVictim.items) && Objects.equals(this.position, killmailVictim.position);
    }

    public int hashCode() {
        return Objects.hash(this.characterId, this.corporationId, this.allianceId, this.factionId, this.damageTaken, this.shipTypeId, this.items, this.position);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class KillmailVictim {\n");
        stringBuilder.append("    characterId: ").append(this.toIndentedString(this.characterId)).append("\n");
        stringBuilder.append("    corporationId: ").append(this.toIndentedString(this.corporationId)).append("\n");
        stringBuilder.append("    allianceId: ").append(this.toIndentedString(this.allianceId)).append("\n");
        stringBuilder.append("    factionId: ").append(this.toIndentedString(this.factionId)).append("\n");
        stringBuilder.append("    damageTaken: ").append(this.toIndentedString(this.damageTaken)).append("\n");
        stringBuilder.append("    shipTypeId: ").append(this.toIndentedString(this.shipTypeId)).append("\n");
        stringBuilder.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        stringBuilder.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

