/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.io.Serializable;

/**
 * Full details of a specific event
 */
@ApiModel(description = "Full details of a specific event")
public class CharacterCalendarEventResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("event_id")
    private Integer eventId = null;

    @JsonProperty("owner_id")
    private Integer ownerId = null;

    @JsonProperty("owner_name")
    private String ownerName = null;

    @JsonProperty("date")
    private OffsetDateTime date = null;

    @JsonProperty("title")
    private String title = null;

    @JsonProperty("duration")
    private Integer duration = null;

    @JsonProperty("importance")
    private Integer importance = null;

    @JsonProperty("response")
    private String response = null;

    @JsonProperty("text")
    private String text = null;

    /**
     * owner_type string
     */
    public enum OwnerTypeEnum {
        EVE_SERVER("eve_server"),

        CORPORATION("corporation"),

        FACTION("faction"),

        CHARACTER("character"),

        ALLIANCE("alliance");

        private String value;

        OwnerTypeEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static OwnerTypeEnum fromValue(String text) {
            for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("owner_type")
    private OwnerTypeEnum ownerType = null;

    public CharacterCalendarEventResponse eventId(Integer eventId) {
        this.eventId = eventId;
        return this;
    }

    /**
     * event_id integer
     * 
     * @return eventId
     **/
    @ApiModelProperty(example = "null", required = true, value = "event_id integer")
    public Integer getEventId() {
        return eventId;
    }

    public void setEventId(Integer eventId) {
        this.eventId = eventId;
    }

    public CharacterCalendarEventResponse ownerId(Integer ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    /**
     * owner_id integer
     * 
     * @return ownerId
     **/
    @ApiModelProperty(example = "null", required = true, value = "owner_id integer")
    public Integer getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Integer ownerId) {
        this.ownerId = ownerId;
    }

    public CharacterCalendarEventResponse ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    /**
     * owner_name string
     * 
     * @return ownerName
     **/
    @ApiModelProperty(example = "null", required = true, value = "owner_name string")
    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public CharacterCalendarEventResponse date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    /**
     * date string
     * 
     * @return date
     **/
    @ApiModelProperty(example = "null", required = true, value = "date string")
    public OffsetDateTime getDate() {
        return date;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public CharacterCalendarEventResponse title(String title) {
        this.title = title;
        return this;
    }

    /**
     * title string
     * 
     * @return title
     **/
    @ApiModelProperty(example = "null", required = true, value = "title string")
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public CharacterCalendarEventResponse duration(Integer duration) {
        this.duration = duration;
        return this;
    }

    /**
     * Length in minutes
     * 
     * @return duration
     **/
    @ApiModelProperty(example = "null", required = true, value = "Length in minutes")
    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public CharacterCalendarEventResponse importance(Integer importance) {
        this.importance = importance;
        return this;
    }

    /**
     * importance integer
     * 
     * @return importance
     **/
    @ApiModelProperty(example = "null", required = true, value = "importance integer")
    public Integer getImportance() {
        return importance;
    }

    public void setImportance(Integer importance) {
        this.importance = importance;
    }

    public CharacterCalendarEventResponse response(String response) {
        this.response = response;
        return this;
    }

    /**
     * response string
     * 
     * @return response
     **/
    @ApiModelProperty(example = "null", required = true, value = "response string")
    public String getResponse() {
        return response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public CharacterCalendarEventResponse text(String text) {
        this.text = text;
        return this;
    }

    /**
     * text string
     * 
     * @return text
     **/
    @ApiModelProperty(example = "null", required = true, value = "text string")
    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public CharacterCalendarEventResponse ownerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
        return this;
    }

    /**
     * owner_type string
     * 
     * @return ownerType
     **/
    @ApiModelProperty(example = "null", required = true, value = "owner_type string")
    public OwnerTypeEnum getOwnerType() {
        return ownerType;
    }

    public void setOwnerType(OwnerTypeEnum ownerType) {
        this.ownerType = ownerType;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CharacterCalendarEventResponse characterCalendarEventResponse = (CharacterCalendarEventResponse) o;
        return Objects.equals(this.eventId, characterCalendarEventResponse.eventId)
                && Objects.equals(this.ownerId, characterCalendarEventResponse.ownerId)
                && Objects.equals(this.ownerName, characterCalendarEventResponse.ownerName)
                && Objects.equals(this.date, characterCalendarEventResponse.date)
                && Objects.equals(this.title, characterCalendarEventResponse.title)
                && Objects.equals(this.duration, characterCalendarEventResponse.duration)
                && Objects.equals(this.importance, characterCalendarEventResponse.importance)
                && Objects.equals(this.response, characterCalendarEventResponse.response)
                && Objects.equals(this.text, characterCalendarEventResponse.text)
                && Objects.equals(this.ownerType, characterCalendarEventResponse.ownerType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(eventId, ownerId, ownerName, date, title, duration, importance, response, text, ownerType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacterCalendarEventResponse {\n");

        sb.append("    eventId: ").append(toIndentedString(eventId)).append("\n");
        sb.append("    ownerId: ").append(toIndentedString(ownerId)).append("\n");
        sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
        sb.append("    date: ").append(toIndentedString(date)).append("\n");
        sb.append("    title: ").append(toIndentedString(title)).append("\n");
        sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
        sb.append("    importance: ").append(toIndentedString(importance)).append("\n");
        sb.append("    response: ").append(toIndentedString(response)).append("\n");
        sb.append("    text: ").append(toIndentedString(text)).append("\n");
        sb.append("    ownerType: ").append(toIndentedString(ownerType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
