/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import net.troja.eve.esi.model.SovereigntyCampaignParticipant;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class SovereigntyCampaignsResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("campaign_id")
    private Integer campaignId = null;

    @JsonProperty("structure_id")
    private Long structureId = null;

    @JsonProperty("solar_system_id")
    private Integer solarSystemId = null;

    @JsonProperty("constellation_id")
    private Integer constellationId = null;

    /**
     * Type of event this campaign is for. tcu_defense, ihub_defense and
     * station_defense are referred to as \"Defense Events\", station_freeport
     * as \"Freeport Events\".
     */
    public enum EventTypeEnum {
        TCU_DEFENSE("tcu_defense"),

        IHUB_DEFENSE("ihub_defense"),

        STATION_DEFENSE("station_defense"),

        STATION_FREEPORT("station_freeport");

        private String value;

        EventTypeEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static EventTypeEnum fromValue(String text) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("event_type")
    private EventTypeEnum eventType = null;

    @JsonProperty("start_time")
    private OffsetDateTime startTime = null;

    @JsonProperty("defender_id")
    private Integer defenderId = null;

    @JsonProperty("defender_score")
    private Float defenderScore = null;

    @JsonProperty("attackers_score")
    private Float attackersScore = null;

    @JsonProperty("participants")
    private List<SovereigntyCampaignParticipant> participants = new ArrayList<SovereigntyCampaignParticipant>();

    public SovereigntyCampaignsResponse campaignId(Integer campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    /**
     * Unique ID for this campaign.
     * 
     * @return campaignId
     **/
    @ApiModelProperty(example = "null", required = true, value = "Unique ID for this campaign.")
    public Integer getCampaignId() {
        return campaignId;
    }

    public void setCampaignId(Integer campaignId) {
        this.campaignId = campaignId;
    }

    public SovereigntyCampaignsResponse structureId(Long structureId) {
        this.structureId = structureId;
        return this;
    }

    /**
     * The structure item ID that is related to this campaign.
     * 
     * @return structureId
     **/
    @ApiModelProperty(example = "null", required = true, value = "The structure item ID that is related to this campaign. ")
    public Long getStructureId() {
        return structureId;
    }

    public void setStructureId(Long structureId) {
        this.structureId = structureId;
    }

    public SovereigntyCampaignsResponse solarSystemId(Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
        return this;
    }

    /**
     * The solar system the structure is located in.
     * 
     * @return solarSystemId
     **/
    @ApiModelProperty(example = "null", required = true, value = "The solar system the structure is located in. ")
    public Integer getSolarSystemId() {
        return solarSystemId;
    }

    public void setSolarSystemId(Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
    }

    public SovereigntyCampaignsResponse constellationId(Integer constellationId) {
        this.constellationId = constellationId;
        return this;
    }

    /**
     * The constellation in which the campaign will take place.
     * 
     * @return constellationId
     **/
    @ApiModelProperty(example = "null", required = true, value = "The constellation in which the campaign will take place. ")
    public Integer getConstellationId() {
        return constellationId;
    }

    public void setConstellationId(Integer constellationId) {
        this.constellationId = constellationId;
    }

    public SovereigntyCampaignsResponse eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    /**
     * Type of event this campaign is for. tcu_defense, ihub_defense and
     * station_defense are referred to as \"Defense Events\", station_freeport
     * as \"Freeport Events\".
     * 
     * @return eventType
     **/
    @ApiModelProperty(example = "null", required = true, value = "Type of event this campaign is for. tcu_defense, ihub_defense and station_defense are referred to as \"Defense Events\", station_freeport as \"Freeport Events\". ")
    public EventTypeEnum getEventType() {
        return eventType;
    }

    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public SovereigntyCampaignsResponse startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Time the event is scheduled to start.
     * 
     * @return startTime
     **/
    @ApiModelProperty(example = "null", required = true, value = "Time the event is scheduled to start. ")
    public OffsetDateTime getStartTime() {
        return startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public SovereigntyCampaignsResponse defenderId(Integer defenderId) {
        this.defenderId = defenderId;
        return this;
    }

    /**
     * Defending alliance, only present in Defense Events
     * 
     * @return defenderId
     **/
    @ApiModelProperty(example = "null", value = "Defending alliance, only present in Defense Events ")
    public Integer getDefenderId() {
        return defenderId;
    }

    public void setDefenderId(Integer defenderId) {
        this.defenderId = defenderId;
    }

    public SovereigntyCampaignsResponse defenderScore(Float defenderScore) {
        this.defenderScore = defenderScore;
        return this;
    }

    /**
     * Score for the defending alliance, only present in Defense Events.
     * 
     * @return defenderScore
     **/
    @ApiModelProperty(example = "null", value = "Score for the defending alliance, only present in Defense Events. ")
    public Float getDefenderScore() {
        return defenderScore;
    }

    public void setDefenderScore(Float defenderScore) {
        this.defenderScore = defenderScore;
    }

    public SovereigntyCampaignsResponse attackersScore(Float attackersScore) {
        this.attackersScore = attackersScore;
        return this;
    }

    /**
     * Score for all attacking parties, only present in Defense Events.
     * 
     * @return attackersScore
     **/
    @ApiModelProperty(example = "null", value = "Score for all attacking parties, only present in Defense Events. ")
    public Float getAttackersScore() {
        return attackersScore;
    }

    public void setAttackersScore(Float attackersScore) {
        this.attackersScore = attackersScore;
    }

    public SovereigntyCampaignsResponse participants(List<SovereigntyCampaignParticipant> participants) {
        this.participants = participants;
        return this;
    }

    public SovereigntyCampaignsResponse addParticipantsItem(SovereigntyCampaignParticipant participantsItem) {
        this.participants.add(participantsItem);
        return this;
    }

    /**
     * Alliance participating and their respective scores, only present in
     * Freeport Events.
     * 
     * @return participants
     **/
    @ApiModelProperty(example = "null", value = "Alliance participating and their respective scores, only present in Freeport Events. ")
    public List<SovereigntyCampaignParticipant> getParticipants() {
        return participants;
    }

    public void setParticipants(List<SovereigntyCampaignParticipant> participants) {
        this.participants = participants;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SovereigntyCampaignsResponse sovereigntyCampaignsResponse = (SovereigntyCampaignsResponse) o;
        return Objects.equals(this.campaignId, sovereigntyCampaignsResponse.campaignId)
                && Objects.equals(this.structureId, sovereigntyCampaignsResponse.structureId)
                && Objects.equals(this.solarSystemId, sovereigntyCampaignsResponse.solarSystemId)
                && Objects.equals(this.constellationId, sovereigntyCampaignsResponse.constellationId)
                && Objects.equals(this.eventType, sovereigntyCampaignsResponse.eventType)
                && Objects.equals(this.startTime, sovereigntyCampaignsResponse.startTime)
                && Objects.equals(this.defenderId, sovereigntyCampaignsResponse.defenderId)
                && Objects.equals(this.defenderScore, sovereigntyCampaignsResponse.defenderScore)
                && Objects.equals(this.attackersScore, sovereigntyCampaignsResponse.attackersScore)
                && Objects.equals(this.participants, sovereigntyCampaignsResponse.participants);
    }

    @Override
    public int hashCode() {
        return Objects.hash(campaignId, structureId, solarSystemId, constellationId, eventType, startTime, defenderId,
                defenderScore, attackersScore, participants);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SovereigntyCampaignsResponse {\n");

        sb.append("    campaignId: ").append(toIndentedString(campaignId)).append("\n");
        sb.append("    structureId: ").append(toIndentedString(structureId)).append("\n");
        sb.append("    solarSystemId: ").append(toIndentedString(solarSystemId)).append("\n");
        sb.append("    constellationId: ").append(toIndentedString(constellationId)).append("\n");
        sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
        sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
        sb.append("    defenderId: ").append(toIndentedString(defenderId)).append("\n");
        sb.append("    defenderScore: ").append(toIndentedString(defenderScore)).append("\n");
        sb.append("    attackersScore: ").append(toIndentedString(attackersScore)).append("\n");
        sb.append("    participants: ").append(toIndentedString(participants)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
