/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.JSON;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.RFC3339DateFormat;
import net.troja.eve.esi.StringUtil;
import net.troja.eve.esi.auth.ApiKeyAuth;
import net.troja.eve.esi.auth.Authentication;
import net.troja.eve.esi.auth.HttpBasicAuth;
import net.troja.eve.esi.auth.OAuth;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class ApiClient {
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private String basePath = "https://esi.tech.ccp.is";
    private boolean debugging = false;
    private int connectionTimeout = 0;
    private Client httpClient;
    private JSON json = new JSON();
    private String tempFolderPath = null;
    private Map<String, Authentication> authentications;
    private int statusCode;
    private Map<String, List<String>> responseHeaders;
    private DateFormat dateFormat;

    public ApiClient() {
        this.httpClient = this.buildHttpClient(this.debugging);
        this.dateFormat = new RFC3339DateFormat();
        this.setUserAgent("Swagger-Codegen/1.0.0/java");
        this.authentications = new HashMap<String, Authentication>();
        this.authentications.put("evesso", new OAuth());
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    public JSON getJSON() {
        return this.json;
    }

    public Client getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(Client client) {
        this.httpClient = client;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String string) {
        this.basePath = string;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String string) {
        return this.authentications.get(string);
    }

    public void setUsername(String string) {
        for (Authentication authentication : this.authentications.values()) {
            if (!(authentication instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)authentication).setUsername(string);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setPassword(String string) {
        for (Authentication authentication : this.authentications.values()) {
            if (!(authentication instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)authentication).setPassword(string);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setApiKey(String string) {
        for (Authentication authentication : this.authentications.values()) {
            if (!(authentication instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)authentication).setApiKey(string);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setApiKeyPrefix(String string) {
        for (Authentication authentication : this.authentications.values()) {
            if (!(authentication instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)authentication).setApiKeyPrefix(string);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setAccessToken(String string) {
        for (Authentication authentication : this.authentications.values()) {
            if (!(authentication instanceof OAuth)) continue;
            ((OAuth)authentication).setAccessToken(string);
            return;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setUserAgent(String string) {
        this.addDefaultHeader("User-Agent", string);
        return this;
    }

    public ApiClient addDefaultHeader(String string, String string2) {
        this.defaultHeaderMap.put(string, string2);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean bl) {
        this.debugging = bl;
        this.httpClient = this.buildHttpClient(bl);
        return this;
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public ApiClient setTempFolderPath(String string) {
        this.tempFolderPath = string;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectionTimeout;
    }

    public ApiClient setConnectTimeout(int n) {
        this.connectionTimeout = n;
        this.httpClient.property("jersey.config.client.connectTimeout", (Object)n);
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.json.setDateFormat((DateFormat)dateFormat.clone());
        return this;
    }

    public Date parseDate(String string) {
        try {
            return this.dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Date) {
            return this.formatDate((Date)object);
        }
        if (object instanceof Collection) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object e : (Collection)object) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(String.valueOf(e));
            }
            return stringBuilder.toString();
        }
        return String.valueOf(object);
    }

    public List<Pair> parameterToPairs(String string, String string2, Object object) {
        String string3;
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        if (string2 == null || string2.isEmpty() || object == null) {
            return arrayList;
        }
        if (!(object instanceof Collection)) {
            arrayList.add(new Pair(string2, this.parameterToString(object)));
            return arrayList;
        }
        Collection collection = (Collection)object;
        if (collection.isEmpty()) {
            return arrayList;
        }
        String string4 = string3 = string == null || string.isEmpty() ? "csv" : string;
        if ("multi".equals(string3)) {
            for (Object e : collection) {
                arrayList.add(new Pair(string2, this.parameterToString(e)));
            }
            return arrayList;
        }
        String string5 = ",";
        if ("csv".equals(string3)) {
            string5 = ",";
        } else if ("ssv".equals(string3)) {
            string5 = " ";
        } else if ("tsv".equals(string3)) {
            string5 = "\t";
        } else if ("pipes".equals(string3)) {
            string5 = "|";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object e : collection) {
            stringBuilder.append(string5);
            stringBuilder.append(this.parameterToString(e));
        }
        arrayList.add(new Pair(string2, stringBuilder.substring(1)));
        return arrayList;
    }

    public boolean isJsonMime(String string) {
        return string != null && string.matches("(?i)application\\/json(;.*)?");
    }

    public String selectHeaderAccept(String[] stringArray) {
        if (stringArray.length == 0) {
            return null;
        }
        for (String string : stringArray) {
            if (!this.isJsonMime(string)) continue;
            return string;
        }
        return StringUtil.join(stringArray, ",");
    }

    public String selectHeaderContentType(String[] stringArray) {
        if (stringArray.length == 0) {
            return "application/json";
        }
        for (String string : stringArray) {
            if (!this.isJsonMime(string)) continue;
            return string;
        }
        return stringArray[0];
    }

    public String escapeString(String string) {
        try {
            return URLEncoder.encode(string, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public Entity<?> serialize(Object object, Map<String, Object> map, String string) throws ApiException {
        Entity entity;
        if (string.startsWith("multipart/form-data")) {
            MultiPart multiPart = new MultiPart();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                File file;
                if (entry.getValue() instanceof File) {
                    file = (File)entry.getValue();
                    FormDataContentDisposition formDataContentDisposition = ((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)entry.getKey()).fileName(file.getName())).size(file.length())).build();
                    multiPart.bodyPart((BodyPart)new FormDataBodyPart(formDataContentDisposition, (Object)file, MediaType.APPLICATION_OCTET_STREAM_TYPE));
                    continue;
                }
                file = FormDataContentDisposition.name((String)entry.getKey()).build();
                multiPart.bodyPart((BodyPart)new FormDataBodyPart((FormDataContentDisposition)file, this.parameterToString(entry.getValue())));
            }
            entity = Entity.entity((Object)multiPart, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE);
        } else if (string.startsWith("application/x-www-form-urlencoded")) {
            Form form = new Form();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                form.param(entry.getKey(), this.parameterToString(entry.getValue()));
            }
            entity = Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        } else {
            entity = Entity.entity((Object)object, (String)string);
        }
        return entity;
    }

    public <T> T deserialize(Response response, GenericType<T> genericType) throws ApiException {
        if (response == null || genericType == null) {
            return null;
        }
        if ("byte[]".equals(genericType.toString())) {
            return (T)response.readEntity(byte[].class);
        }
        if (genericType.getRawType() == File.class) {
            File file = this.downloadFileFromResponse(response);
            return (T)file;
        }
        String string = null;
        List list = (List)response.getHeaders().get((Object)"Content-Type");
        if (list != null && !list.isEmpty()) {
            string = String.valueOf(list.get(0));
        }
        if (string == null) {
            throw new ApiException(500, "missing Content-Type in response");
        }
        return (T)response.readEntity(genericType);
    }

    public File downloadFileFromResponse(Response response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            Files.copy((InputStream)response.readEntity(InputStream.class), file.toPath(), new CopyOption[0]);
            return file;
        }
        catch (IOException iOException) {
            throw new ApiException(iOException);
        }
    }

    public File prepareDownloadFile(Response response) throws IOException {
        Object object;
        Object object2;
        String string = null;
        String string2 = (String)response.getHeaders().getFirst((Object)"Content-Disposition");
        if (string2 != null && !"".equals(string2) && ((Matcher)(object2 = ((Pattern)(object = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?"))).matcher(string2))).find()) {
            string = ((Matcher)object2).group(1);
        }
        object2 = null;
        if (string == null) {
            object = "download-";
            object2 = "";
        } else {
            int n = string.lastIndexOf(46);
            if (n == -1) {
                object = string + "-";
            } else {
                object = string.substring(0, n) + "-";
                object2 = string.substring(n);
            }
            if (((String)object).length() < 3) {
                object = "download-";
            }
        }
        if (this.tempFolderPath == null) {
            return File.createTempFile((String)object, (String)object2);
        }
        return File.createTempFile((String)object, (String)object2, new File(this.tempFolderPath));
    }

    /*
     * WARNING - void declaration
     */
    public <T> T invokeAPI(String string, String string2, List<Pair> list, Object object, Map<String, String> map, Map<String, Object> map2, String string3, String string4, String[] stringArray, GenericType<T> genericType) throws ApiException {
        void var14_25;
        String string5;
        String string6;
        this.updateParamsForAuth(stringArray, list, map);
        WebTarget webTarget = this.httpClient.target(this.basePath + string);
        if (list != null) {
            for (Pair object22 : list) {
                if (object22.getValue() == null) continue;
                webTarget = webTarget.queryParam(object22.getName(), new Object[]{object22.getValue()});
            }
        }
        Invocation.Builder builder = webTarget.request().accept(new String[]{string3});
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string6 = entry.getValue();
            if (string6 == null) continue;
            builder = builder.header(entry.getKey(), (Object)string6);
        }
        for (Map.Entry<String, String> entry : this.defaultHeaderMap.entrySet()) {
            string6 = entry.getKey();
            if (map.containsKey(string6) || (string5 = entry.getValue()) == null) continue;
            builder = builder.header(string6, (Object)string5);
        }
        Entity<?> entity = this.serialize(object, map2, string4);
        if ("GET".equals(string2)) {
            Response response = builder.get();
        } else if ("POST".equals(string2)) {
            Response response = builder.post(entity);
        } else if ("PUT".equals(string2)) {
            Response response = builder.put(entity);
        } else if ("DELETE".equals(string2)) {
            Response response = builder.delete();
        } else if ("PATCH".equals(string2)) {
            Response response = builder.header("X-HTTP-Method-Override", (Object)"PATCH").post(entity);
        } else {
            throw new ApiException(500, "unknown method type " + string2);
        }
        this.statusCode = var14_25.getStatusInfo().getStatusCode();
        this.responseHeaders = this.buildResponseHeaders((Response)var14_25);
        if (var14_25.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
            return null;
        }
        if (var14_25.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            if (genericType == null) {
                return null;
            }
            return this.deserialize((Response)var14_25, genericType);
        }
        string6 = "error";
        string5 = null;
        if (var14_25.hasEntity()) {
            try {
                string6 = string5 = String.valueOf(var14_25.readEntity(String.class));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        throw new ApiException(var14_25.getStatus(), string6, this.buildResponseHeaders((Response)var14_25), string5);
    }

    private Client buildHttpClient(boolean bl) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register(MultiPartFeature.class);
        clientConfig.register((Object)this.json);
        clientConfig.register(JacksonFeature.class);
        if (bl) {
            clientConfig.register(LoggingFilter.class);
        }
        return ClientBuilder.newClient((Configuration)clientConfig);
    }

    private Map<String, List<String>> buildResponseHeaders(Response response) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            List list = (List)entry.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object e : list) {
                arrayList.add(String.valueOf(e));
            }
            hashMap.put((String)entry.getKey(), (List<String>)arrayList);
        }
        return hashMap;
    }

    private void updateParamsForAuth(String[] stringArray, List<Pair> list, Map<String, String> map) {
        for (String string : stringArray) {
            Authentication authentication = this.authentications.get(string);
            if (authentication == null) {
                throw new RuntimeException("Authentication undefined: " + string);
            }
            authentication.applyToParams(list, map);
        }
    }
}

