/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.KillmailAttacker;
import net.troja.eve.esi.model.KillmailVictim;

@ApiModel(description="200 ok object")
public class KillmailResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="killmail_id")
    private Integer killmailId = null;
    @JsonProperty(value="killmail_time")
    private OffsetDateTime killmailTime = null;
    @JsonProperty(value="victim")
    private KillmailVictim victim = null;
    @JsonProperty(value="attackers")
    private List<KillmailAttacker> attackers = new ArrayList<KillmailAttacker>();
    @JsonProperty(value="solar_system_id")
    private Integer solarSystemId = null;
    @JsonProperty(value="moon_id")
    private Integer moonId = null;
    @JsonProperty(value="war_id")
    private Integer warId = null;

    public KillmailResponse killmailId(Integer n) {
        this.killmailId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the killmail")
    public Integer getKillmailId() {
        return this.killmailId;
    }

    public void setKillmailId(Integer n) {
        this.killmailId = n;
    }

    public KillmailResponse killmailTime(OffsetDateTime offsetDateTime) {
        this.killmailTime = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Time that the victim was killed and the killmail generated ")
    public OffsetDateTime getKillmailTime() {
        return this.killmailTime;
    }

    public void setKillmailTime(OffsetDateTime offsetDateTime) {
        this.killmailTime = offsetDateTime;
    }

    public KillmailResponse victim(KillmailVictim killmailVictim) {
        this.victim = killmailVictim;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public KillmailVictim getVictim() {
        return this.victim;
    }

    public void setVictim(KillmailVictim killmailVictim) {
        this.victim = killmailVictim;
    }

    public KillmailResponse attackers(List<KillmailAttacker> list) {
        this.attackers = list;
        return this;
    }

    public KillmailResponse addAttackersItem(KillmailAttacker killmailAttacker) {
        this.attackers.add(killmailAttacker);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="attackers array")
    public List<KillmailAttacker> getAttackers() {
        return this.attackers;
    }

    public void setAttackers(List<KillmailAttacker> list) {
        this.attackers = list;
    }

    public KillmailResponse solarSystemId(Integer n) {
        this.solarSystemId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Solar system that the kill took place in ")
    public Integer getSolarSystemId() {
        return this.solarSystemId;
    }

    public void setSolarSystemId(Integer n) {
        this.solarSystemId = n;
    }

    public KillmailResponse moonId(Integer n) {
        this.moonId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="Moon if the kill took place at one")
    public Integer getMoonId() {
        return this.moonId;
    }

    public void setMoonId(Integer n) {
        this.moonId = n;
    }

    public KillmailResponse warId(Integer n) {
        this.warId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="War if the killmail is generated in relation to an official war ")
    public Integer getWarId() {
        return this.warId;
    }

    public void setWarId(Integer n) {
        this.warId = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        KillmailResponse killmailResponse = (KillmailResponse)object;
        return Objects.equals(this.killmailId, killmailResponse.killmailId) && Objects.equals(this.killmailTime, killmailResponse.killmailTime) && Objects.equals(this.victim, killmailResponse.victim) && Objects.equals(this.attackers, killmailResponse.attackers) && Objects.equals(this.solarSystemId, killmailResponse.solarSystemId) && Objects.equals(this.moonId, killmailResponse.moonId) && Objects.equals(this.warId, killmailResponse.warId);
    }

    public int hashCode() {
        return Objects.hash(this.killmailId, this.killmailTime, this.victim, this.attackers, this.solarSystemId, this.moonId, this.warId);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class KillmailResponse {\n");
        stringBuilder.append("    killmailId: ").append(this.toIndentedString(this.killmailId)).append("\n");
        stringBuilder.append("    killmailTime: ").append(this.toIndentedString(this.killmailTime)).append("\n");
        stringBuilder.append("    victim: ").append(this.toIndentedString(this.victim)).append("\n");
        stringBuilder.append("    attackers: ").append(this.toIndentedString(this.attackers)).append("\n");
        stringBuilder.append("    solarSystemId: ").append(this.toIndentedString(this.solarSystemId)).append("\n");
        stringBuilder.append("    moonId: ").append(this.toIndentedString(this.moonId)).append("\n");
        stringBuilder.append("    warId: ").append(this.toIndentedString(this.warId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

