/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class CorporationMedalsIssuedResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("medal_id")
    private Integer medalId = null;

    @JsonProperty("character_id")
    private Integer characterId = null;

    @JsonProperty("reason")
    private String reason = null;

    /**
     * status string
     */
    public enum StatusEnum {
        PRIVATE("private"),

        PUBLIC("public");

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("status")
    private StatusEnum status = null;

    @JsonProperty("issuer_id")
    private Integer issuerId = null;

    @JsonProperty("issued_at")
    private OffsetDateTime issuedAt = null;

    public CorporationMedalsIssuedResponse medalId(Integer medalId) {
        this.medalId = medalId;
        return this;
    }

    /**
     * medal_id integer
     * 
     * @return medalId
     **/
    @ApiModelProperty(example = "null", required = true, value = "medal_id integer")
    public Integer getMedalId() {
        return medalId;
    }

    public void setMedalId(Integer medalId) {
        this.medalId = medalId;
    }

    public CorporationMedalsIssuedResponse characterId(Integer characterId) {
        this.characterId = characterId;
        return this;
    }

    /**
     * ID of the character who was rewarded this medal
     * 
     * @return characterId
     **/
    @ApiModelProperty(example = "null", required = true, value = "ID of the character who was rewarded this medal")
    public Integer getCharacterId() {
        return characterId;
    }

    public void setCharacterId(Integer characterId) {
        this.characterId = characterId;
    }

    public CorporationMedalsIssuedResponse reason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * reason string
     * 
     * @return reason
     **/
    @ApiModelProperty(example = "null", required = true, value = "reason string")
    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public CorporationMedalsIssuedResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    /**
     * status string
     * 
     * @return status
     **/
    @ApiModelProperty(example = "null", required = true, value = "status string")
    public StatusEnum getStatus() {
        return status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public CorporationMedalsIssuedResponse issuerId(Integer issuerId) {
        this.issuerId = issuerId;
        return this;
    }

    /**
     * ID of the character who issued the medal
     * 
     * @return issuerId
     **/
    @ApiModelProperty(example = "null", required = true, value = "ID of the character who issued the medal")
    public Integer getIssuerId() {
        return issuerId;
    }

    public void setIssuerId(Integer issuerId) {
        this.issuerId = issuerId;
    }

    public CorporationMedalsIssuedResponse issuedAt(OffsetDateTime issuedAt) {
        this.issuedAt = issuedAt;
        return this;
    }

    /**
     * issued_at string
     * 
     * @return issuedAt
     **/
    @ApiModelProperty(example = "null", required = true, value = "issued_at string")
    public OffsetDateTime getIssuedAt() {
        return issuedAt;
    }

    public void setIssuedAt(OffsetDateTime issuedAt) {
        this.issuedAt = issuedAt;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CorporationMedalsIssuedResponse corporationMedalsIssuedResponse = (CorporationMedalsIssuedResponse) o;
        return Objects.equals(this.medalId, corporationMedalsIssuedResponse.medalId)
                && Objects.equals(this.characterId, corporationMedalsIssuedResponse.characterId)
                && Objects.equals(this.reason, corporationMedalsIssuedResponse.reason)
                && Objects.equals(this.status, corporationMedalsIssuedResponse.status)
                && Objects.equals(this.issuerId, corporationMedalsIssuedResponse.issuerId)
                && Objects.equals(this.issuedAt, corporationMedalsIssuedResponse.issuedAt);
    }

    @Override
    public int hashCode() {
        return Objects.hash(medalId, characterId, reason, status, issuerId, issuedAt);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporationMedalsIssuedResponse {\n");

        sb.append("    medalId: ").append(toIndentedString(medalId)).append("\n");
        sb.append("    characterId: ").append(toIndentedString(characterId)).append("\n");
        sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    issuerId: ").append(toIndentedString(issuerId)).append("\n");
        sb.append("    issuedAt: ").append(toIndentedString(issuedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
