/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.FactionWarfareLeaderboardActiveTotalKills;
import net.troja.eve.esi.model.FactionWarfareLeaderboardLastWeekKills;
import net.troja.eve.esi.model.FactionWarfareLeaderboardYesterdayKills;

@ApiModel(description="Top 4 rankings of factions by number of kills from yesterday, last week and in total.")
public class FactionWarfareLeaderboardKills
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="active_total")
    private List<FactionWarfareLeaderboardActiveTotalKills> activeTotal = new ArrayList<FactionWarfareLeaderboardActiveTotalKills>();
    @JsonProperty(value="last_week")
    private List<FactionWarfareLeaderboardLastWeekKills> lastWeek = new ArrayList<FactionWarfareLeaderboardLastWeekKills>();
    @JsonProperty(value="yesterday")
    private List<FactionWarfareLeaderboardYesterdayKills> yesterday = new ArrayList<FactionWarfareLeaderboardYesterdayKills>();

    public FactionWarfareLeaderboardKills activeTotal(List<FactionWarfareLeaderboardActiveTotalKills> list) {
        this.activeTotal = list;
        return this;
    }

    public FactionWarfareLeaderboardKills addActiveTotalItem(FactionWarfareLeaderboardActiveTotalKills factionWarfareLeaderboardActiveTotalKills) {
        this.activeTotal.add(factionWarfareLeaderboardActiveTotalKills);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Top 4 ranking of factions active in faction warfare by total kills. A faction is considered \"active\" if they have participated in faction warfare in the past 14 days.")
    public List<FactionWarfareLeaderboardActiveTotalKills> getActiveTotal() {
        return this.activeTotal;
    }

    public void setActiveTotal(List<FactionWarfareLeaderboardActiveTotalKills> list) {
        this.activeTotal = list;
    }

    public FactionWarfareLeaderboardKills lastWeek(List<FactionWarfareLeaderboardLastWeekKills> list) {
        this.lastWeek = list;
        return this;
    }

    public FactionWarfareLeaderboardKills addLastWeekItem(FactionWarfareLeaderboardLastWeekKills factionWarfareLeaderboardLastWeekKills) {
        this.lastWeek.add(factionWarfareLeaderboardLastWeekKills);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Top 4 ranking of factions by kills in the past week")
    public List<FactionWarfareLeaderboardLastWeekKills> getLastWeek() {
        return this.lastWeek;
    }

    public void setLastWeek(List<FactionWarfareLeaderboardLastWeekKills> list) {
        this.lastWeek = list;
    }

    public FactionWarfareLeaderboardKills yesterday(List<FactionWarfareLeaderboardYesterdayKills> list) {
        this.yesterday = list;
        return this;
    }

    public FactionWarfareLeaderboardKills addYesterdayItem(FactionWarfareLeaderboardYesterdayKills factionWarfareLeaderboardYesterdayKills) {
        this.yesterday.add(factionWarfareLeaderboardYesterdayKills);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Top 4 ranking of factions by kills in the past day")
    public List<FactionWarfareLeaderboardYesterdayKills> getYesterday() {
        return this.yesterday;
    }

    public void setYesterday(List<FactionWarfareLeaderboardYesterdayKills> list) {
        this.yesterday = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FactionWarfareLeaderboardKills factionWarfareLeaderboardKills = (FactionWarfareLeaderboardKills)object;
        return Objects.equals(this.activeTotal, factionWarfareLeaderboardKills.activeTotal) && Objects.equals(this.lastWeek, factionWarfareLeaderboardKills.lastWeek) && Objects.equals(this.yesterday, factionWarfareLeaderboardKills.yesterday);
    }

    public int hashCode() {
        return Objects.hash(this.activeTotal, this.lastWeek, this.yesterday);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class FactionWarfareLeaderboardKills {\n");
        stringBuilder.append("    activeTotal: ").append(this.toIndentedString(this.activeTotal)).append("\n");
        stringBuilder.append("    lastWeek: ").append(this.toIndentedString(this.lastWeek)).append("\n");
        stringBuilder.append("    yesterday: ").append(this.toIndentedString(this.yesterday)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

