/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class HeaderUtil {
    private static final ISO8601DateFormat DATE_FORMAT = new ISO8601DateFormat();
    private static final String X_PAGES = "X-Pages";
    private static final String EXPIRES = "Expires";

    private HeaderUtil() {
    }

    public static Integer getXPages(Map<String, List<String>> map) {
        Integer n;
        String string = HeaderUtil.getHeader(map, X_PAGES);
        if (string == null) {
            return null;
        }
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = null;
        }
        return n;
    }

    public static Date getExpires(Map<String, List<String>> map) {
        String string = HeaderUtil.getHeader(map, EXPIRES);
        if (string == null) {
            return null;
        }
        Date date = null;
        try {
            date = DATE_FORMAT.parse(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static String getHeader(Map<String, List<String>> map, String string) {
        if (map == null) {
            return null;
        }
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(string)) continue;
            List<String> list = entry.getValue();
            if (list == null || list.isEmpty()) break;
            return list.get(0);
        }
        return null;
    }
}

