/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="muted object")
public class ChatChannelsMuted
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="accessor_id")
    private Integer accessorId = null;
    @JsonProperty(value="accessor_type")
    private AccessorTypeEnum accessorType = null;
    @JsonProperty(value="end_at")
    private OffsetDateTime endAt = null;
    @JsonProperty(value="reason")
    private String reason = null;

    public ChatChannelsMuted accessorId(Integer n) {
        this.accessorId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of a muted channel member")
    public Integer getAccessorId() {
        return this.accessorId;
    }

    public void setAccessorId(Integer n) {
        this.accessorId = n;
    }

    public ChatChannelsMuted accessorType(AccessorTypeEnum accessorTypeEnum) {
        this.accessorType = accessorTypeEnum;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="accessor_type string")
    public AccessorTypeEnum getAccessorType() {
        return this.accessorType;
    }

    public void setAccessorType(AccessorTypeEnum accessorTypeEnum) {
        this.accessorType = accessorTypeEnum;
    }

    public ChatChannelsMuted endAt(OffsetDateTime offsetDateTime) {
        this.endAt = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Time at which this accessor will no longer be muted")
    public OffsetDateTime getEndAt() {
        return this.endAt;
    }

    public void setEndAt(OffsetDateTime offsetDateTime) {
        this.endAt = offsetDateTime;
    }

    public ChatChannelsMuted reason(String string) {
        this.reason = string;
        return this;
    }

    @ApiModelProperty(example="null", value="Reason this accessor is muted")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ChatChannelsMuted chatChannelsMuted = (ChatChannelsMuted)object;
        return Objects.equals(this.accessorId, chatChannelsMuted.accessorId) && Objects.equals((Object)this.accessorType, (Object)chatChannelsMuted.accessorType) && Objects.equals(this.endAt, chatChannelsMuted.endAt) && Objects.equals(this.reason, chatChannelsMuted.reason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessorId, this.accessorType, this.endAt, this.reason});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class ChatChannelsMuted {\n");
        stringBuilder.append("    accessorId: ").append(this.toIndentedString(this.accessorId)).append("\n");
        stringBuilder.append("    accessorType: ").append(this.toIndentedString((Object)this.accessorType)).append("\n");
        stringBuilder.append("    endAt: ").append(this.toIndentedString(this.endAt)).append("\n");
        stringBuilder.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    public static enum AccessorTypeEnum {
        CHARACTER("character"),
        CORPORATION("corporation"),
        ALLIANCE("alliance");

        private String value;

        private AccessorTypeEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccessorTypeEnum fromValue(String string) {
            for (AccessorTypeEnum accessorTypeEnum : AccessorTypeEnum.values()) {
                if (!String.valueOf(accessorTypeEnum.value).equals(string)) continue;
                return accessorTypeEnum;
            }
            return null;
        }
    }
}

