/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

/**
 * invitation object
 */
@ApiModel(description = "invitation object")
public class FleetInvitation implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("character_id")
    private Integer characterId = null;

    /**
     * If a character is invited with the `fleet_commander` role, neither
     * `wing_id` or `squad_id` should be specified. If a character is invited
     * with the `wing_commander` role, only `wing_id` should be specified. If a
     * character is invited with the `squad_commander` role, both `wing_id` and
     * `squad_id` should be specified. If a character is invited with the
     * `squad_member` role, `wing_id` and `squad_id` should either both be
     * specified or not specified at all. If they aren’t specified, the invited
     * character will join any squad with available positions.
     */
    public enum RoleEnum {
        FLEET_COMMANDER("fleet_commander"),

        WING_COMMANDER("wing_commander"),

        SQUAD_COMMANDER("squad_commander"),

        SQUAD_MEMBER("squad_member");

        private String value;

        RoleEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static RoleEnum fromValue(String text) {
            for (RoleEnum b : RoleEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("role")
    private RoleEnum role = null;

    @JsonProperty("squad_id")
    private Long squadId = null;

    @JsonProperty("wing_id")
    private Long wingId = null;

    public FleetInvitation characterId(Integer characterId) {
        this.characterId = characterId;
        return this;
    }

    /**
     * The character you want to invite
     * 
     * @return characterId
     **/
    @ApiModelProperty(example = "null", required = true, value = "The character you want to invite")
    public Integer getCharacterId() {
        return characterId;
    }

    public void setCharacterId(Integer characterId) {
        this.characterId = characterId;
    }

    public FleetInvitation role(RoleEnum role) {
        this.role = role;
        return this;
    }

    /**
     * If a character is invited with the `fleet_commander` role, neither
     * `wing_id` or `squad_id` should be specified. If a character is invited
     * with the `wing_commander` role, only `wing_id` should be specified. If a
     * character is invited with the `squad_commander` role, both `wing_id` and
     * `squad_id` should be specified. If a character is invited with the
     * `squad_member` role, `wing_id` and `squad_id` should either both be
     * specified or not specified at all. If they aren’t specified, the invited
     * character will join any squad with available positions.
     * 
     * @return role
     **/
    @ApiModelProperty(example = "null", required = true, value = "If a character is invited with the `fleet_commander` role, neither `wing_id` or `squad_id` should be specified. If a character is invited with the `wing_commander` role, only `wing_id` should be specified. If a character is invited with the `squad_commander` role, both `wing_id` and `squad_id` should be specified. If a character is invited with the `squad_member` role, `wing_id` and `squad_id` should either both be specified or not specified at all. If they aren’t specified, the invited character will join any squad with available positions.")
    public RoleEnum getRole() {
        return role;
    }

    public void setRole(RoleEnum role) {
        this.role = role;
    }

    public FleetInvitation squadId(Long squadId) {
        this.squadId = squadId;
        return this;
    }

    /**
     * squad_id integer minimum: 0
     * 
     * @return squadId
     **/
    @ApiModelProperty(example = "null", value = "squad_id integer")
    public Long getSquadId() {
        return squadId;
    }

    public void setSquadId(Long squadId) {
        this.squadId = squadId;
    }

    public FleetInvitation wingId(Long wingId) {
        this.wingId = wingId;
        return this;
    }

    /**
     * wing_id integer minimum: 0
     * 
     * @return wingId
     **/
    @ApiModelProperty(example = "null", value = "wing_id integer")
    public Long getWingId() {
        return wingId;
    }

    public void setWingId(Long wingId) {
        this.wingId = wingId;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FleetInvitation fleetInvitation = (FleetInvitation) o;
        return Objects.equals(this.characterId, fleetInvitation.characterId)
                && Objects.equals(this.role, fleetInvitation.role)
                && Objects.equals(this.squadId, fleetInvitation.squadId)
                && Objects.equals(this.wingId, fleetInvitation.wingId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(characterId, role, squadId, wingId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FleetInvitation {\n");

        sb.append("    characterId: ").append(toIndentedString(characterId)).append("\n");
        sb.append("    role: ").append(toIndentedString(role)).append("\n");
        sb.append("    squadId: ").append(toIndentedString(squadId)).append("\n");
        sb.append("    wingId: ").append(toIndentedString(wingId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
