/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class CharacterResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("alliance_id")
    private Integer allianceId = null;

    @JsonProperty("ancestry_id")
    private Integer ancestryId = null;

    @JsonProperty("birthday")
    private OffsetDateTime birthday = null;

    @JsonProperty("bloodline_id")
    private Integer bloodlineId = null;

    @JsonProperty("corporation_id")
    private Integer corporationId = null;

    @JsonProperty("description")
    private String description = null;

    /**
     * gender string
     */
    public enum GenderEnum {
        FEMALE("female"),

        MALE("male");

        private String value;

        GenderEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static GenderEnum fromValue(String text) {
            for (GenderEnum b : GenderEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("gender")
    private GenderEnum gender = null;

    @JsonProperty("name")
    private String name = null;

    @JsonProperty("race_id")
    private Integer raceId = null;

    @JsonProperty("security_status")
    private Float securityStatus = null;

    public CharacterResponse allianceId(Integer allianceId) {
        this.allianceId = allianceId;
        return this;
    }

    /**
     * The character's alliance ID
     * 
     * @return allianceId
     **/
    @ApiModelProperty(example = "null", value = "The character's alliance ID")
    public Integer getAllianceId() {
        return allianceId;
    }

    public void setAllianceId(Integer allianceId) {
        this.allianceId = allianceId;
    }

    public CharacterResponse ancestryId(Integer ancestryId) {
        this.ancestryId = ancestryId;
        return this;
    }

    /**
     * ancestry_id integer
     * 
     * @return ancestryId
     **/
    @ApiModelProperty(example = "null", value = "ancestry_id integer")
    public Integer getAncestryId() {
        return ancestryId;
    }

    public void setAncestryId(Integer ancestryId) {
        this.ancestryId = ancestryId;
    }

    public CharacterResponse birthday(OffsetDateTime birthday) {
        this.birthday = birthday;
        return this;
    }

    /**
     * Creation date of the character
     * 
     * @return birthday
     **/
    @ApiModelProperty(example = "null", required = true, value = "Creation date of the character")
    public OffsetDateTime getBirthday() {
        return birthday;
    }

    public void setBirthday(OffsetDateTime birthday) {
        this.birthday = birthday;
    }

    public CharacterResponse bloodlineId(Integer bloodlineId) {
        this.bloodlineId = bloodlineId;
        return this;
    }

    /**
     * bloodline_id integer
     * 
     * @return bloodlineId
     **/
    @ApiModelProperty(example = "null", required = true, value = "bloodline_id integer")
    public Integer getBloodlineId() {
        return bloodlineId;
    }

    public void setBloodlineId(Integer bloodlineId) {
        this.bloodlineId = bloodlineId;
    }

    public CharacterResponse corporationId(Integer corporationId) {
        this.corporationId = corporationId;
        return this;
    }

    /**
     * The character's corporation ID
     * 
     * @return corporationId
     **/
    @ApiModelProperty(example = "null", required = true, value = "The character's corporation ID")
    public Integer getCorporationId() {
        return corporationId;
    }

    public void setCorporationId(Integer corporationId) {
        this.corporationId = corporationId;
    }

    public CharacterResponse description(String description) {
        this.description = description;
        return this;
    }

    /**
     * description string
     * 
     * @return description
     **/
    @ApiModelProperty(example = "null", value = "description string")
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CharacterResponse gender(GenderEnum gender) {
        this.gender = gender;
        return this;
    }

    /**
     * gender string
     * 
     * @return gender
     **/
    @ApiModelProperty(example = "null", required = true, value = "gender string")
    public GenderEnum getGender() {
        return gender;
    }

    public void setGender(GenderEnum gender) {
        this.gender = gender;
    }

    public CharacterResponse name(String name) {
        this.name = name;
        return this;
    }

    /**
     * name string
     * 
     * @return name
     **/
    @ApiModelProperty(example = "null", required = true, value = "name string")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CharacterResponse raceId(Integer raceId) {
        this.raceId = raceId;
        return this;
    }

    /**
     * race_id integer
     * 
     * @return raceId
     **/
    @ApiModelProperty(example = "null", required = true, value = "race_id integer")
    public Integer getRaceId() {
        return raceId;
    }

    public void setRaceId(Integer raceId) {
        this.raceId = raceId;
    }

    public CharacterResponse securityStatus(Float securityStatus) {
        this.securityStatus = securityStatus;
        return this;
    }

    /**
     * security_status number minimum: -10 maximum: 10
     * 
     * @return securityStatus
     **/
    @ApiModelProperty(example = "null", value = "security_status number")
    public Float getSecurityStatus() {
        return securityStatus;
    }

    public void setSecurityStatus(Float securityStatus) {
        this.securityStatus = securityStatus;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CharacterResponse characterResponse = (CharacterResponse) o;
        return Objects.equals(this.allianceId, characterResponse.allianceId)
                && Objects.equals(this.ancestryId, characterResponse.ancestryId)
                && Objects.equals(this.birthday, characterResponse.birthday)
                && Objects.equals(this.bloodlineId, characterResponse.bloodlineId)
                && Objects.equals(this.corporationId, characterResponse.corporationId)
                && Objects.equals(this.description, characterResponse.description)
                && Objects.equals(this.gender, characterResponse.gender)
                && Objects.equals(this.name, characterResponse.name)
                && Objects.equals(this.raceId, characterResponse.raceId)
                && Objects.equals(this.securityStatus, characterResponse.securityStatus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(allianceId, ancestryId, birthday, bloodlineId, corporationId, description, gender, name,
                raceId, securityStatus);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacterResponse {\n");

        sb.append("    allianceId: ").append(toIndentedString(allianceId)).append("\n");
        sb.append("    ancestryId: ").append(toIndentedString(ancestryId)).append("\n");
        sb.append("    birthday: ").append(toIndentedString(birthday)).append("\n");
        sb.append("    bloodlineId: ").append(toIndentedString(bloodlineId)).append("\n");
        sb.append("    corporationId: ").append(toIndentedString(corporationId)).append("\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    gender: ").append(toIndentedString(gender)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    raceId: ").append(toIndentedString(raceId)).append("\n");
        sb.append("    securityStatus: ").append(toIndentedString(securityStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
