/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="movement object")
public class FleetMemberMovement
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="role")
    private RoleEnum role = null;
    @JsonProperty(value="squad_id")
    private Long squadId = null;
    @JsonProperty(value="wing_id")
    private Long wingId = null;

    public FleetMemberMovement role(RoleEnum roleEnum) {
        this.role = roleEnum;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="- If a character is moved to the `fleet_commander` role, neither `wing_id` or `squad_id` should be specified - If a character is moved to the `wing_commander` role, only `wing_id` should be specified - If a character is moved to the `squad_commander` role, both `wing_id` and `squad_id` should be specified - If a character is moved to the `squad_member` role, both `wing_id` and `squad_id` should be specified ")
    public RoleEnum getRole() {
        return this.role;
    }

    public void setRole(RoleEnum roleEnum) {
        this.role = roleEnum;
    }

    public FleetMemberMovement squadId(Long l) {
        this.squadId = l;
        return this;
    }

    @ApiModelProperty(example="null", value="squad_id integer")
    public Long getSquadId() {
        return this.squadId;
    }

    public void setSquadId(Long l) {
        this.squadId = l;
    }

    public FleetMemberMovement wingId(Long l) {
        this.wingId = l;
        return this;
    }

    @ApiModelProperty(example="null", value="wing_id integer")
    public Long getWingId() {
        return this.wingId;
    }

    public void setWingId(Long l) {
        this.wingId = l;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FleetMemberMovement fleetMemberMovement = (FleetMemberMovement)object;
        return Objects.equals((Object)this.role, (Object)fleetMemberMovement.role) && Objects.equals(this.squadId, fleetMemberMovement.squadId) && Objects.equals(this.wingId, fleetMemberMovement.wingId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.role, this.squadId, this.wingId});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class FleetMemberMovement {\n");
        stringBuilder.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        stringBuilder.append("    squadId: ").append(this.toIndentedString(this.squadId)).append("\n");
        stringBuilder.append("    wingId: ").append(this.toIndentedString(this.wingId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    public static enum RoleEnum {
        FLEET_COMMANDER("fleet_commander"),
        WING_COMMANDER("wing_commander"),
        SQUAD_COMMANDER("squad_commander"),
        SQUAD_MEMBER("squad_member");

        private String value;

        private RoleEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoleEnum fromValue(String string) {
            for (RoleEnum roleEnum : RoleEnum.values()) {
                if (!String.valueOf(roleEnum.value).equals(string)) continue;
                return roleEnum;
            }
            return null;
        }
    }
}

