/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCharactersActiveTotalKills;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCharactersLastWeekKills;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCharactersYesterdayKills;

@ApiModel(description="Top 100 rankings of pilots by number of kills from yesterday, last week and in total.")
public class FactionWarfareLeaderboardCharacterKills
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="active_total")
    private List<FactionWarfareLeaderboardCharactersActiveTotalKills> activeTotal = new ArrayList<FactionWarfareLeaderboardCharactersActiveTotalKills>();
    @JsonProperty(value="last_week")
    private List<FactionWarfareLeaderboardCharactersLastWeekKills> lastWeek = new ArrayList<FactionWarfareLeaderboardCharactersLastWeekKills>();
    @JsonProperty(value="yesterday")
    private List<FactionWarfareLeaderboardCharactersYesterdayKills> yesterday = new ArrayList<FactionWarfareLeaderboardCharactersYesterdayKills>();

    public FactionWarfareLeaderboardCharacterKills activeTotal(List<FactionWarfareLeaderboardCharactersActiveTotalKills> list) {
        this.activeTotal = list;
        return this;
    }

    public FactionWarfareLeaderboardCharacterKills addActiveTotalItem(FactionWarfareLeaderboardCharactersActiveTotalKills factionWarfareLeaderboardCharactersActiveTotalKills) {
        this.activeTotal.add(factionWarfareLeaderboardCharactersActiveTotalKills);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Top 100 ranking of pilots active in faction warfare by total kills. A pilot is considered \"active\" if they have participated in faction warfare in the past 14 days.")
    public List<FactionWarfareLeaderboardCharactersActiveTotalKills> getActiveTotal() {
        return this.activeTotal;
    }

    public void setActiveTotal(List<FactionWarfareLeaderboardCharactersActiveTotalKills> list) {
        this.activeTotal = list;
    }

    public FactionWarfareLeaderboardCharacterKills lastWeek(List<FactionWarfareLeaderboardCharactersLastWeekKills> list) {
        this.lastWeek = list;
        return this;
    }

    public FactionWarfareLeaderboardCharacterKills addLastWeekItem(FactionWarfareLeaderboardCharactersLastWeekKills factionWarfareLeaderboardCharactersLastWeekKills) {
        this.lastWeek.add(factionWarfareLeaderboardCharactersLastWeekKills);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Top 100 ranking of pilots by kills in the past week")
    public List<FactionWarfareLeaderboardCharactersLastWeekKills> getLastWeek() {
        return this.lastWeek;
    }

    public void setLastWeek(List<FactionWarfareLeaderboardCharactersLastWeekKills> list) {
        this.lastWeek = list;
    }

    public FactionWarfareLeaderboardCharacterKills yesterday(List<FactionWarfareLeaderboardCharactersYesterdayKills> list) {
        this.yesterday = list;
        return this;
    }

    public FactionWarfareLeaderboardCharacterKills addYesterdayItem(FactionWarfareLeaderboardCharactersYesterdayKills factionWarfareLeaderboardCharactersYesterdayKills) {
        this.yesterday.add(factionWarfareLeaderboardCharactersYesterdayKills);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Top 100 ranking of pilots by kills in the past day")
    public List<FactionWarfareLeaderboardCharactersYesterdayKills> getYesterday() {
        return this.yesterday;
    }

    public void setYesterday(List<FactionWarfareLeaderboardCharactersYesterdayKills> list) {
        this.yesterday = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FactionWarfareLeaderboardCharacterKills factionWarfareLeaderboardCharacterKills = (FactionWarfareLeaderboardCharacterKills)object;
        return Objects.equals(this.activeTotal, factionWarfareLeaderboardCharacterKills.activeTotal) && Objects.equals(this.lastWeek, factionWarfareLeaderboardCharacterKills.lastWeek) && Objects.equals(this.yesterday, factionWarfareLeaderboardCharacterKills.yesterday);
    }

    public int hashCode() {
        return Objects.hash(this.activeTotal, this.lastWeek, this.yesterday);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class FactionWarfareLeaderboardCharacterKills {\n");
        stringBuilder.append("    activeTotal: ").append(this.toIndentedString(this.activeTotal)).append("\n");
        stringBuilder.append("    lastWeek: ").append(this.toIndentedString(this.lastWeek)).append("\n");
        stringBuilder.append("    yesterday: ").append(this.toIndentedString(this.yesterday)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

