/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import net.troja.eve.esi.model.CharacterWalletJournalExtraInfoResponse;

@ApiModel(description="200 ok object")
public class CharacterWalletJournalResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="amount")
    private Float amount = null;
    @JsonProperty(value="balance")
    private Float balance = null;
    @JsonProperty(value="date")
    private OffsetDateTime date = null;
    @JsonProperty(value="extra_info")
    private CharacterWalletJournalExtraInfoResponse extraInfo = null;
    @JsonProperty(value="first_party_id")
    private Integer firstPartyId = null;
    @JsonProperty(value="first_party_type")
    private FirstPartyTypeEnum firstPartyType = null;
    @JsonProperty(value="reason")
    private String reason = null;
    @JsonProperty(value="ref_id")
    private Long refId = null;
    @JsonProperty(value="ref_type")
    private RefTypeEnum refType = null;
    @JsonProperty(value="second_party_id")
    private Integer secondPartyId = null;
    @JsonProperty(value="second_party_type")
    private SecondPartyTypeEnum secondPartyType = null;
    @JsonProperty(value="tax")
    private Float tax = null;
    @JsonProperty(value="tax_reciever_id")
    private Integer taxRecieverId = null;

    public CharacterWalletJournalResponse amount(Float f) {
        this.amount = f;
        return this;
    }

    @ApiModelProperty(example="null", value="Transaction amount. Positive when value transferred to the first party. Negative otherwise")
    public Float getAmount() {
        return this.amount;
    }

    public void setAmount(Float f) {
        this.amount = f;
    }

    public CharacterWalletJournalResponse balance(Float f) {
        this.balance = f;
        return this;
    }

    @ApiModelProperty(example="null", value="Wallet balance after transaction occurred")
    public Float getBalance() {
        return this.balance;
    }

    public void setBalance(Float f) {
        this.balance = f;
    }

    public CharacterWalletJournalResponse date(OffsetDateTime offsetDateTime) {
        this.date = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Date and time of transaction")
    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime offsetDateTime) {
        this.date = offsetDateTime;
    }

    public CharacterWalletJournalResponse extraInfo(CharacterWalletJournalExtraInfoResponse characterWalletJournalExtraInfoResponse) {
        this.extraInfo = characterWalletJournalExtraInfoResponse;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public CharacterWalletJournalExtraInfoResponse getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(CharacterWalletJournalExtraInfoResponse characterWalletJournalExtraInfoResponse) {
        this.extraInfo = characterWalletJournalExtraInfoResponse;
    }

    public CharacterWalletJournalResponse firstPartyId(Integer n) {
        this.firstPartyId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="first_party_id integer")
    public Integer getFirstPartyId() {
        return this.firstPartyId;
    }

    public void setFirstPartyId(Integer n) {
        this.firstPartyId = n;
    }

    public CharacterWalletJournalResponse firstPartyType(FirstPartyTypeEnum firstPartyTypeEnum) {
        this.firstPartyType = firstPartyTypeEnum;
        return this;
    }

    @ApiModelProperty(example="null", value="first_party_type string")
    public FirstPartyTypeEnum getFirstPartyType() {
        return this.firstPartyType;
    }

    public void setFirstPartyType(FirstPartyTypeEnum firstPartyTypeEnum) {
        this.firstPartyType = firstPartyTypeEnum;
    }

    public CharacterWalletJournalResponse reason(String string) {
        this.reason = string;
        return this;
    }

    @ApiModelProperty(example="null", value="reason string")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public CharacterWalletJournalResponse refId(Long l) {
        this.refId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Unique journal reference ID")
    public Long getRefId() {
        return this.refId;
    }

    public void setRefId(Long l) {
        this.refId = l;
    }

    public CharacterWalletJournalResponse refType(RefTypeEnum refTypeEnum) {
        this.refType = refTypeEnum;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Transaction type, different type of transaction will populate different fields in `extra_info`")
    public RefTypeEnum getRefType() {
        return this.refType;
    }

    public void setRefType(RefTypeEnum refTypeEnum) {
        this.refType = refTypeEnum;
    }

    public CharacterWalletJournalResponse secondPartyId(Integer n) {
        this.secondPartyId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="second_party_id integer")
    public Integer getSecondPartyId() {
        return this.secondPartyId;
    }

    public void setSecondPartyId(Integer n) {
        this.secondPartyId = n;
    }

    public CharacterWalletJournalResponse secondPartyType(SecondPartyTypeEnum secondPartyTypeEnum) {
        this.secondPartyType = secondPartyTypeEnum;
        return this;
    }

    @ApiModelProperty(example="null", value="second_party_type string")
    public SecondPartyTypeEnum getSecondPartyType() {
        return this.secondPartyType;
    }

    public void setSecondPartyType(SecondPartyTypeEnum secondPartyTypeEnum) {
        this.secondPartyType = secondPartyTypeEnum;
    }

    public CharacterWalletJournalResponse tax(Float f) {
        this.tax = f;
        return this;
    }

    @ApiModelProperty(example="null", value="Tax amount received for tax related transactions")
    public Float getTax() {
        return this.tax;
    }

    public void setTax(Float f) {
        this.tax = f;
    }

    public CharacterWalletJournalResponse taxRecieverId(Integer n) {
        this.taxRecieverId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="the corporation ID receiving any tax paid")
    public Integer getTaxRecieverId() {
        return this.taxRecieverId;
    }

    public void setTaxRecieverId(Integer n) {
        this.taxRecieverId = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CharacterWalletJournalResponse characterWalletJournalResponse = (CharacterWalletJournalResponse)object;
        return Objects.equals(this.amount, characterWalletJournalResponse.amount) && Objects.equals(this.balance, characterWalletJournalResponse.balance) && Objects.equals(this.date, characterWalletJournalResponse.date) && Objects.equals(this.extraInfo, characterWalletJournalResponse.extraInfo) && Objects.equals(this.firstPartyId, characterWalletJournalResponse.firstPartyId) && Objects.equals((Object)this.firstPartyType, (Object)characterWalletJournalResponse.firstPartyType) && Objects.equals(this.reason, characterWalletJournalResponse.reason) && Objects.equals(this.refId, characterWalletJournalResponse.refId) && Objects.equals((Object)this.refType, (Object)characterWalletJournalResponse.refType) && Objects.equals(this.secondPartyId, characterWalletJournalResponse.secondPartyId) && Objects.equals((Object)this.secondPartyType, (Object)characterWalletJournalResponse.secondPartyType) && Objects.equals(this.tax, characterWalletJournalResponse.tax) && Objects.equals(this.taxRecieverId, characterWalletJournalResponse.taxRecieverId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.balance, this.date, this.extraInfo, this.firstPartyId, this.firstPartyType, this.reason, this.refId, this.refType, this.secondPartyId, this.secondPartyType, this.tax, this.taxRecieverId});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CharacterWalletJournalResponse {\n");
        stringBuilder.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        stringBuilder.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        stringBuilder.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        stringBuilder.append("    extraInfo: ").append(this.toIndentedString(this.extraInfo)).append("\n");
        stringBuilder.append("    firstPartyId: ").append(this.toIndentedString(this.firstPartyId)).append("\n");
        stringBuilder.append("    firstPartyType: ").append(this.toIndentedString((Object)this.firstPartyType)).append("\n");
        stringBuilder.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        stringBuilder.append("    refId: ").append(this.toIndentedString(this.refId)).append("\n");
        stringBuilder.append("    refType: ").append(this.toIndentedString((Object)this.refType)).append("\n");
        stringBuilder.append("    secondPartyId: ").append(this.toIndentedString(this.secondPartyId)).append("\n");
        stringBuilder.append("    secondPartyType: ").append(this.toIndentedString((Object)this.secondPartyType)).append("\n");
        stringBuilder.append("    tax: ").append(this.toIndentedString(this.tax)).append("\n");
        stringBuilder.append("    taxRecieverId: ").append(this.toIndentedString(this.taxRecieverId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    public static enum SecondPartyTypeEnum {
        CHARACTER("character"),
        CORPORATION("corporation"),
        ALLIANCE("alliance"),
        FACTION("faction");

        private String value;

        private SecondPartyTypeEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SecondPartyTypeEnum fromValue(String string) {
            for (SecondPartyTypeEnum secondPartyTypeEnum : SecondPartyTypeEnum.values()) {
                if (!String.valueOf(secondPartyTypeEnum.value).equals(string)) continue;
                return secondPartyTypeEnum;
            }
            return null;
        }
    }

    public static enum RefTypeEnum {
        PLAYER_TRADING("player_trading"),
        MARKET_TRANSACTION("market_transaction"),
        PLAYER_DONATION("player_donation"),
        OFFICE_RENTAL_FEE("office_rental_fee"),
        BOUNTY_PRIZE_HISTORICAL("bounty_prize_historical"),
        INSURANCE("insurance"),
        MISSION_REWARD("mission_reward"),
        MISSION_REWARD_BONUS("mission_reward_bonus"),
        CSPA("cspa"),
        CORP_ACCOUNT_WITHDRAWAL("corp_account_withdrawal"),
        LOGO_CHANGE_FEE("logo_change_fee"),
        MARKET_ESCROW("market_escrow"),
        BROKER_FEE("broker_fee"),
        ALLIANCE_MAINTENANCE_FEE("alliance_maintenance_fee"),
        SALES_TAX("sales_tax"),
        JUMP_CLONE_INSTALLATION_FEE("jump_clone_installation_fee"),
        MANUFACTURING("manufacturing"),
        CONTRACT("contract"),
        BOUNTY_PRIZES("bounty_prizes"),
        MEDAL_CREATION_FEE("medal_creation_fee"),
        MEDAL_ISSUING_FEE("medal_issuing_fee"),
        CUSTOMS_OFFICE_IMPORT_DUTY("customs_office_import_duty"),
        CUSTOMS_OFFICE_EXPORT_DUTY("customs_office_export_duty"),
        CORPORATE_REWARD_PAYOUT("corporate_reward_payout"),
        INDUSTRY_FACILITY_TAX("industry_facility_tax"),
        PROJECT_DISCOVERY_REWARD("project_discovery_reward"),
        REPROCESSING_FEE("reprocessing_fee"),
        JUMP_CLONE_ACTIVATION_FEE("jump_clone_activation_fee"),
        UNKNOWN("unknown");

        private String value;

        private RefTypeEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RefTypeEnum fromValue(String string) {
            for (RefTypeEnum refTypeEnum : RefTypeEnum.values()) {
                if (!String.valueOf(refTypeEnum.value).equals(string)) continue;
                return refTypeEnum;
            }
            return null;
        }
    }

    public static enum FirstPartyTypeEnum {
        CHARACTER("character"),
        CORPORATION("corporation"),
        ALLIANCE("alliance"),
        FACTION("faction");

        private String value;

        private FirstPartyTypeEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FirstPartyTypeEnum fromValue(String string) {
            for (FirstPartyTypeEnum firstPartyTypeEnum : FirstPartyTypeEnum.values()) {
                if (!String.valueOf(firstPartyTypeEnum.value).equals(string)) continue;
                return firstPartyTypeEnum;
            }
            return null;
        }
    }
}

