/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CharacterBlueprintsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="item_id")
    private Long itemId = null;
    @JsonProperty(value="location_flag")
    private LocationFlagEnum locationFlag = null;
    @JsonProperty(value="location_id")
    private Long locationId = null;
    @JsonProperty(value="material_efficiency")
    private Integer materialEfficiency = null;
    @JsonProperty(value="quantity")
    private Integer quantity = null;
    @JsonProperty(value="runs")
    private Integer runs = null;
    @JsonProperty(value="time_efficiency")
    private Integer timeEfficiency = null;
    @JsonProperty(value="type_id")
    private Integer typeId = null;

    public CharacterBlueprintsResponse itemId(Long l) {
        this.itemId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Unique ID for this item. The ID of an item is stable if that item is not repackaged, stacked, detached from a stack, assembled, or otherwise altered. If an item is changed in one of these ways, then the ID will also change (see notes below).")
    public Long getItemId() {
        return this.itemId;
    }

    public void setItemId(Long l) {
        this.itemId = l;
    }

    public CharacterBlueprintsResponse locationFlag(LocationFlagEnum locationFlagEnum) {
        this.locationFlag = locationFlagEnum;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates something about this item's storage location. The flag is used to differentiate between hangar divisions, drone bay, fitting location, and similar.")
    public LocationFlagEnum getLocationFlag() {
        return this.locationFlag;
    }

    public void setLocationFlag(LocationFlagEnum locationFlagEnum) {
        this.locationFlag = locationFlagEnum;
    }

    public CharacterBlueprintsResponse locationId(Long l) {
        this.locationId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="References a solar system, station or item_id if this blueprint is located within a container. If an item_id the Character - AssetList API must be queried to find the container using the item_id, from which the correct location of the Blueprint can be derived.")
    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Long l) {
        this.locationId = l;
    }

    public CharacterBlueprintsResponse materialEfficiency(Integer n) {
        this.materialEfficiency = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Material Efficiency Level of the blueprint, can be any integer between 0 and 10.")
    public Integer getMaterialEfficiency() {
        return this.materialEfficiency;
    }

    public void setMaterialEfficiency(Integer n) {
        this.materialEfficiency = n;
    }

    public CharacterBlueprintsResponse quantity(Integer n) {
        this.quantity = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Typically will be -1 or -2 designating a singleton item, where -1 is an original and -2 is a copy. It can be a positive integer if it is a stack of blueprint originals fresh from the market (no activities performed on them yet).")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer n) {
        this.quantity = n;
    }

    public CharacterBlueprintsResponse runs(Integer n) {
        this.runs = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Number of runs remaining if the blueprint is a copy, -1 if it is an original.")
    public Integer getRuns() {
        return this.runs;
    }

    public void setRuns(Integer n) {
        this.runs = n;
    }

    public CharacterBlueprintsResponse timeEfficiency(Integer n) {
        this.timeEfficiency = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Time Efficiency Level of the blueprint, can be any even integer between 0 and 20.")
    public Integer getTimeEfficiency() {
        return this.timeEfficiency;
    }

    public void setTimeEfficiency(Integer n) {
        this.timeEfficiency = n;
    }

    public CharacterBlueprintsResponse typeId(Integer n) {
        this.typeId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="type_id integer")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer n) {
        this.typeId = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CharacterBlueprintsResponse characterBlueprintsResponse = (CharacterBlueprintsResponse)object;
        return Objects.equals(this.itemId, characterBlueprintsResponse.itemId) && Objects.equals((Object)this.locationFlag, (Object)characterBlueprintsResponse.locationFlag) && Objects.equals(this.locationId, characterBlueprintsResponse.locationId) && Objects.equals(this.materialEfficiency, characterBlueprintsResponse.materialEfficiency) && Objects.equals(this.quantity, characterBlueprintsResponse.quantity) && Objects.equals(this.runs, characterBlueprintsResponse.runs) && Objects.equals(this.timeEfficiency, characterBlueprintsResponse.timeEfficiency) && Objects.equals(this.typeId, characterBlueprintsResponse.typeId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.itemId, this.locationFlag, this.locationId, this.materialEfficiency, this.quantity, this.runs, this.timeEfficiency, this.typeId});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CharacterBlueprintsResponse {\n");
        stringBuilder.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        stringBuilder.append("    locationFlag: ").append(this.toIndentedString((Object)this.locationFlag)).append("\n");
        stringBuilder.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        stringBuilder.append("    materialEfficiency: ").append(this.toIndentedString(this.materialEfficiency)).append("\n");
        stringBuilder.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        stringBuilder.append("    runs: ").append(this.toIndentedString(this.runs)).append("\n");
        stringBuilder.append("    timeEfficiency: ").append(this.toIndentedString(this.timeEfficiency)).append("\n");
        stringBuilder.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    public static enum LocationFlagEnum {
        AUTOFIT("AutoFit"),
        CARGO("Cargo"),
        CORPSEBAY("CorpseBay"),
        DRONEBAY("DroneBay"),
        FLEETHANGAR("FleetHangar"),
        DELIVERIES("Deliveries"),
        HIDDENMODIFIERS("HiddenModifiers"),
        HANGAR("Hangar"),
        HANGARALL("HangarAll"),
        LOSLOT0("LoSlot0"),
        LOSLOT1("LoSlot1"),
        LOSLOT2("LoSlot2"),
        LOSLOT3("LoSlot3"),
        LOSLOT4("LoSlot4"),
        LOSLOT5("LoSlot5"),
        LOSLOT6("LoSlot6"),
        LOSLOT7("LoSlot7"),
        MEDSLOT0("MedSlot0"),
        MEDSLOT1("MedSlot1"),
        MEDSLOT2("MedSlot2"),
        MEDSLOT3("MedSlot3"),
        MEDSLOT4("MedSlot4"),
        MEDSLOT5("MedSlot5"),
        MEDSLOT6("MedSlot6"),
        MEDSLOT7("MedSlot7"),
        HISLOT0("HiSlot0"),
        HISLOT1("HiSlot1"),
        HISLOT2("HiSlot2"),
        HISLOT3("HiSlot3"),
        HISLOT4("HiSlot4"),
        HISLOT5("HiSlot5"),
        HISLOT6("HiSlot6"),
        HISLOT7("HiSlot7"),
        ASSETSAFETY("AssetSafety"),
        LOCKED("Locked"),
        UNLOCKED("Unlocked"),
        IMPLANT("Implant"),
        QUAFEBAY("QuafeBay"),
        RIGSLOT0("RigSlot0"),
        RIGSLOT1("RigSlot1"),
        RIGSLOT2("RigSlot2"),
        RIGSLOT3("RigSlot3"),
        RIGSLOT4("RigSlot4"),
        RIGSLOT5("RigSlot5"),
        RIGSLOT6("RigSlot6"),
        RIGSLOT7("RigSlot7"),
        SHIPHANGAR("ShipHangar"),
        SPECIALIZEDFUELBAY("SpecializedFuelBay"),
        SPECIALIZEDOREHOLD("SpecializedOreHold"),
        SPECIALIZEDGASHOLD("SpecializedGasHold"),
        SPECIALIZEDMINERALHOLD("SpecializedMineralHold"),
        SPECIALIZEDSALVAGEHOLD("SpecializedSalvageHold"),
        SPECIALIZEDSHIPHOLD("SpecializedShipHold"),
        SPECIALIZEDSMALLSHIPHOLD("SpecializedSmallShipHold"),
        SPECIALIZEDMEDIUMSHIPHOLD("SpecializedMediumShipHold"),
        SPECIALIZEDLARGESHIPHOLD("SpecializedLargeShipHold"),
        SPECIALIZEDINDUSTRIALSHIPHOLD("SpecializedIndustrialShipHold"),
        SPECIALIZEDAMMOHOLD("SpecializedAmmoHold"),
        SPECIALIZEDCOMMANDCENTERHOLD("SpecializedCommandCenterHold"),
        SPECIALIZEDPLANETARYCOMMODITIESHOLD("SpecializedPlanetaryCommoditiesHold"),
        SPECIALIZEDMATERIALBAY("SpecializedMaterialBay"),
        SUBSYSTEMSLOT0("SubSystemSlot0"),
        SUBSYSTEMSLOT1("SubSystemSlot1"),
        SUBSYSTEMSLOT2("SubSystemSlot2"),
        SUBSYSTEMSLOT3("SubSystemSlot3"),
        SUBSYSTEMSLOT4("SubSystemSlot4"),
        SUBSYSTEMSLOT5("SubSystemSlot5"),
        SUBSYSTEMSLOT6("SubSystemSlot6"),
        SUBSYSTEMSLOT7("SubSystemSlot7"),
        FIGHTERBAY("FighterBay"),
        FIGHTERTUBE0("FighterTube0"),
        FIGHTERTUBE1("FighterTube1"),
        FIGHTERTUBE2("FighterTube2"),
        FIGHTERTUBE3("FighterTube3"),
        FIGHTERTUBE4("FighterTube4"),
        MODULE("Module");

        private String value;

        private LocationFlagEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LocationFlagEnum fromValue(String string) {
            for (LocationFlagEnum locationFlagEnum : LocationFlagEnum.values()) {
                if (!String.valueOf(locationFlagEnum.value).equals(string)) continue;
                return locationFlagEnum;
            }
            return null;
        }
    }
}

