/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.auth;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ProcessingException;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.auth.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.client.oauth2.ClientIdentifier;
import org.glassfish.jersey.client.oauth2.OAuth2ClientSupport;
import org.glassfish.jersey.client.oauth2.OAuth2CodeGrantFlow;
import org.glassfish.jersey.client.oauth2.TokenResult;

public class OAuth
implements Authentication {
    public static final String URI_OAUTH = "https://login.eveonline.com/oauth";
    private static final String URI_AUTHENTICATION = "https://login.eveonline.com/oauth/authorize";
    private static final String URI_ACCESS_TOKEN = "https://login.eveonline.com/oauth/token";
    private String accessToken;
    private long validUntil;
    private String refreshToken;
    private String clientId;
    private String clientSecret;
    private OAuth2CodeGrantFlow oAuthFlow;
    private final Map<String, AccessTokenData> accessTokenCache = new HashMap<String, AccessTokenData>();

    @Override
    public void applyToParams(List<Pair> list, Map<String, String> map) {
        if (this.refreshToken != null && this.validUntil < System.currentTimeMillis()) {
            try {
                this.refreshToken();
            }
            catch (ProcessingException processingException) {
                // empty catch block
            }
        }
        if (this.accessToken != null) {
            map.put("Authorization", "Bearer " + this.accessToken);
        }
    }

    public String getAuthorizationUri(String string, Set<String> set, String string2) {
        if (this.oAuthFlow == null) {
            this.createFlow(string, set, string2);
        }
        return this.oAuthFlow.start();
    }

    public void finishFlow(String string, String string2) throws ApiException {
        try {
            this.updateTokens(this.getFlow().finish(string, string2));
        }
        catch (ProcessingException processingException) {
            throw new ApiException(processingException);
        }
    }

    private void refreshToken() {
        this.updateTokens(this.getFlow().refreshAccessToken(this.refreshToken));
    }

    private OAuth2CodeGrantFlow getFlow() {
        if (this.oAuthFlow == null) {
            this.createFlow(null, null, null);
        }
        return this.oAuthFlow;
    }

    private void updateTokens(TokenResult tokenResult) {
        this.accessToken = tokenResult.getAccessToken();
        this.refreshToken = tokenResult.getRefreshToken();
        this.validUntil = System.currentTimeMillis() + tokenResult.getExpiresIn() * 1000L - 5000L;
        this.saveAccessToken();
    }

    private void createFlow(String string, Set<String> set, String string2) {
        String string3 = this.getScopesString(set);
        ClientIdentifier clientIdentifier = new ClientIdentifier(this.clientId, this.clientSecret);
        OAuth2CodeGrantFlow.Builder builder = OAuth2ClientSupport.authorizationCodeGrantFlowBuilder((ClientIdentifier)clientIdentifier, (String)URI_AUTHENTICATION, (String)URI_ACCESS_TOKEN);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            builder.redirectUri(string);
        }
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            builder.property(OAuth2CodeGrantFlow.Phase.AUTHORIZATION, "state", string2);
        }
        if (StringUtils.isNotBlank((CharSequence)string3)) {
            builder.scope(string3);
        }
        this.oAuthFlow = builder.build();
    }

    private String getScopesString(Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        if (set != null) {
            for (String string : set) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public void setAccessToken(String string) {
        this.accessToken = string;
    }

    public void setRefreshToken(String string) {
        this.refreshToken = string;
        this.loadAccessToken();
    }

    public void setClientId(String string) {
        this.clientId = string;
        this.loadAccessToken();
    }

    public void setClientSecret(String string) {
        this.clientSecret = string;
        this.loadAccessToken();
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    private void saveAccessToken() {
        AccessTokenData accessTokenData = new AccessTokenData(this.accessToken, this.validUntil);
        this.accessTokenCache.put(this.getAuthKey(), accessTokenData);
    }

    private void loadAccessToken() {
        AccessTokenData accessTokenData = this.accessTokenCache.get(this.getAuthKey());
        if (accessTokenData != null) {
            this.accessToken = accessTokenData.getAccessToken();
            this.validUntil = accessTokenData.getValidUntil();
        } else {
            this.accessToken = null;
            this.validUntil = 0L;
        }
    }

    private String getAuthKey() {
        return this.clientId + this.clientSecret + this.refreshToken;
    }

    private static class AccessTokenData {
        private final String accessToken;
        private final long validUntil;

        public AccessTokenData(String string, long l) {
            this.accessToken = string;
            this.validUntil = l;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public long getValidUntil() {
            return this.validUntil;
        }
    }
}

