/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class CharacterWalletsJournalResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="amount")
    private Float amount = null;
    @JsonProperty(value="argument_name")
    private String argumentName = null;
    @JsonProperty(value="argument_value")
    private Integer argumentValue = null;
    @JsonProperty(value="balance")
    private Float balance = null;
    @JsonProperty(value="date")
    private OffsetDateTime date = null;
    @JsonProperty(value="first_party_id")
    private Integer firstPartyId = null;
    @JsonProperty(value="first_party_type")
    private FirstPartyTypeEnum firstPartyType = null;
    @JsonProperty(value="reason")
    private String reason = null;
    @JsonProperty(value="ref_id")
    private Long refId = null;
    @JsonProperty(value="ref_type_id")
    private Integer refTypeId = null;
    @JsonProperty(value="second_party_id")
    private Integer secondPartyId = null;
    @JsonProperty(value="second_party_type")
    private SecondPartyTypeEnum secondPartyType = null;
    @JsonProperty(value="tax_amount")
    private Float taxAmount = null;
    @JsonProperty(value="tax_reciever_id")
    private Integer taxRecieverId = null;

    public CharacterWalletsJournalResponse amount(Float f) {
        this.amount = f;
        return this;
    }

    @ApiModelProperty(example="null", value="Transaction amount. Positive when value transferred to the first party. Negative otherwise")
    public Float getAmount() {
        return this.amount;
    }

    public void setAmount(Float f) {
        this.amount = f;
    }

    public CharacterWalletsJournalResponse argumentName(String string) {
        this.argumentName = string;
        return this;
    }

    @ApiModelProperty(example="null", value="argument_name string")
    public String getArgumentName() {
        return this.argumentName;
    }

    public void setArgumentName(String string) {
        this.argumentName = string;
    }

    public CharacterWalletsJournalResponse argumentValue(Integer n) {
        this.argumentValue = n;
        return this;
    }

    @ApiModelProperty(example="null", value="argument_value integer")
    public Integer getArgumentValue() {
        return this.argumentValue;
    }

    public void setArgumentValue(Integer n) {
        this.argumentValue = n;
    }

    public CharacterWalletsJournalResponse balance(Float f) {
        this.balance = f;
        return this;
    }

    @ApiModelProperty(example="null", value="Wallet balance after transaction occurred")
    public Float getBalance() {
        return this.balance;
    }

    public void setBalance(Float f) {
        this.balance = f;
    }

    public CharacterWalletsJournalResponse date(OffsetDateTime offsetDateTime) {
        this.date = offsetDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Date and time of transaction")
    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime offsetDateTime) {
        this.date = offsetDateTime;
    }

    public CharacterWalletsJournalResponse firstPartyId(Integer n) {
        this.firstPartyId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="first_party_id integer")
    public Integer getFirstPartyId() {
        return this.firstPartyId;
    }

    public void setFirstPartyId(Integer n) {
        this.firstPartyId = n;
    }

    public CharacterWalletsJournalResponse firstPartyType(FirstPartyTypeEnum firstPartyTypeEnum) {
        this.firstPartyType = firstPartyTypeEnum;
        return this;
    }

    @ApiModelProperty(example="null", value="first_party_type string")
    public FirstPartyTypeEnum getFirstPartyType() {
        return this.firstPartyType;
    }

    public void setFirstPartyType(FirstPartyTypeEnum firstPartyTypeEnum) {
        this.firstPartyType = firstPartyTypeEnum;
    }

    public CharacterWalletsJournalResponse reason(String string) {
        this.reason = string;
        return this;
    }

    @ApiModelProperty(example="null", value="reason string")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public CharacterWalletsJournalResponse refId(Long l) {
        this.refId = l;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Unique journal reference ID")
    public Long getRefId() {
        return this.refId;
    }

    public void setRefId(Long l) {
        this.refId = l;
    }

    public CharacterWalletsJournalResponse refTypeId(Integer n) {
        this.refTypeId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Transaction type")
    public Integer getRefTypeId() {
        return this.refTypeId;
    }

    public void setRefTypeId(Integer n) {
        this.refTypeId = n;
    }

    public CharacterWalletsJournalResponse secondPartyId(Integer n) {
        this.secondPartyId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="second_party_id integer")
    public Integer getSecondPartyId() {
        return this.secondPartyId;
    }

    public void setSecondPartyId(Integer n) {
        this.secondPartyId = n;
    }

    public CharacterWalletsJournalResponse secondPartyType(SecondPartyTypeEnum secondPartyTypeEnum) {
        this.secondPartyType = secondPartyTypeEnum;
        return this;
    }

    @ApiModelProperty(example="null", value="second_party_type string")
    public SecondPartyTypeEnum getSecondPartyType() {
        return this.secondPartyType;
    }

    public void setSecondPartyType(SecondPartyTypeEnum secondPartyTypeEnum) {
        this.secondPartyType = secondPartyTypeEnum;
    }

    public CharacterWalletsJournalResponse taxAmount(Float f) {
        this.taxAmount = f;
        return this;
    }

    @ApiModelProperty(example="null", value="Tax amount received for tax related transactions")
    public Float getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(Float f) {
        this.taxAmount = f;
    }

    public CharacterWalletsJournalResponse taxRecieverId(Integer n) {
        this.taxRecieverId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="For tax related transactions, gives the corporation ID of the entity receiving the tax")
    public Integer getTaxRecieverId() {
        return this.taxRecieverId;
    }

    public void setTaxRecieverId(Integer n) {
        this.taxRecieverId = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CharacterWalletsJournalResponse characterWalletsJournalResponse = (CharacterWalletsJournalResponse)object;
        return Objects.equals(this.amount, characterWalletsJournalResponse.amount) && Objects.equals(this.argumentName, characterWalletsJournalResponse.argumentName) && Objects.equals(this.argumentValue, characterWalletsJournalResponse.argumentValue) && Objects.equals(this.balance, characterWalletsJournalResponse.balance) && Objects.equals(this.date, characterWalletsJournalResponse.date) && Objects.equals(this.firstPartyId, characterWalletsJournalResponse.firstPartyId) && Objects.equals((Object)this.firstPartyType, (Object)characterWalletsJournalResponse.firstPartyType) && Objects.equals(this.reason, characterWalletsJournalResponse.reason) && Objects.equals(this.refId, characterWalletsJournalResponse.refId) && Objects.equals(this.refTypeId, characterWalletsJournalResponse.refTypeId) && Objects.equals(this.secondPartyId, characterWalletsJournalResponse.secondPartyId) && Objects.equals((Object)this.secondPartyType, (Object)characterWalletsJournalResponse.secondPartyType) && Objects.equals(this.taxAmount, characterWalletsJournalResponse.taxAmount) && Objects.equals(this.taxRecieverId, characterWalletsJournalResponse.taxRecieverId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.argumentName, this.argumentValue, this.balance, this.date, this.firstPartyId, this.firstPartyType, this.reason, this.refId, this.refTypeId, this.secondPartyId, this.secondPartyType, this.taxAmount, this.taxRecieverId});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class CharacterWalletsJournalResponse {\n");
        stringBuilder.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        stringBuilder.append("    argumentName: ").append(this.toIndentedString(this.argumentName)).append("\n");
        stringBuilder.append("    argumentValue: ").append(this.toIndentedString(this.argumentValue)).append("\n");
        stringBuilder.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        stringBuilder.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        stringBuilder.append("    firstPartyId: ").append(this.toIndentedString(this.firstPartyId)).append("\n");
        stringBuilder.append("    firstPartyType: ").append(this.toIndentedString((Object)this.firstPartyType)).append("\n");
        stringBuilder.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        stringBuilder.append("    refId: ").append(this.toIndentedString(this.refId)).append("\n");
        stringBuilder.append("    refTypeId: ").append(this.toIndentedString(this.refTypeId)).append("\n");
        stringBuilder.append("    secondPartyId: ").append(this.toIndentedString(this.secondPartyId)).append("\n");
        stringBuilder.append("    secondPartyType: ").append(this.toIndentedString((Object)this.secondPartyType)).append("\n");
        stringBuilder.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        stringBuilder.append("    taxRecieverId: ").append(this.toIndentedString(this.taxRecieverId)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    public static enum SecondPartyTypeEnum {
        CHARACTER("character"),
        CORPORATION("corporation"),
        ALLIANCE("alliance"),
        FACTION("faction");

        private String value;

        private SecondPartyTypeEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SecondPartyTypeEnum fromValue(String string) {
            for (SecondPartyTypeEnum secondPartyTypeEnum : SecondPartyTypeEnum.values()) {
                if (!String.valueOf(secondPartyTypeEnum.value).equals(string)) continue;
                return secondPartyTypeEnum;
            }
            return null;
        }
    }

    public static enum FirstPartyTypeEnum {
        CHARACTER("character"),
        CORPORATION("corporation"),
        ALLIANCE("alliance"),
        FACTION("faction");

        private String value;

        private FirstPartyTypeEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FirstPartyTypeEnum fromValue(String string) {
            for (FirstPartyTypeEnum firstPartyTypeEnum : FirstPartyTypeEnum.values()) {
                if (!String.valueOf(firstPartyTypeEnum.value).equals(string)) continue;
                return firstPartyTypeEnum;
            }
            return null;
        }
    }
}

