/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import net.troja.eve.esi.model.CharacterWalletJournalExtraInfoResponse;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class CharacterWalletJournalResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("amount")
    private Float amount = null;

    @JsonProperty("balance")
    private Float balance = null;

    @JsonProperty("date")
    private OffsetDateTime date = null;

    @JsonProperty("extra_info")
    private CharacterWalletJournalExtraInfoResponse extraInfo = null;

    @JsonProperty("first_party_id")
    private Integer firstPartyId = null;

    /**
     * first_party_type string
     */
    public enum FirstPartyTypeEnum {
        CHARACTER("character"),

        CORPORATION("corporation"),

        ALLIANCE("alliance"),

        FACTION("faction");

        private String value;

        FirstPartyTypeEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static FirstPartyTypeEnum fromValue(String text) {
            for (FirstPartyTypeEnum b : FirstPartyTypeEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("first_party_type")
    private FirstPartyTypeEnum firstPartyType = null;

    @JsonProperty("reason")
    private String reason = null;

    @JsonProperty("ref_id")
    private Long refId = null;

    /**
     * Transaction type, different type of transaction will populate different
     * fields in `extra_info`
     */
    public enum RefTypeEnum {
        PLAYER_TRADING("player_trading"),

        MARKET_TRANSACTION("market_transaction"),

        PLAYER_DONATION("player_donation"),

        OFFICE_RENTAL_FEE("office_rental_fee"),

        BOUNTY_PRIZE_HISTORICAL("bounty_prize_historical"),

        INSURANCE("insurance"),

        MISSION_REWARD("mission_reward"),

        MISSION_REWARD_BONUS("mission_reward_bonus"),

        CSPA("cspa"),

        CORP_ACCOUNT_WITHDRAWAL("corp_account_withdrawal"),

        LOGO_CHANGE_FEE("logo_change_fee"),

        MARKET_ESCROW("market_escrow"),

        BROKER_FEE("broker_fee"),

        ALLIANCE_MAINTENANCE_FEE("alliance_maintenance_fee"),

        SALES_TAX("sales_tax"),

        JUMP_CLONE_INSTALLATION_FEE("jump_clone_installation_fee"),

        MANUFACTURING("manufacturing"),

        CONTRACT("contract"),

        BOUNTY_PRIZES("bounty_prizes"),

        MEDAL_CREATION_FEE("medal_creation_fee"),

        MEDAL_ISSUING_FEE("medal_issuing_fee"),

        CUSTOMS_OFFICE_IMPORT_DUTY("customs_office_import_duty"),

        CUSTOMS_OFFICE_EXPORT_DUTY("customs_office_export_duty"),

        CORPORATE_REWARD_PAYOUT("corporate_reward_payout"),

        INDUSTRY_FACILITY_TAX("industry_facility_tax"),

        PROJECT_DISCOVERY_REWARD("project_discovery_reward"),

        REPROCESSING_FEE("reprocessing_fee"),

        JUMP_CLONE_ACTIVATION_FEE("jump_clone_activation_fee"),

        UNKNOWN("unknown");

        private String value;

        RefTypeEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static RefTypeEnum fromValue(String text) {
            for (RefTypeEnum b : RefTypeEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("ref_type")
    private RefTypeEnum refType = null;

    @JsonProperty("second_party_id")
    private Integer secondPartyId = null;

    /**
     * second_party_type string
     */
    public enum SecondPartyTypeEnum {
        CHARACTER("character"),

        CORPORATION("corporation"),

        ALLIANCE("alliance"),

        FACTION("faction");

        private String value;

        SecondPartyTypeEnum(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static SecondPartyTypeEnum fromValue(String text) {
            for (SecondPartyTypeEnum b : SecondPartyTypeEnum.values()) {
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
            }
            return null;
        }
    }

    @JsonProperty("second_party_type")
    private SecondPartyTypeEnum secondPartyType = null;

    @JsonProperty("tax")
    private Float tax = null;

    @JsonProperty("tax_reciever_id")
    private Integer taxRecieverId = null;

    public CharacterWalletJournalResponse amount(Float amount) {
        this.amount = amount;
        return this;
    }

    /**
     * Transaction amount. Positive when value transferred to the first party.
     * Negative otherwise
     * 
     * @return amount
     **/
    @ApiModelProperty(example = "null", value = "Transaction amount. Positive when value transferred to the first party. Negative otherwise")
    public Float getAmount() {
        return amount;
    }

    public void setAmount(Float amount) {
        this.amount = amount;
    }

    public CharacterWalletJournalResponse balance(Float balance) {
        this.balance = balance;
        return this;
    }

    /**
     * Wallet balance after transaction occurred
     * 
     * @return balance
     **/
    @ApiModelProperty(example = "null", value = "Wallet balance after transaction occurred")
    public Float getBalance() {
        return balance;
    }

    public void setBalance(Float balance) {
        this.balance = balance;
    }

    public CharacterWalletJournalResponse date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    /**
     * Date and time of transaction
     * 
     * @return date
     **/
    @ApiModelProperty(example = "null", required = true, value = "Date and time of transaction")
    public OffsetDateTime getDate() {
        return date;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public CharacterWalletJournalResponse extraInfo(CharacterWalletJournalExtraInfoResponse extraInfo) {
        this.extraInfo = extraInfo;
        return this;
    }

    /**
     * Get extraInfo
     * 
     * @return extraInfo
     **/
    @ApiModelProperty(example = "null", value = "")
    public CharacterWalletJournalExtraInfoResponse getExtraInfo() {
        return extraInfo;
    }

    public void setExtraInfo(CharacterWalletJournalExtraInfoResponse extraInfo) {
        this.extraInfo = extraInfo;
    }

    public CharacterWalletJournalResponse firstPartyId(Integer firstPartyId) {
        this.firstPartyId = firstPartyId;
        return this;
    }

    /**
     * first_party_id integer
     * 
     * @return firstPartyId
     **/
    @ApiModelProperty(example = "null", value = "first_party_id integer")
    public Integer getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Integer firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public CharacterWalletJournalResponse firstPartyType(FirstPartyTypeEnum firstPartyType) {
        this.firstPartyType = firstPartyType;
        return this;
    }

    /**
     * first_party_type string
     * 
     * @return firstPartyType
     **/
    @ApiModelProperty(example = "null", value = "first_party_type string")
    public FirstPartyTypeEnum getFirstPartyType() {
        return firstPartyType;
    }

    public void setFirstPartyType(FirstPartyTypeEnum firstPartyType) {
        this.firstPartyType = firstPartyType;
    }

    public CharacterWalletJournalResponse reason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * reason string
     * 
     * @return reason
     **/
    @ApiModelProperty(example = "null", value = "reason string")
    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public CharacterWalletJournalResponse refId(Long refId) {
        this.refId = refId;
        return this;
    }

    /**
     * Unique journal reference ID
     * 
     * @return refId
     **/
    @ApiModelProperty(example = "null", required = true, value = "Unique journal reference ID")
    public Long getRefId() {
        return refId;
    }

    public void setRefId(Long refId) {
        this.refId = refId;
    }

    public CharacterWalletJournalResponse refType(RefTypeEnum refType) {
        this.refType = refType;
        return this;
    }

    /**
     * Transaction type, different type of transaction will populate different
     * fields in `extra_info`
     * 
     * @return refType
     **/
    @ApiModelProperty(example = "null", required = true, value = "Transaction type, different type of transaction will populate different fields in `extra_info`")
    public RefTypeEnum getRefType() {
        return refType;
    }

    public void setRefType(RefTypeEnum refType) {
        this.refType = refType;
    }

    public CharacterWalletJournalResponse secondPartyId(Integer secondPartyId) {
        this.secondPartyId = secondPartyId;
        return this;
    }

    /**
     * second_party_id integer
     * 
     * @return secondPartyId
     **/
    @ApiModelProperty(example = "null", value = "second_party_id integer")
    public Integer getSecondPartyId() {
        return secondPartyId;
    }

    public void setSecondPartyId(Integer secondPartyId) {
        this.secondPartyId = secondPartyId;
    }

    public CharacterWalletJournalResponse secondPartyType(SecondPartyTypeEnum secondPartyType) {
        this.secondPartyType = secondPartyType;
        return this;
    }

    /**
     * second_party_type string
     * 
     * @return secondPartyType
     **/
    @ApiModelProperty(example = "null", value = "second_party_type string")
    public SecondPartyTypeEnum getSecondPartyType() {
        return secondPartyType;
    }

    public void setSecondPartyType(SecondPartyTypeEnum secondPartyType) {
        this.secondPartyType = secondPartyType;
    }

    public CharacterWalletJournalResponse tax(Float tax) {
        this.tax = tax;
        return this;
    }

    /**
     * Tax amount received for tax related transactions
     * 
     * @return tax
     **/
    @ApiModelProperty(example = "null", value = "Tax amount received for tax related transactions")
    public Float getTax() {
        return tax;
    }

    public void setTax(Float tax) {
        this.tax = tax;
    }

    public CharacterWalletJournalResponse taxRecieverId(Integer taxRecieverId) {
        this.taxRecieverId = taxRecieverId;
        return this;
    }

    /**
     * the corporation ID receiving any tax paid
     * 
     * @return taxRecieverId
     **/
    @ApiModelProperty(example = "null", value = "the corporation ID receiving any tax paid")
    public Integer getTaxRecieverId() {
        return taxRecieverId;
    }

    public void setTaxRecieverId(Integer taxRecieverId) {
        this.taxRecieverId = taxRecieverId;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CharacterWalletJournalResponse characterWalletJournalResponse = (CharacterWalletJournalResponse) o;
        return Objects.equals(this.amount, characterWalletJournalResponse.amount)
                && Objects.equals(this.balance, characterWalletJournalResponse.balance)
                && Objects.equals(this.date, characterWalletJournalResponse.date)
                && Objects.equals(this.extraInfo, characterWalletJournalResponse.extraInfo)
                && Objects.equals(this.firstPartyId, characterWalletJournalResponse.firstPartyId)
                && Objects.equals(this.firstPartyType, characterWalletJournalResponse.firstPartyType)
                && Objects.equals(this.reason, characterWalletJournalResponse.reason)
                && Objects.equals(this.refId, characterWalletJournalResponse.refId)
                && Objects.equals(this.refType, characterWalletJournalResponse.refType)
                && Objects.equals(this.secondPartyId, characterWalletJournalResponse.secondPartyId)
                && Objects.equals(this.secondPartyType, characterWalletJournalResponse.secondPartyType)
                && Objects.equals(this.tax, characterWalletJournalResponse.tax)
                && Objects.equals(this.taxRecieverId, characterWalletJournalResponse.taxRecieverId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amount, balance, date, extraInfo, firstPartyId, firstPartyType, reason, refId, refType,
                secondPartyId, secondPartyType, tax, taxRecieverId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacterWalletJournalResponse {\n");

        sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
        sb.append("    balance: ").append(toIndentedString(balance)).append("\n");
        sb.append("    date: ").append(toIndentedString(date)).append("\n");
        sb.append("    extraInfo: ").append(toIndentedString(extraInfo)).append("\n");
        sb.append("    firstPartyId: ").append(toIndentedString(firstPartyId)).append("\n");
        sb.append("    firstPartyType: ").append(toIndentedString(firstPartyType)).append("\n");
        sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
        sb.append("    refId: ").append(toIndentedString(refId)).append("\n");
        sb.append("    refType: ").append(toIndentedString(refType)).append("\n");
        sb.append("    secondPartyId: ").append(toIndentedString(secondPartyId)).append("\n");
        sb.append("    secondPartyType: ").append(toIndentedString(secondPartyType)).append("\n");
        sb.append("    tax: ").append(toIndentedString(tax)).append("\n");
        sb.append("    taxRecieverId: ").append(toIndentedString(taxRecieverId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
