/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="The defending corporation or alliance that declared this war, only contains either corporation_id or alliance_id")
public class Defender
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="alliance_id")
    private Integer allianceId = null;
    @JsonProperty(value="corporation_id")
    private Integer corporationId = null;
    @JsonProperty(value="isk_destroyed")
    private Float iskDestroyed = null;
    @JsonProperty(value="ships_killed")
    private Integer shipsKilled = null;

    public Defender allianceId(Integer n) {
        this.allianceId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="Alliance ID if and only if the defender is an alliance")
    public Integer getAllianceId() {
        return this.allianceId;
    }

    public void setAllianceId(Integer n) {
        this.allianceId = n;
    }

    public Defender corporationId(Integer n) {
        this.corporationId = n;
        return this;
    }

    @ApiModelProperty(example="null", value="Corporation ID if and only if the defender is a corporation")
    public Integer getCorporationId() {
        return this.corporationId;
    }

    public void setCorporationId(Integer n) {
        this.corporationId = n;
    }

    public Defender iskDestroyed(Float f) {
        this.iskDestroyed = f;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ISK value of ships the defender has killed")
    public Float getIskDestroyed() {
        return this.iskDestroyed;
    }

    public void setIskDestroyed(Float f) {
        this.iskDestroyed = f;
    }

    public Defender shipsKilled(Integer n) {
        this.shipsKilled = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The number of ships the defender has killed")
    public Integer getShipsKilled() {
        return this.shipsKilled;
    }

    public void setShipsKilled(Integer n) {
        this.shipsKilled = n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Defender defender = (Defender)object;
        return Objects.equals(this.allianceId, defender.allianceId) && Objects.equals(this.corporationId, defender.corporationId) && Objects.equals(this.iskDestroyed, defender.iskDestroyed) && Objects.equals(this.shipsKilled, defender.shipsKilled);
    }

    public int hashCode() {
        return Objects.hash(this.allianceId, this.corporationId, this.iskDestroyed, this.shipsKilled);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class Defender {\n");
        stringBuilder.append("    allianceId: ").append(this.toIndentedString(this.allianceId)).append("\n");
        stringBuilder.append("    corporationId: ").append(this.toIndentedString(this.corporationId)).append("\n");
        stringBuilder.append("    iskDestroyed: ").append(this.toIndentedString(this.iskDestroyed)).append("\n");
        stringBuilder.append("    shipsKilled: ").append(this.toIndentedString(this.shipsKilled)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

