/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="200 ok object")
public class IncursionsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="constellation_id")
    private Integer constellationId = null;
    @JsonProperty(value="faction_id")
    private Integer factionId = null;
    @JsonProperty(value="has_boss")
    private Boolean hasBoss = null;
    @JsonProperty(value="infested_solar_systems")
    private List<Integer> infestedSolarSystems = new ArrayList<Integer>();
    @JsonProperty(value="influence")
    private Float influence = null;
    @JsonProperty(value="staging_solar_system_id")
    private Integer stagingSolarSystemId = null;
    @JsonProperty(value="state")
    private StateEnum state = null;
    @JsonProperty(value="type")
    private String type = null;

    public IncursionsResponse constellationId(Integer n) {
        this.constellationId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The constellation id in which this incursion takes place")
    public Integer getConstellationId() {
        return this.constellationId;
    }

    public void setConstellationId(Integer n) {
        this.constellationId = n;
    }

    public IncursionsResponse factionId(Integer n) {
        this.factionId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The attacking faction's id")
    public Integer getFactionId() {
        return this.factionId;
    }

    public void setFactionId(Integer n) {
        this.factionId = n;
    }

    public IncursionsResponse hasBoss(Boolean bl) {
        this.hasBoss = bl;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether the final encounter has boss or not")
    public Boolean getHasBoss() {
        return this.hasBoss;
    }

    public void setHasBoss(Boolean bl) {
        this.hasBoss = bl;
    }

    public IncursionsResponse infestedSolarSystems(List<Integer> list) {
        this.infestedSolarSystems = list;
        return this;
    }

    public IncursionsResponse addInfestedSolarSystemsItem(Integer n) {
        this.infestedSolarSystems.add(n);
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A list of infested solar system ids that are a part of this incursion")
    public List<Integer> getInfestedSolarSystems() {
        return this.infestedSolarSystems;
    }

    public void setInfestedSolarSystems(List<Integer> list) {
        this.infestedSolarSystems = list;
    }

    public IncursionsResponse influence(Float f) {
        this.influence = f;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Influence of this incursion as a float from 0 to 1")
    public Float getInfluence() {
        return this.influence;
    }

    public void setInfluence(Float f) {
        this.influence = f;
    }

    public IncursionsResponse stagingSolarSystemId(Integer n) {
        this.stagingSolarSystemId = n;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Staging solar system for this incursion")
    public Integer getStagingSolarSystemId() {
        return this.stagingSolarSystemId;
    }

    public void setStagingSolarSystemId(Integer n) {
        this.stagingSolarSystemId = n;
    }

    public IncursionsResponse state(StateEnum stateEnum) {
        this.state = stateEnum;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The state of this incursion")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum stateEnum) {
        this.state = stateEnum;
    }

    public IncursionsResponse type(String string) {
        this.type = string;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of this incursion")
    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IncursionsResponse incursionsResponse = (IncursionsResponse)object;
        return Objects.equals(this.constellationId, incursionsResponse.constellationId) && Objects.equals(this.factionId, incursionsResponse.factionId) && Objects.equals(this.hasBoss, incursionsResponse.hasBoss) && Objects.equals(this.infestedSolarSystems, incursionsResponse.infestedSolarSystems) && Objects.equals(this.influence, incursionsResponse.influence) && Objects.equals(this.stagingSolarSystemId, incursionsResponse.stagingSolarSystemId) && Objects.equals((Object)this.state, (Object)incursionsResponse.state) && Objects.equals(this.type, incursionsResponse.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.constellationId, this.factionId, this.hasBoss, this.infestedSolarSystems, this.influence, this.stagingSolarSystemId, this.state, this.type});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class IncursionsResponse {\n");
        stringBuilder.append("    constellationId: ").append(this.toIndentedString(this.constellationId)).append("\n");
        stringBuilder.append("    factionId: ").append(this.toIndentedString(this.factionId)).append("\n");
        stringBuilder.append("    hasBoss: ").append(this.toIndentedString(this.hasBoss)).append("\n");
        stringBuilder.append("    infestedSolarSystems: ").append(this.toIndentedString(this.infestedSolarSystems)).append("\n");
        stringBuilder.append("    influence: ").append(this.toIndentedString(this.influence)).append("\n");
        stringBuilder.append("    stagingSolarSystemId: ").append(this.toIndentedString(this.stagingSolarSystemId)).append("\n");
        stringBuilder.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        stringBuilder.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        WITHDRAWING("withdrawing"),
        MOBILIZING("mobilizing"),
        ESTABLISHED("established");

        private String value;

        private StateEnum(String string2) {
            this.value = string2;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String string) {
            for (StateEnum stateEnum : StateEnum.values()) {
                if (!String.valueOf(stateEnum.value).equals(string)) continue;
                return stateEnum;
            }
            return null;
        }
    }
}

