/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class CorporationResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("alliance_id")
    private Integer allianceId = null;

    @JsonProperty("ceo_id")
    private Integer ceoId = null;

    @JsonProperty("corporation_name")
    private String corporationName = null;

    @JsonProperty("member_count")
    private Integer memberCount = null;

    @JsonProperty("ticker")
    private String ticker = null;

    public CorporationResponse allianceId(Integer allianceId) {
        this.allianceId = allianceId;
        return this;
    }

    /**
     * id of alliance that corporation is a member of, if any
     * 
     * @return allianceId
     **/
    @ApiModelProperty(example = "null", value = "id of alliance that corporation is a member of, if any")
    public Integer getAllianceId() {
        return allianceId;
    }

    public void setAllianceId(Integer allianceId) {
        this.allianceId = allianceId;
    }

    public CorporationResponse ceoId(Integer ceoId) {
        this.ceoId = ceoId;
        return this;
    }

    /**
     * ceo_id integer
     * 
     * @return ceoId
     **/
    @ApiModelProperty(example = "null", required = true, value = "ceo_id integer")
    public Integer getCeoId() {
        return ceoId;
    }

    public void setCeoId(Integer ceoId) {
        this.ceoId = ceoId;
    }

    public CorporationResponse corporationName(String corporationName) {
        this.corporationName = corporationName;
        return this;
    }

    /**
     * the full name of the corporation
     * 
     * @return corporationName
     **/
    @ApiModelProperty(example = "null", required = true, value = "the full name of the corporation")
    public String getCorporationName() {
        return corporationName;
    }

    public void setCorporationName(String corporationName) {
        this.corporationName = corporationName;
    }

    public CorporationResponse memberCount(Integer memberCount) {
        this.memberCount = memberCount;
        return this;
    }

    /**
     * member_count integer
     * 
     * @return memberCount
     **/
    @ApiModelProperty(example = "null", required = true, value = "member_count integer")
    public Integer getMemberCount() {
        return memberCount;
    }

    public void setMemberCount(Integer memberCount) {
        this.memberCount = memberCount;
    }

    public CorporationResponse ticker(String ticker) {
        this.ticker = ticker;
        return this;
    }

    /**
     * the short name of the corporation
     * 
     * @return ticker
     **/
    @ApiModelProperty(example = "null", required = true, value = "the short name of the corporation")
    public String getTicker() {
        return ticker;
    }

    public void setTicker(String ticker) {
        this.ticker = ticker;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CorporationResponse corporationResponse = (CorporationResponse) o;
        return Objects.equals(this.allianceId, corporationResponse.allianceId)
                && Objects.equals(this.ceoId, corporationResponse.ceoId)
                && Objects.equals(this.corporationName, corporationResponse.corporationName)
                && Objects.equals(this.memberCount, corporationResponse.memberCount)
                && Objects.equals(this.ticker, corporationResponse.ticker);
    }

    @Override
    public int hashCode() {
        return Objects.hash(allianceId, ceoId, corporationName, memberCount, ticker);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporationResponse {\n");

        sb.append("    allianceId: ").append(toIndentedString(allianceId)).append("\n");
        sb.append("    ceoId: ").append(toIndentedString(ceoId)).append("\n");
        sb.append("    corporationName: ").append(toIndentedString(corporationName)).append("\n");
        sb.append("    memberCount: ").append(toIndentedString(memberCount)).append("\n");
        sb.append("    ticker: ").append(toIndentedString(ticker)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
