/*
 * Decompiled with CFR 0.152.
 */
package net.tribe7.common.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.tribe7.common.annotations.Beta;
import net.tribe7.common.base.Function;
import net.tribe7.common.base.Objects;
import net.tribe7.common.base.Preconditions;
import net.tribe7.common.base.Predicate;
import net.tribe7.common.base.Predicates;
import net.tribe7.common.base.Stopwatch;
import net.tribe7.common.collect.Collections2;
import net.tribe7.common.collect.ImmutableList;
import net.tribe7.common.collect.ImmutableMap;
import net.tribe7.common.collect.ImmutableMultimap;
import net.tribe7.common.collect.Lists;
import net.tribe7.common.collect.Maps;
import net.tribe7.common.collect.Ordering;
import net.tribe7.common.util.concurrent.AbstractService;
import net.tribe7.common.util.concurrent.ExecutionQueue;
import net.tribe7.common.util.concurrent.ListeningExecutorService;
import net.tribe7.common.util.concurrent.Monitor;
import net.tribe7.common.util.concurrent.MoreExecutors;
import net.tribe7.common.util.concurrent.Service;

@Singleton
@Beta
public final class ServiceManager {
    private static final Logger logger = Logger.getLogger(ServiceManager.class.getName());
    private final ServiceManagerState state;
    private final ImmutableMap<Service, ServiceListener> services;

    public ServiceManager(Iterable<? extends Service> services) {
        ImmutableList copy = ImmutableList.copyOf(services);
        if (copy.isEmpty()) {
            logger.log(Level.WARNING, "ServiceManager configured with no services.  Is your application configured properly?", new EmptyServiceManagerWarning());
            copy = ImmutableList.of((Object)new NoOpService());
        }
        this.state = new ServiceManagerState(copy.size());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ListeningExecutorService executor = MoreExecutors.sameThreadExecutor();
        for (Service service : copy) {
            ServiceListener listener = new ServiceListener(service, this.state);
            service.addListener(listener, executor);
            Preconditions.checkArgument((service.state() == Service.State.NEW ? 1 : 0) != 0, (String)"Can only manage NEW services, %s", (Object[])new Object[]{service});
            builder.put((Object)service, (Object)listener);
        }
        this.services = builder.build();
    }

    @Inject
    ServiceManager(Set<Service> services) {
        this((Iterable<? extends Service>)services);
    }

    public void addListener(Listener listener, Executor executor) {
        this.state.addListener(listener, executor);
    }

    public void addListener(Listener listener) {
        this.state.addListener(listener, MoreExecutors.sameThreadExecutor());
    }

    public ServiceManager startAsync() {
        for (Map.Entry entry : this.services.entrySet()) {
            Service service = (Service)entry.getKey();
            Service.State state = service.state();
            Preconditions.checkState((state == Service.State.NEW ? 1 : 0) != 0, (String)"Service %s is %s, cannot start it.", (Object[])new Object[]{service, state});
        }
        for (ServiceListener service : this.services.values()) {
            try {
                service.start();
            }
            catch (IllegalStateException e) {
                logger.log(Level.WARNING, "Unable to start Service " + service.service, e);
            }
        }
        return this;
    }

    public void awaitHealthy() {
        this.state.awaitHealthy();
        Preconditions.checkState((boolean)this.isHealthy(), (Object)"Expected to be healthy after starting");
    }

    public void awaitHealthy(long timeout, TimeUnit unit) throws TimeoutException {
        if (!this.state.awaitHealthy(timeout, unit)) {
            throw new TimeoutException("Timeout waiting for the services to become healthy.");
        }
        Preconditions.checkState((boolean)this.isHealthy(), (Object)"Expected to be healthy after starting");
    }

    public ServiceManager stopAsync() {
        for (Service service : this.services.keySet()) {
            service.stop();
        }
        return this;
    }

    public void awaitStopped() {
        this.state.awaitStopped();
    }

    public void awaitStopped(long timeout, TimeUnit unit) throws TimeoutException {
        if (!this.state.awaitStopped(timeout, unit)) {
            throw new TimeoutException("Timeout waiting for the services to stop.");
        }
    }

    public boolean isHealthy() {
        for (Service service : this.services.keySet()) {
            if (service.isRunning()) continue;
            return false;
        }
        return true;
    }

    public ImmutableMultimap<Service.State, Service> servicesByState() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Service service : this.services.keySet()) {
            if (service instanceof NoOpService) continue;
            builder.put((Object)service.state(), (Object)service);
        }
        return builder.build();
    }

    public ImmutableMap<Service, Long> startupTimes() {
        ArrayList loadTimes = Lists.newArrayListWithCapacity((int)this.services.size());
        for (Map.Entry entry : this.services.entrySet()) {
            Service service = (Service)entry.getKey();
            Service.State state = service.state();
            if (!(state != Service.State.NEW & state != Service.State.STARTING & !(service instanceof NoOpService))) continue;
            loadTimes.add(Maps.immutableEntry((Object)service, (Object)((ServiceListener)entry.getValue()).startupTimeMillis()));
        }
        Collections.sort(loadTimes, Ordering.natural().onResultOf((Function)new Function<Map.Entry<Service, Long>, Long>(){

            public Long apply(Map.Entry<Service, Long> input) {
                return input.getValue();
            }
        }));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : loadTimes) {
            builder.put(entry);
        }
        return builder.build();
    }

    public String toString() {
        return Objects.toStringHelper(ServiceManager.class).add("services", (Object)Collections2.filter((Collection)this.services.keySet(), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(NoOpService.class)))).toString();
    }

    private static final class EmptyServiceManagerWarning
    extends Throwable {
        private EmptyServiceManagerWarning() {
        }
    }

    private static final class NoOpService
    extends AbstractService {
        private NoOpService() {
        }

        @Override
        protected void doStart() {
            this.notifyStarted();
        }

        @Override
        protected void doStop() {
            this.notifyStopped();
        }
    }

    @Immutable
    private static final class ListenerExecutorPair {
        final Listener listener;
        final Executor executor;

        ListenerExecutorPair(Listener listener, Executor executor) {
            this.listener = listener;
            this.executor = executor;
        }
    }

    private static final class ServiceListener
    extends Service.Listener {
        @GuardedBy(value="watch")
        final Stopwatch watch = Stopwatch.createUnstarted();
        final Service service;
        final ServiceManagerState state;

        ServiceListener(Service service, ServiceManagerState state) {
            this.service = service;
            this.state = state;
        }

        @Override
        public void starting() {
            this.startTimer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void running() {
            this.state.monitor.enter();
            try {
                this.finishedStarting(true);
            }
            finally {
                this.state.monitor.leave();
                this.state.executeListeners();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopping(Service.State from) {
            if (from == Service.State.STARTING) {
                this.state.monitor.enter();
                try {
                    this.finishedStarting(false);
                }
                finally {
                    this.state.monitor.leave();
                    this.state.executeListeners();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void terminated(Service.State from) {
            if (!(this.service instanceof NoOpService)) {
                logger.log(Level.FINE, "Service {0} has terminated. Previous state was: {1}", new Object[]{this.service, from});
            }
            this.state.monitor.enter();
            try {
                if (from == Service.State.NEW) {
                    this.startTimer();
                    this.finishedStarting(false);
                }
                this.state.serviceTerminated(this.service);
            }
            finally {
                this.state.monitor.leave();
                this.state.executeListeners();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Service.State from, Throwable failure) {
            logger.log(Level.SEVERE, "Service " + this.service + " has failed in the " + (Object)((Object)from) + " state.", failure);
            this.state.monitor.enter();
            try {
                if (from == Service.State.STARTING) {
                    this.finishedStarting(false);
                }
                this.state.serviceFailed(this.service);
            }
            finally {
                this.state.monitor.leave();
                this.state.executeListeners();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GuardedBy(value="monitor")
        void finishedStarting(boolean currentlyHealthy) {
            Stopwatch stopwatch = this.watch;
            synchronized (stopwatch) {
                this.watch.stop();
                if (!(this.service instanceof NoOpService)) {
                    logger.log(Level.FINE, "Started {0} in {1} ms.", new Object[]{this.service, this.startupTimeMillis()});
                }
            }
            this.state.serviceFinishedStarting(this.service, currentlyHealthy);
        }

        void start() {
            this.startTimer();
            this.service.startAsync();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startTimer() {
            Stopwatch stopwatch = this.watch;
            synchronized (stopwatch) {
                if (!this.watch.isRunning()) {
                    this.watch.start();
                    if (!(this.service instanceof NoOpService)) {
                        logger.log(Level.FINE, "Starting {0}.", this.service);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long startupTimeMillis() {
            Stopwatch stopwatch = this.watch;
            synchronized (stopwatch) {
                return this.watch.elapsed(TimeUnit.MILLISECONDS);
            }
        }
    }

    private static final class ServiceManagerState {
        final Monitor monitor = new Monitor();
        final int numberOfServices;
        @GuardedBy(value="monitor")
        int unstartedServices;
        @GuardedBy(value="monitor")
        int unstoppedServices;
        final Monitor.Guard awaitHealthGuard = new Monitor.Guard(this.monitor){

            @Override
            public boolean isSatisfied() {
                return ServiceManagerState.this.unstartedServices == 0 | ServiceManagerState.this.unstoppedServices != ServiceManagerState.this.numberOfServices;
            }
        };
        final Monitor.Guard stoppedGuard = new Monitor.Guard(this.monitor){

            @Override
            public boolean isSatisfied() {
                return ServiceManagerState.this.unstoppedServices == 0;
            }
        };
        @GuardedBy(value="monitor")
        final List<ListenerExecutorPair> listeners = Lists.newArrayList();
        @GuardedBy(value="monitor")
        final ExecutionQueue queuedListeners = new ExecutionQueue();

        ServiceManagerState(int numberOfServices) {
            this.numberOfServices = numberOfServices;
            this.unstoppedServices = numberOfServices;
            this.unstartedServices = numberOfServices;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addListener(Listener listener, Executor executor) {
            Preconditions.checkNotNull((Object)listener, (Object)"listener");
            Preconditions.checkNotNull((Object)executor, (Object)"executor");
            this.monitor.enter();
            try {
                if (this.unstartedServices > 0 || this.unstoppedServices > 0) {
                    this.listeners.add(new ListenerExecutorPair(listener, executor));
                }
            }
            finally {
                this.monitor.leave();
            }
        }

        void awaitHealthy() {
            this.monitor.enterWhenUninterruptibly(this.awaitHealthGuard);
            this.monitor.leave();
        }

        boolean awaitHealthy(long timeout, TimeUnit unit) {
            if (this.monitor.enterWhenUninterruptibly(this.awaitHealthGuard, timeout, unit)) {
                this.monitor.leave();
                return true;
            }
            return false;
        }

        void awaitStopped() {
            this.monitor.enterWhenUninterruptibly(this.stoppedGuard);
            this.monitor.leave();
        }

        boolean awaitStopped(long timeout, TimeUnit unit) {
            if (this.monitor.enterWhenUninterruptibly(this.stoppedGuard, timeout, unit)) {
                this.monitor.leave();
                return true;
            }
            return false;
        }

        @GuardedBy(value="monitor")
        private void serviceFinishedStarting(Service service, boolean currentlyHealthy) {
            Preconditions.checkState((this.unstartedServices > 0 ? 1 : 0) != 0, (String)"All services should have already finished starting but %s just finished.", (Object[])new Object[]{service});
            --this.unstartedServices;
            if (currentlyHealthy && this.unstartedServices == 0 && this.unstoppedServices == this.numberOfServices) {
                for (final ListenerExecutorPair pair : this.listeners) {
                    this.queuedListeners.add(new Runnable(){

                        @Override
                        public void run() {
                            pair.listener.healthy();
                        }
                    }, pair.executor);
                }
            }
        }

        @GuardedBy(value="monitor")
        private void serviceTerminated(Service service) {
            this.serviceStopped(service);
        }

        @GuardedBy(value="monitor")
        private void serviceFailed(final Service service) {
            for (final ListenerExecutorPair pair : this.listeners) {
                this.queuedListeners.add(new Runnable(){

                    @Override
                    public void run() {
                        pair.listener.failure(service);
                    }
                }, pair.executor);
            }
            this.serviceStopped(service);
        }

        @GuardedBy(value="monitor")
        private void serviceStopped(Service service) {
            Preconditions.checkState((this.unstoppedServices > 0 ? 1 : 0) != 0, (String)"All services should have already stopped but %s just stopped.", (Object[])new Object[]{service});
            --this.unstoppedServices;
            if (this.unstoppedServices == 0) {
                Preconditions.checkState((this.unstartedServices == 0 ? 1 : 0) != 0, (String)"All services are stopped but %d services haven't finished starting", (Object[])new Object[]{this.unstartedServices});
                for (final ListenerExecutorPair pair : this.listeners) {
                    this.queuedListeners.add(new Runnable(){

                        @Override
                        public void run() {
                            pair.listener.stopped();
                        }
                    }, pair.executor);
                }
                this.listeners.clear();
            }
        }

        private void executeListeners() {
            Preconditions.checkState((!this.monitor.isOccupiedByCurrentThread() ? 1 : 0) != 0, (Object)"It is incorrect to execute listeners with the monitor held.");
            this.queuedListeners.execute();
        }
    }

    @Beta
    public static abstract class Listener {
        public void healthy() {
        }

        public void stopped() {
        }

        public void failure(Service service) {
        }
    }
}

