/*
 * Decompiled with CFR 0.152.
 */
package net.tribe7.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import net.tribe7.common.annotations.Beta;
import net.tribe7.common.base.Objects;
import net.tribe7.common.base.Preconditions;
import net.tribe7.common.collect.Lists;
import net.tribe7.common.io.ByteSource;
import net.tribe7.common.io.ByteStreams;
import net.tribe7.common.io.CharSource;
import net.tribe7.common.io.CharStreams;
import net.tribe7.common.io.InputSupplier;
import net.tribe7.common.io.LineProcessor;

@Beta
public final class Resources {
    private Resources() {
    }

    public static InputSupplier<InputStream> newInputStreamSupplier(URL url) {
        return ByteStreams.asInputSupplier(Resources.asByteSource(url));
    }

    public static ByteSource asByteSource(URL url) {
        return new UrlByteSource(url);
    }

    public static InputSupplier<InputStreamReader> newReaderSupplier(URL url, Charset charset) {
        return CharStreams.asInputSupplier(Resources.asCharSource(url, charset));
    }

    public static CharSource asCharSource(URL url, Charset charset) {
        return Resources.asByteSource(url).asCharSource(charset);
    }

    public static byte[] toByteArray(URL url) throws IOException {
        return Resources.asByteSource(url).read();
    }

    public static String toString(URL url, Charset charset) throws IOException {
        return Resources.asCharSource(url, charset).read();
    }

    public static <T> T readLines(URL url, Charset charset, LineProcessor<T> callback) throws IOException {
        return CharStreams.readLines(Resources.newReaderSupplier(url, charset), callback);
    }

    public static List<String> readLines(URL url, Charset charset) throws IOException {
        return Resources.readLines(url, charset, new LineProcessor<List<String>>(){
            final List<String> result = Lists.newArrayList();

            @Override
            public boolean processLine(String line) {
                this.result.add(line);
                return true;
            }

            @Override
            public List<String> getResult() {
                return this.result;
            }
        });
    }

    public static void copy(URL from, OutputStream to) throws IOException {
        Resources.asByteSource(from).copyTo(to);
    }

    public static URL getResource(String resourceName) {
        ClassLoader loader = (ClassLoader)Objects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)Resources.class.getClassLoader());
        URL url = loader.getResource(resourceName);
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (String)"resource %s not found.", (Object[])new Object[]{resourceName});
        return url;
    }

    public static URL getResource(Class<?> contextClass, String resourceName) {
        URL url = contextClass.getResource(resourceName);
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (String)"resource %s relative to %s not found.", (Object[])new Object[]{resourceName, contextClass.getName()});
        return url;
    }

    private static final class UrlByteSource
    extends ByteSource {
        private final URL url;

        private UrlByteSource(URL url) {
            this.url = (URL)Preconditions.checkNotNull((Object)url);
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.url.openStream();
        }

        public String toString() {
            return "Resources.asByteSource(" + this.url + ")";
        }
    }
}

