/*
 * Decompiled with CFR 0.152.
 */
package net.tribe7.common.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import net.tribe7.common.base.Preconditions;
import net.tribe7.common.io.CharStreams;
import net.tribe7.common.io.Closer;

public abstract class CharSink {
    public abstract Writer openStream() throws IOException;

    public BufferedWriter openBufferedStream() throws IOException {
        Writer writer = this.openStream();
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public void write(CharSequence charSequence) throws IOException {
        Preconditions.checkNotNull((Object)charSequence);
        Closer closer = Closer.create();
        try {
            Writer out = closer.register(this.openStream());
            out.append(charSequence);
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public void writeLines(Iterable<? extends CharSequence> lines) throws IOException {
        this.writeLines(lines, System.getProperty("line.separator"));
    }

    public void writeLines(Iterable<? extends CharSequence> lines, String lineSeparator) throws IOException {
        Preconditions.checkNotNull(lines);
        Preconditions.checkNotNull((Object)lineSeparator);
        Closer closer = Closer.create();
        try {
            BufferedWriter out = closer.register(this.openBufferedStream());
            for (CharSequence charSequence : lines) {
                out.append(charSequence).append(lineSeparator);
            }
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    public long writeFrom(Readable readable) throws IOException {
        Preconditions.checkNotNull((Object)readable);
        Closer closer = Closer.create();
        try {
            Writer out = closer.register(this.openStream());
            long l = CharStreams.copy(readable, (Appendable)out);
            return l;
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }
}

