/*
 * Decompiled with CFR 0.152.
 */
package net.tribe7.common.hash;

import java.io.Serializable;
import java.util.zip.Checksum;
import net.tribe7.common.base.Preconditions;
import net.tribe7.common.base.Supplier;
import net.tribe7.common.hash.AbstractByteHasher;
import net.tribe7.common.hash.AbstractStreamingHashFunction;
import net.tribe7.common.hash.HashCode;
import net.tribe7.common.hash.HashCodes;
import net.tribe7.common.hash.Hasher;

final class ChecksumHashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private final Supplier<? extends Checksum> checksumSupplier;
    private final int bits;
    private final String toString;
    private static final long serialVersionUID = 0L;

    ChecksumHashFunction(Supplier<? extends Checksum> checksumSupplier, int bits, String toString) {
        this.checksumSupplier = (Supplier)Preconditions.checkNotNull(checksumSupplier);
        Preconditions.checkArgument((bits == 32 || bits == 64 ? 1 : 0) != 0, (String)"bits (%s) must be either 32 or 64", (Object[])new Object[]{bits});
        this.bits = bits;
        this.toString = (String)Preconditions.checkNotNull((Object)toString);
    }

    @Override
    public int bits() {
        return this.bits;
    }

    @Override
    public Hasher newHasher() {
        return new ChecksumHasher((Checksum)this.checksumSupplier.get());
    }

    public String toString() {
        return this.toString;
    }

    private final class ChecksumHasher
    extends AbstractByteHasher {
        private final Checksum checksum;

        private ChecksumHasher(Checksum checksum) {
            this.checksum = (Checksum)Preconditions.checkNotNull((Object)checksum);
        }

        @Override
        protected void update(byte b) {
            this.checksum.update(b);
        }

        @Override
        protected void update(byte[] bytes, int off, int len) {
            this.checksum.update(bytes, off, len);
        }

        @Override
        public HashCode hash() {
            long value = this.checksum.getValue();
            if (ChecksumHashFunction.this.bits == 32) {
                return HashCodes.fromInt((int)value);
            }
            return HashCodes.fromLong(value);
        }
    }
}

