/*
 * Decompiled with CFR 0.152.
 */
package net.tribe7.common.eventbus;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.tribe7.common.annotations.Beta;
import net.tribe7.common.annotations.VisibleForTesting;
import net.tribe7.common.base.Preconditions;
import net.tribe7.common.base.Throwables;
import net.tribe7.common.cache.CacheBuilder;
import net.tribe7.common.cache.CacheLoader;
import net.tribe7.common.cache.LoadingCache;
import net.tribe7.common.collect.HashMultimap;
import net.tribe7.common.collect.Multimap;
import net.tribe7.common.collect.SetMultimap;
import net.tribe7.common.eventbus.AnnotatedHandlerFinder;
import net.tribe7.common.eventbus.DeadEvent;
import net.tribe7.common.eventbus.EventHandler;
import net.tribe7.common.eventbus.HandlerFindingStrategy;
import net.tribe7.common.reflect.TypeToken;
import net.tribe7.common.util.concurrent.UncheckedExecutionException;

@Beta
public class EventBus {
    private static final LoadingCache<Class<?>, Set<Class<?>>> flattenHierarchyCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, Set<Class<?>>>(){

        public Set<Class<?>> load(Class<?> concreteClass) {
            return TypeToken.of(concreteClass).getTypes().rawTypes();
        }
    });
    private final SetMultimap<Class<?>, EventHandler> handlersByType = HashMultimap.create();
    private final ReadWriteLock handlersByTypeLock = new ReentrantReadWriteLock();
    private final Logger logger;
    private final HandlerFindingStrategy finder = new AnnotatedHandlerFinder();
    private final ThreadLocal<Queue<EventWithHandler>> eventsToDispatch = new ThreadLocal<Queue<EventWithHandler>>(){

        @Override
        protected Queue<EventWithHandler> initialValue() {
            return new LinkedList<EventWithHandler>();
        }
    };
    private final ThreadLocal<Boolean> isDispatching = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public EventBus() {
        this("default");
    }

    public EventBus(String identifier) {
        this.logger = Logger.getLogger(EventBus.class.getName() + "." + (String)Preconditions.checkNotNull((Object)identifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Object object) {
        Multimap<Class<?>, EventHandler> methodsInListener = this.finder.findAllHandlers(object);
        this.handlersByTypeLock.writeLock().lock();
        try {
            this.handlersByType.putAll(methodsInListener);
        }
        finally {
            this.handlersByTypeLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Object object) {
        Multimap<Class<?>, EventHandler> methodsInListener = this.finder.findAllHandlers(object);
        for (Map.Entry entry : methodsInListener.asMap().entrySet()) {
            Class eventType = (Class)entry.getKey();
            Collection eventMethodsInListener = (Collection)entry.getValue();
            this.handlersByTypeLock.writeLock().lock();
            try {
                Set currentHandlers = this.handlersByType.get((Object)eventType);
                if (!currentHandlers.containsAll(eventMethodsInListener)) {
                    throw new IllegalArgumentException("missing event handler for an annotated method. Is " + object + " registered?");
                }
                currentHandlers.removeAll(eventMethodsInListener);
            }
            finally {
                this.handlersByTypeLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Object event) {
        Set<Class<?>> dispatchTypes = this.flattenHierarchy(event.getClass());
        boolean dispatched = false;
        for (Class<?> eventType : dispatchTypes) {
            this.handlersByTypeLock.readLock().lock();
            try {
                Set wrappers = this.handlersByType.get(eventType);
                if (wrappers.isEmpty()) continue;
                dispatched = true;
                for (EventHandler wrapper : wrappers) {
                    this.enqueueEvent(event, wrapper);
                }
            }
            finally {
                this.handlersByTypeLock.readLock().unlock();
            }
        }
        if (!dispatched && !(event instanceof DeadEvent)) {
            this.post(new DeadEvent(this, event));
        }
        this.dispatchQueuedEvents();
    }

    void enqueueEvent(Object event, EventHandler handler) {
        this.eventsToDispatch.get().offer(new EventWithHandler(event, handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchQueuedEvents() {
        if (this.isDispatching.get().booleanValue()) {
            return;
        }
        this.isDispatching.set(true);
        try {
            EventWithHandler eventWithHandler;
            Queue<EventWithHandler> events = this.eventsToDispatch.get();
            while ((eventWithHandler = events.poll()) != null) {
                this.dispatch(eventWithHandler.event, eventWithHandler.handler);
            }
        }
        finally {
            this.isDispatching.remove();
            this.eventsToDispatch.remove();
        }
    }

    void dispatch(Object event, EventHandler wrapper) {
        try {
            wrapper.handleEvent(event);
        }
        catch (InvocationTargetException e) {
            this.logger.log(Level.SEVERE, "Could not dispatch event: " + event + " to handler " + wrapper, e);
        }
    }

    @VisibleForTesting
    Set<Class<?>> flattenHierarchy(Class<?> concreteClass) {
        try {
            return (Set)flattenHierarchyCache.getUnchecked(concreteClass);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    static class EventWithHandler {
        final Object event;
        final EventHandler handler;

        public EventWithHandler(Object event, EventHandler handler) {
            this.event = Preconditions.checkNotNull((Object)event);
            this.handler = (EventHandler)Preconditions.checkNotNull((Object)handler);
        }
    }
}

