/*
 * Decompiled with CFR 0.152.
 */
package net.tribe7.common.eventbus;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.tribe7.common.base.Objects;
import net.tribe7.common.base.Throwables;
import net.tribe7.common.cache.CacheBuilder;
import net.tribe7.common.cache.CacheLoader;
import net.tribe7.common.cache.LoadingCache;
import net.tribe7.common.collect.HashMultimap;
import net.tribe7.common.collect.ImmutableList;
import net.tribe7.common.collect.Maps;
import net.tribe7.common.collect.Multimap;
import net.tribe7.common.eventbus.AllowConcurrentEvents;
import net.tribe7.common.eventbus.EventHandler;
import net.tribe7.common.eventbus.HandlerFindingStrategy;
import net.tribe7.common.eventbus.Subscribe;
import net.tribe7.common.eventbus.SynchronizedEventHandler;
import net.tribe7.common.reflect.TypeToken;
import net.tribe7.common.util.concurrent.UncheckedExecutionException;

class AnnotatedHandlerFinder
implements HandlerFindingStrategy {
    private static final LoadingCache<Class<?>, ImmutableList<Method>> handlerMethodsCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ImmutableList<Method>>(){

        public ImmutableList<Method> load(Class<?> concreteClass) throws Exception {
            return AnnotatedHandlerFinder.getAnnotatedMethodsInternal(concreteClass);
        }
    });

    AnnotatedHandlerFinder() {
    }

    @Override
    public Multimap<Class<?>, EventHandler> findAllHandlers(Object listener) {
        HashMultimap methodsInListener = HashMultimap.create();
        Class<?> clazz = listener.getClass();
        for (Method method : AnnotatedHandlerFinder.getAnnotatedMethods(clazz)) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> eventType = parameterTypes[0];
            EventHandler handler = AnnotatedHandlerFinder.makeHandler(listener, method);
            methodsInListener.put(eventType, (Object)handler);
        }
        return methodsInListener;
    }

    private static ImmutableList<Method> getAnnotatedMethods(Class<?> clazz) {
        try {
            return (ImmutableList)handlerMethodsCache.getUnchecked(clazz);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private static ImmutableList<Method> getAnnotatedMethodsInternal(Class<?> clazz) {
        Set supers = TypeToken.of(clazz).getTypes().rawTypes();
        HashMap identifiers = Maps.newHashMap();
        for (Class superClazz : supers) {
            for (Method superClazzMethod : superClazz.getMethods()) {
                if (!superClazzMethod.isAnnotationPresent(Subscribe.class)) continue;
                Class<?>[] parameterTypes = superClazzMethod.getParameterTypes();
                if (parameterTypes.length != 1) {
                    throw new IllegalArgumentException("Method " + superClazzMethod + " has @Subscribe annotation, but requires " + parameterTypes.length + " arguments.  Event handler methods must require a single argument.");
                }
                MethodIdentifier ident = new MethodIdentifier(superClazzMethod);
                if (identifiers.containsKey(ident)) continue;
                identifiers.put(ident, superClazzMethod);
            }
        }
        return ImmutableList.copyOf(identifiers.values());
    }

    private static EventHandler makeHandler(Object listener, Method method) {
        EventHandler wrapper = AnnotatedHandlerFinder.methodIsDeclaredThreadSafe(method) ? new EventHandler(listener, method) : new SynchronizedEventHandler(listener, method);
        return wrapper;
    }

    private static boolean methodIsDeclaredThreadSafe(Method method) {
        return method.getAnnotation(AllowConcurrentEvents.class) != null;
    }

    private static final class MethodIdentifier {
        private final String name;
        private final List<Class<?>> parameterTypes;

        MethodIdentifier(Method method) {
            this.name = method.getName();
            this.parameterTypes = Arrays.asList(method.getParameterTypes());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.parameterTypes});
        }

        public boolean equals(@Nullable Object o) {
            if (o instanceof MethodIdentifier) {
                MethodIdentifier ident = (MethodIdentifier)o;
                return this.name.equals(ident.name) && this.parameterTypes.equals(ident.parameterTypes);
            }
            return false;
        }
    }
}

