/*
 * Decompiled with CFR 0.152.
 */
package net.tribe7.common.eventbus;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.tribe7.common.base.Preconditions;

class EventHandler {
    private final Object target;
    private final Method method;

    EventHandler(Object target, Method method) {
        Preconditions.checkNotNull((Object)target, (Object)"EventHandler target cannot be null.");
        Preconditions.checkNotNull((Object)method, (Object)"EventHandler method cannot be null.");
        this.target = target;
        this.method = method;
        method.setAccessible(true);
    }

    public void handleEvent(Object event) throws InvocationTargetException {
        Preconditions.checkNotNull((Object)event);
        try {
            this.method.invoke(this.target, event);
        }
        catch (IllegalArgumentException e) {
            throw new Error("Method rejected target/argument: " + event, e);
        }
        catch (IllegalAccessException e) {
            throw new Error("Method became inaccessible: " + event, e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw e;
        }
    }

    public String toString() {
        return "[wrapper " + this.method + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        return (31 + this.method.hashCode()) * 31 + System.identityHashCode(this.target);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof EventHandler) {
            EventHandler that = (EventHandler)obj;
            return this.target == that.target && this.method.equals(that.method);
        }
        return false;
    }
}

