/*
 * Decompiled with CFR 0.152.
 */
package net.tribe7.common.eventbus;

import java.lang.reflect.Method;
import java.util.Set;
import net.tribe7.common.base.Throwables;
import net.tribe7.common.cache.CacheBuilder;
import net.tribe7.common.cache.CacheLoader;
import net.tribe7.common.cache.LoadingCache;
import net.tribe7.common.collect.HashMultimap;
import net.tribe7.common.collect.ImmutableList;
import net.tribe7.common.collect.Multimap;
import net.tribe7.common.eventbus.AllowConcurrentEvents;
import net.tribe7.common.eventbus.EventHandler;
import net.tribe7.common.eventbus.HandlerFindingStrategy;
import net.tribe7.common.eventbus.Subscribe;
import net.tribe7.common.eventbus.SynchronizedEventHandler;
import net.tribe7.common.reflect.TypeToken;
import net.tribe7.common.util.concurrent.UncheckedExecutionException;

class AnnotatedHandlerFinder
implements HandlerFindingStrategy {
    private static final LoadingCache<Class<?>, ImmutableList<Method>> handlerMethodsCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ImmutableList<Method>>(){

        public ImmutableList<Method> load(Class<?> concreteClass) throws Exception {
            return AnnotatedHandlerFinder.getAnnotatedMethodsInternal(concreteClass);
        }
    });

    AnnotatedHandlerFinder() {
    }

    @Override
    public Multimap<Class<?>, EventHandler> findAllHandlers(Object listener) {
        HashMultimap methodsInListener = HashMultimap.create();
        Class<?> clazz = listener.getClass();
        for (Method method : AnnotatedHandlerFinder.getAnnotatedMethods(clazz)) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> eventType = parameterTypes[0];
            EventHandler handler = AnnotatedHandlerFinder.makeHandler(listener, method);
            methodsInListener.put(eventType, (Object)handler);
        }
        return methodsInListener;
    }

    private static ImmutableList<Method> getAnnotatedMethods(Class<?> clazz) {
        try {
            return (ImmutableList)handlerMethodsCache.getUnchecked(clazz);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private static ImmutableList<Method> getAnnotatedMethodsInternal(Class<?> clazz) {
        Set supers = TypeToken.of(clazz).getTypes().rawTypes();
        ImmutableList.Builder result = ImmutableList.builder();
        block2: for (Method method : clazz.getMethods()) {
            for (Class c : supers) {
                try {
                    Method m = c.getMethod(method.getName(), method.getParameterTypes());
                    if (!m.isAnnotationPresent(Subscribe.class)) continue;
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length != 1) {
                        throw new IllegalArgumentException("Method " + method + " has @Subscribe annotation, but requires " + parameterTypes.length + " arguments.  Event handler methods must require a single argument.");
                    }
                    Class<?> eventType = parameterTypes[0];
                    result.add((Object)method);
                    continue block2;
                }
                catch (NoSuchMethodException ignored) {
                }
            }
        }
        return result.build();
    }

    private static EventHandler makeHandler(Object listener, Method method) {
        EventHandler wrapper = AnnotatedHandlerFinder.methodIsDeclaredThreadSafe(method) ? new EventHandler(listener, method) : new SynchronizedEventHandler(listener, method);
        return wrapper;
    }

    private static boolean methodIsDeclaredThreadSafe(Method method) {
        return method.getAnnotation(AllowConcurrentEvents.class) != null;
    }
}

