/*
 * Decompiled with CFR 0.152.
 */
package net.tribe7.common.collect;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.tribe7.common.annotations.GwtCompatible;
import net.tribe7.common.base.Preconditions;
import net.tribe7.common.collect.ForwardingCollection;
import net.tribe7.common.collect.Sets;

@GwtCompatible
public abstract class ForwardingSet<E>
extends ForwardingCollection<E>
implements Set<E> {
    protected ForwardingSet() {
    }

    @Override
    protected abstract Set<E> delegate();

    @Override
    public boolean equals(@Nullable Object object) {
        return object == this || this.delegate().equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    @Override
    protected boolean standardRemoveAll(Collection<?> collection) {
        return Sets.removeAllImpl(this, (Collection)Preconditions.checkNotNull(collection));
    }

    protected boolean standardEquals(@Nullable Object object) {
        return Sets.equalsImpl(this, object);
    }

    protected int standardHashCode() {
        return Sets.hashCodeImpl(this);
    }
}

