/*
 * Decompiled with CFR 0.152.
 */
package net.tribe7.common.cache;

import java.util.concurrent.atomic.AtomicLong;
import net.tribe7.common.annotations.GwtCompatible;
import net.tribe7.common.base.Supplier;
import net.tribe7.common.cache.LongAddable;
import net.tribe7.common.cache.LongAdder;

@GwtCompatible(emulated=true)
final class LongAddables {
    private static final Supplier<LongAddable> SUPPLIER;

    LongAddables() {
    }

    public static LongAddable create() {
        return (LongAddable)SUPPLIER.get();
    }

    static {
        Object supplier;
        try {
            new LongAdder();
            supplier = new Supplier<LongAddable>(){

                public LongAddable get() {
                    return new LongAdder();
                }
            };
        }
        catch (Throwable t) {
            supplier = new Supplier<LongAddable>(){

                public LongAddable get() {
                    return new PureJavaLongAddable();
                }
            };
        }
        SUPPLIER = supplier;
    }

    private static final class PureJavaLongAddable
    extends AtomicLong
    implements LongAddable {
        private PureJavaLongAddable() {
        }

        @Override
        public void increment() {
            this.getAndIncrement();
        }

        @Override
        public void add(long x) {
            this.getAndAdd(x);
        }

        @Override
        public long sum() {
            return this.get();
        }
    }
}

