/*
 * Decompiled with CFR 0.152.
 */
package net.tribe7.common.cache;

import java.io.Serializable;
import java.util.Map;
import net.tribe7.common.annotations.Beta;
import net.tribe7.common.annotations.GwtCompatible;
import net.tribe7.common.annotations.GwtIncompatible;
import net.tribe7.common.base.Function;
import net.tribe7.common.base.Preconditions;
import net.tribe7.common.base.Supplier;
import net.tribe7.common.util.concurrent.Futures;
import net.tribe7.common.util.concurrent.ListenableFuture;

@GwtCompatible(emulated=true)
public abstract class CacheLoader<K, V> {
    protected CacheLoader() {
    }

    public abstract V load(K var1) throws Exception;

    @GwtIncompatible(value="Futures")
    public ListenableFuture<V> reload(K key, V oldValue) throws Exception {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(oldValue);
        return Futures.immediateFuture(this.load(key));
    }

    public Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
        throw new UnsupportedLoadingOperationException();
    }

    @Beta
    public static <K, V> CacheLoader<K, V> from(Function<K, V> function) {
        return new FunctionToCacheLoader<K, V>(function);
    }

    @Beta
    public static <V> CacheLoader<Object, V> from(Supplier<V> supplier) {
        return new SupplierToCacheLoader<V>(supplier);
    }

    public static final class InvalidCacheLoadException
    extends RuntimeException {
        public InvalidCacheLoadException(String message) {
            super(message);
        }
    }

    static final class UnsupportedLoadingOperationException
    extends UnsupportedOperationException {
        UnsupportedLoadingOperationException() {
        }
    }

    private static final class SupplierToCacheLoader<V>
    extends CacheLoader<Object, V>
    implements Serializable {
        private final Supplier<V> computingSupplier;
        private static final long serialVersionUID = 0L;

        public SupplierToCacheLoader(Supplier<V> computingSupplier) {
            this.computingSupplier = (Supplier)Preconditions.checkNotNull(computingSupplier);
        }

        @Override
        public V load(Object key) {
            Preconditions.checkNotNull((Object)key);
            return (V)this.computingSupplier.get();
        }
    }

    private static final class FunctionToCacheLoader<K, V>
    extends CacheLoader<K, V>
    implements Serializable {
        private final Function<K, V> computingFunction;
        private static final long serialVersionUID = 0L;

        public FunctionToCacheLoader(Function<K, V> computingFunction) {
            this.computingFunction = (Function)Preconditions.checkNotNull(computingFunction);
        }

        @Override
        public V load(K key) {
            return (V)this.computingFunction.apply(Preconditions.checkNotNull(key));
        }
    }
}

