/*
 * Decompiled with CFR 0.152.
 */
package net.tribe7.common.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.tribe7.common.annotations.Beta;
import net.tribe7.common.cache.AbstractCache;
import net.tribe7.common.cache.LoadingCache;
import net.tribe7.common.collect.ImmutableMap;
import net.tribe7.common.collect.Maps;
import net.tribe7.common.util.concurrent.UncheckedExecutionException;

@Beta
public abstract class AbstractLoadingCache<K, V>
extends AbstractCache<K, V>
implements LoadingCache<K, V> {
    protected AbstractLoadingCache() {
    }

    @Override
    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (K key : keys) {
            if (result.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return ImmutableMap.copyOf((Map)result);
    }

    @Override
    public final V apply(K key) {
        return this.getUnchecked(key);
    }

    @Override
    public void refresh(K key) {
        throw new UnsupportedOperationException();
    }
}

