/*
 * Decompiled with CFR 0.152.
 */
package net.tribe7.common.cache;

import java.util.concurrent.Executor;
import net.tribe7.common.annotations.Beta;
import net.tribe7.common.base.Preconditions;
import net.tribe7.common.cache.RemovalListener;
import net.tribe7.common.cache.RemovalNotification;

@Beta
public final class RemovalListeners {
    private RemovalListeners() {
    }

    public static <K, V> RemovalListener<K, V> asynchronous(final RemovalListener<K, V> listener, final Executor executor) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull((Object)executor);
        return new RemovalListener<K, V>(){

            @Override
            public void onRemoval(final RemovalNotification<K, V> notification) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onRemoval(notification);
                    }
                });
            }
        };
    }
}

