/*
 * Decompiled with CFR 0.152.
 */
package net.tribe7.common.cache;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import net.tribe7.common.annotations.Beta;
import net.tribe7.common.annotations.GwtCompatible;
import net.tribe7.common.annotations.GwtIncompatible;
import net.tribe7.common.base.Ascii;
import net.tribe7.common.base.Equivalence;
import net.tribe7.common.base.Objects;
import net.tribe7.common.base.Preconditions;
import net.tribe7.common.base.Supplier;
import net.tribe7.common.base.Suppliers;
import net.tribe7.common.base.Ticker;
import net.tribe7.common.cache.AbstractCache;
import net.tribe7.common.cache.Cache;
import net.tribe7.common.cache.CacheBuilderSpec;
import net.tribe7.common.cache.CacheLoader;
import net.tribe7.common.cache.CacheStats;
import net.tribe7.common.cache.LoadingCache;
import net.tribe7.common.cache.LocalCache;
import net.tribe7.common.cache.RemovalListener;
import net.tribe7.common.cache.RemovalNotification;
import net.tribe7.common.cache.Weigher;

@GwtCompatible(emulated=true)
public final class CacheBuilder<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 4;
    private static final int DEFAULT_EXPIRATION_NANOS = 0;
    private static final int DEFAULT_REFRESH_NANOS = 0;
    static final Supplier<? extends AbstractCache.StatsCounter> NULL_STATS_COUNTER = Suppliers.ofInstance((Object)new AbstractCache.StatsCounter(){

        @Override
        public void recordHits(int count) {
        }

        @Override
        public void recordMisses(int count) {
        }

        @Override
        public void recordLoadSuccess(long loadTime) {
        }

        @Override
        public void recordLoadException(long loadTime) {
        }

        @Override
        public void recordEviction() {
        }

        @Override
        public CacheStats snapshot() {
            return EMPTY_STATS;
        }
    });
    static final CacheStats EMPTY_STATS = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);
    static final Supplier<AbstractCache.StatsCounter> CACHE_STATS_COUNTER = new Supplier<AbstractCache.StatsCounter>(){

        public AbstractCache.StatsCounter get() {
            return new AbstractCache.SimpleStatsCounter();
        }
    };
    static final Ticker NULL_TICKER = new Ticker(){

        public long read() {
            return 0L;
        }
    };
    private static final Logger logger = Logger.getLogger(CacheBuilder.class.getName());
    static final int UNSET_INT = -1;
    boolean strictParsing = true;
    int initialCapacity = -1;
    int concurrencyLevel = -1;
    long maximumSize = -1L;
    long maximumWeight = -1L;
    Weigher<? super K, ? super V> weigher;
    LocalCache.Strength keyStrength;
    LocalCache.Strength valueStrength;
    long expireAfterWriteNanos = -1L;
    long expireAfterAccessNanos = -1L;
    long refreshNanos = -1L;
    Equivalence<Object> keyEquivalence;
    Equivalence<Object> valueEquivalence;
    RemovalListener<? super K, ? super V> removalListener;
    Ticker ticker;
    Supplier<? extends AbstractCache.StatsCounter> statsCounterSupplier = NULL_STATS_COUNTER;

    CacheBuilder() {
    }

    public static CacheBuilder<Object, Object> newBuilder() {
        return new CacheBuilder<Object, Object>();
    }

    @Beta
    @GwtIncompatible(value="To be supported")
    public static CacheBuilder<Object, Object> from(CacheBuilderSpec spec) {
        return spec.toCacheBuilder().lenientParsing();
    }

    @Beta
    @GwtIncompatible(value="To be supported")
    public static CacheBuilder<Object, Object> from(String spec) {
        return CacheBuilder.from(CacheBuilderSpec.parse(spec));
    }

    @GwtIncompatible(value="To be supported")
    CacheBuilder<K, V> lenientParsing() {
        this.strictParsing = false;
        return this;
    }

    @GwtIncompatible(value="To be supported")
    CacheBuilder<K, V> keyEquivalence(Equivalence<Object> equivalence) {
        Preconditions.checkState((this.keyEquivalence == null ? 1 : 0) != 0, (String)"key equivalence was already set to %s", (Object[])new Object[]{this.keyEquivalence});
        this.keyEquivalence = (Equivalence)Preconditions.checkNotNull(equivalence);
        return this;
    }

    Equivalence<Object> getKeyEquivalence() {
        return (Equivalence)Objects.firstNonNull(this.keyEquivalence, this.getKeyStrength().defaultEquivalence());
    }

    @GwtIncompatible(value="To be supported")
    CacheBuilder<K, V> valueEquivalence(Equivalence<Object> equivalence) {
        Preconditions.checkState((this.valueEquivalence == null ? 1 : 0) != 0, (String)"value equivalence was already set to %s", (Object[])new Object[]{this.valueEquivalence});
        this.valueEquivalence = (Equivalence)Preconditions.checkNotNull(equivalence);
        return this;
    }

    Equivalence<Object> getValueEquivalence() {
        return (Equivalence)Objects.firstNonNull(this.valueEquivalence, this.getValueStrength().defaultEquivalence());
    }

    public CacheBuilder<K, V> initialCapacity(int initialCapacity) {
        Preconditions.checkState((this.initialCapacity == -1 ? 1 : 0) != 0, (String)"initial capacity was already set to %s", (Object[])new Object[]{this.initialCapacity});
        Preconditions.checkArgument((initialCapacity >= 0 ? 1 : 0) != 0);
        this.initialCapacity = initialCapacity;
        return this;
    }

    int getInitialCapacity() {
        return this.initialCapacity == -1 ? 16 : this.initialCapacity;
    }

    public CacheBuilder<K, V> concurrencyLevel(int concurrencyLevel) {
        Preconditions.checkState((this.concurrencyLevel == -1 ? 1 : 0) != 0, (String)"concurrency level was already set to %s", (Object[])new Object[]{this.concurrencyLevel});
        Preconditions.checkArgument((concurrencyLevel > 0 ? 1 : 0) != 0);
        this.concurrencyLevel = concurrencyLevel;
        return this;
    }

    int getConcurrencyLevel() {
        return this.concurrencyLevel == -1 ? 4 : this.concurrencyLevel;
    }

    public CacheBuilder<K, V> maximumSize(long size) {
        Preconditions.checkState((this.maximumSize == -1L ? 1 : 0) != 0, (String)"maximum size was already set to %s", (Object[])new Object[]{this.maximumSize});
        Preconditions.checkState((this.maximumWeight == -1L ? 1 : 0) != 0, (String)"maximum weight was already set to %s", (Object[])new Object[]{this.maximumWeight});
        Preconditions.checkState((this.weigher == null ? 1 : 0) != 0, (Object)"maximum size can not be combined with weigher");
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"maximum size must not be negative");
        this.maximumSize = size;
        return this;
    }

    @GwtIncompatible(value="To be supported")
    public CacheBuilder<K, V> maximumWeight(long weight) {
        Preconditions.checkState((this.maximumWeight == -1L ? 1 : 0) != 0, (String)"maximum weight was already set to %s", (Object[])new Object[]{this.maximumWeight});
        Preconditions.checkState((this.maximumSize == -1L ? 1 : 0) != 0, (String)"maximum size was already set to %s", (Object[])new Object[]{this.maximumSize});
        this.maximumWeight = weight;
        Preconditions.checkArgument((weight >= 0L ? 1 : 0) != 0, (Object)"maximum weight must not be negative");
        return this;
    }

    @GwtIncompatible(value="To be supported")
    public <K1 extends K, V1 extends V> CacheBuilder<K1, V1> weigher(Weigher<? super K1, ? super V1> weigher) {
        Preconditions.checkState((this.weigher == null ? 1 : 0) != 0);
        if (this.strictParsing) {
            Preconditions.checkState((this.maximumSize == -1L ? 1 : 0) != 0, (String)"weigher can not be combined with maximum size", (Object[])new Object[]{this.maximumSize});
        }
        CacheBuilder me = this;
        me.weigher = (Weigher)Preconditions.checkNotNull(weigher);
        return me;
    }

    long getMaximumWeight() {
        if (this.expireAfterWriteNanos == 0L || this.expireAfterAccessNanos == 0L) {
            return 0L;
        }
        return this.weigher == null ? this.maximumSize : this.maximumWeight;
    }

    <K1 extends K, V1 extends V> Weigher<K1, V1> getWeigher() {
        return (Weigher)Objects.firstNonNull(this.weigher, (Object)OneWeigher.INSTANCE);
    }

    @GwtIncompatible(value="java.lang.ref.WeakReference")
    public CacheBuilder<K, V> weakKeys() {
        return this.setKeyStrength(LocalCache.Strength.WEAK);
    }

    CacheBuilder<K, V> setKeyStrength(LocalCache.Strength strength) {
        Preconditions.checkState((this.keyStrength == null ? 1 : 0) != 0, (String)"Key strength was already set to %s", (Object[])new Object[]{this.keyStrength});
        this.keyStrength = (LocalCache.Strength)((Object)Preconditions.checkNotNull((Object)((Object)strength)));
        return this;
    }

    LocalCache.Strength getKeyStrength() {
        return (LocalCache.Strength)((Object)Objects.firstNonNull((Object)((Object)this.keyStrength), (Object)((Object)LocalCache.Strength.STRONG)));
    }

    @GwtIncompatible(value="java.lang.ref.WeakReference")
    public CacheBuilder<K, V> weakValues() {
        return this.setValueStrength(LocalCache.Strength.WEAK);
    }

    @GwtIncompatible(value="java.lang.ref.SoftReference")
    public CacheBuilder<K, V> softValues() {
        return this.setValueStrength(LocalCache.Strength.SOFT);
    }

    CacheBuilder<K, V> setValueStrength(LocalCache.Strength strength) {
        Preconditions.checkState((this.valueStrength == null ? 1 : 0) != 0, (String)"Value strength was already set to %s", (Object[])new Object[]{this.valueStrength});
        this.valueStrength = (LocalCache.Strength)((Object)Preconditions.checkNotNull((Object)((Object)strength)));
        return this;
    }

    LocalCache.Strength getValueStrength() {
        return (LocalCache.Strength)((Object)Objects.firstNonNull((Object)((Object)this.valueStrength), (Object)((Object)LocalCache.Strength.STRONG)));
    }

    public CacheBuilder<K, V> expireAfterWrite(long duration, TimeUnit unit) {
        Preconditions.checkState((this.expireAfterWriteNanos == -1L ? 1 : 0) != 0, (String)"expireAfterWrite was already set to %s ns", (Object[])new Object[]{this.expireAfterWriteNanos});
        Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0, (String)"duration cannot be negative: %s %s", (Object[])new Object[]{duration, unit});
        this.expireAfterWriteNanos = unit.toNanos(duration);
        return this;
    }

    long getExpireAfterWriteNanos() {
        return this.expireAfterWriteNanos == -1L ? 0L : this.expireAfterWriteNanos;
    }

    public CacheBuilder<K, V> expireAfterAccess(long duration, TimeUnit unit) {
        Preconditions.checkState((this.expireAfterAccessNanos == -1L ? 1 : 0) != 0, (String)"expireAfterAccess was already set to %s ns", (Object[])new Object[]{this.expireAfterAccessNanos});
        Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0, (String)"duration cannot be negative: %s %s", (Object[])new Object[]{duration, unit});
        this.expireAfterAccessNanos = unit.toNanos(duration);
        return this;
    }

    long getExpireAfterAccessNanos() {
        return this.expireAfterAccessNanos == -1L ? 0L : this.expireAfterAccessNanos;
    }

    @Beta
    @GwtIncompatible(value="To be supported (synchronously).")
    public CacheBuilder<K, V> refreshAfterWrite(long duration, TimeUnit unit) {
        Preconditions.checkNotNull((Object)((Object)unit));
        Preconditions.checkState((this.refreshNanos == -1L ? 1 : 0) != 0, (String)"refresh was already set to %s ns", (Object[])new Object[]{this.refreshNanos});
        Preconditions.checkArgument((duration > 0L ? 1 : 0) != 0, (String)"duration must be positive: %s %s", (Object[])new Object[]{duration, unit});
        this.refreshNanos = unit.toNanos(duration);
        return this;
    }

    long getRefreshNanos() {
        return this.refreshNanos == -1L ? 0L : this.refreshNanos;
    }

    public CacheBuilder<K, V> ticker(Ticker ticker) {
        Preconditions.checkState((this.ticker == null ? 1 : 0) != 0);
        this.ticker = (Ticker)Preconditions.checkNotNull((Object)ticker);
        return this;
    }

    Ticker getTicker(boolean recordsTime) {
        if (this.ticker != null) {
            return this.ticker;
        }
        return recordsTime ? Ticker.systemTicker() : NULL_TICKER;
    }

    @CheckReturnValue
    public <K1 extends K, V1 extends V> CacheBuilder<K1, V1> removalListener(RemovalListener<? super K1, ? super V1> listener) {
        Preconditions.checkState((this.removalListener == null ? 1 : 0) != 0);
        CacheBuilder me = this;
        me.removalListener = (RemovalListener)Preconditions.checkNotNull(listener);
        return me;
    }

    <K1 extends K, V1 extends V> RemovalListener<K1, V1> getRemovalListener() {
        return (RemovalListener)Objects.firstNonNull(this.removalListener, (Object)NullListener.INSTANCE);
    }

    public CacheBuilder<K, V> recordStats() {
        this.statsCounterSupplier = CACHE_STATS_COUNTER;
        return this;
    }

    Supplier<? extends AbstractCache.StatsCounter> getStatsCounterSupplier() {
        return this.statsCounterSupplier;
    }

    public <K1 extends K, V1 extends V> LoadingCache<K1, V1> build(CacheLoader<? super K1, V1> loader) {
        this.checkWeightWithWeigher();
        return new LocalCache.LocalLoadingCache<K1, V1>(this, loader);
    }

    public <K1 extends K, V1 extends V> Cache<K1, V1> build() {
        this.checkWeightWithWeigher();
        this.checkNonLoadingCache();
        return new LocalCache.LocalManualCache(this);
    }

    private void checkNonLoadingCache() {
        Preconditions.checkState((this.refreshNanos == -1L ? 1 : 0) != 0, (Object)"refreshAfterWrite requires a LoadingCache");
    }

    private void checkWeightWithWeigher() {
        if (this.weigher == null) {
            Preconditions.checkState((this.maximumWeight == -1L ? 1 : 0) != 0, (Object)"maximumWeight requires weigher");
        } else if (this.strictParsing) {
            Preconditions.checkState((this.maximumWeight != -1L ? 1 : 0) != 0, (Object)"weigher requires maximumWeight");
        } else if (this.maximumWeight == -1L) {
            logger.log(Level.WARNING, "ignoring weigher specified without maximumWeight");
        }
    }

    public String toString() {
        Objects.ToStringHelper s = Objects.toStringHelper((Object)this);
        if (this.initialCapacity != -1) {
            s.add("initialCapacity", this.initialCapacity);
        }
        if (this.concurrencyLevel != -1) {
            s.add("concurrencyLevel", this.concurrencyLevel);
        }
        if (this.maximumSize != -1L) {
            s.add("maximumSize", this.maximumSize);
        }
        if (this.maximumWeight != -1L) {
            s.add("maximumWeight", this.maximumWeight);
        }
        if (this.expireAfterWriteNanos != -1L) {
            s.add("expireAfterWrite", (Object)(this.expireAfterWriteNanos + "ns"));
        }
        if (this.expireAfterAccessNanos != -1L) {
            s.add("expireAfterAccess", (Object)(this.expireAfterAccessNanos + "ns"));
        }
        if (this.keyStrength != null) {
            s.add("keyStrength", (Object)Ascii.toLowerCase((String)this.keyStrength.toString()));
        }
        if (this.valueStrength != null) {
            s.add("valueStrength", (Object)Ascii.toLowerCase((String)this.valueStrength.toString()));
        }
        if (this.keyEquivalence != null) {
            s.addValue((Object)"keyEquivalence");
        }
        if (this.valueEquivalence != null) {
            s.addValue((Object)"valueEquivalence");
        }
        if (this.removalListener != null) {
            s.addValue((Object)"removalListener");
        }
        return s.toString();
    }

    static enum OneWeigher implements Weigher<Object, Object>
    {
        INSTANCE;


        @Override
        public int weigh(Object key, Object value) {
            return 1;
        }
    }

    static enum NullListener implements RemovalListener<Object, Object>
    {
        INSTANCE;


        @Override
        public void onRemoval(RemovalNotification<Object, Object> notification) {
        }
    }
}

