/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.example.authn;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Info;
import io.swagger.annotations.SwaggerDefinition;
import java.net.URI;
import javax.annotation.security.PermitAll;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import net.trajano.ms.auth.token.OAuthTokenResponse;
import net.trajano.ms.auth.util.HttpAuthorizationHeaders;
import net.trajano.ms.core.CryptoOps;
import net.trajano.ms.core.ErrorResponse;
import net.trajano.ms.core.ErrorResponses;
import net.trajano.ms.core.NonceObject;
import net.trajano.ms.core.NonceOps;
import org.jose4j.jwt.JwtClaims;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@SwaggerDefinition(info=@Info(title="Sample Authn Microservice", version="1.0"))
@Api
@Component
@Path(value="/authn")
@PermitAll
public class AuthnResource {
    @Value(value="${authorizationEndpoint}")
    private URI authorizationEndpoint;
    @Context
    private Client client;
    @Autowired
    private CryptoOps cryptoOps;
    @Autowired
    private NonceOps nonceProvider;
    @Value(value="${secure:#{true}}")
    private boolean secure;

    @GET
    @Path(value="/nonce")
    @Produces(value={"application/json"})
    public NonceObject getNonce() {
        return this.nonceProvider.newNonceObject();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=401, message="Unauthorized Response", response=ErrorResponse.class)})
    public Response json(@FormParam(value="j_username") @ApiParam(value="User name") String username, @FormParam(value="j_password") @ApiParam(value="Password") String password, @FormParam(value="nonce") @ApiParam(value="nonce") String nonce, @HeaderParam(value="Authorization") String authorization) {
        if (nonce == null) {
            throw ErrorResponses.invalidRequest((String)"missing nonce");
        }
        if (!this.nonceProvider.claimNonce(nonce)) {
            throw ErrorResponses.invalidRequest((String)"invalid nonce");
        }
        if (!"password".equals(password)) {
            throw ErrorResponses.unauthorized((String)"unauthorized_client", (String)"invalid username/password combination", (String)"FORM");
        }
        JwtClaims claims = new JwtClaims();
        claims.setSubject(username);
        claims.setAudience(HttpAuthorizationHeaders.parseBasicAuthorization((String)authorization)[0]);
        Form form = new Form();
        form.param("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer");
        form.param("assertion", this.cryptoOps.sign(claims));
        return Response.ok((Object)this.client.target(this.authorizationEndpoint).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)authorization).post(Entity.form((Form)form), OAuthTokenResponse.class)).cookie(new NewCookie[]{new NewCookie("nonce", "", null, null, null, 0, this.secure, true)}).build();
    }
}

